<?php

use Illuminate\Support\Facades\Session;

function ApiBaseUrl()
{
    $data = array(
        'url' => 'https://aspgen.vaaptech.com:9000/',
        // 'url' => 'https://aspgenpre.vaaptech.com:9000',
        // 'productID' => '62c807133d9ee4045ab78d4d',
        'productID' => '62c807133d9ee4045ab78d4d',
        // 'clientID' => '660517ea128a5f5064039640'
        'clientID' => '663a5e9a9f155e1f2e7d0f49'
    );
    return $data;
}

function filterAPI()
{
    $data = array(
        'url' => 'api/appgen/filterAPI'
    );
    return $data;
}

function getWebSyncsData($moduleName, $aspectType, $status = '')
{

    if ($status != '') {
        $query = [
            'aspectType' => $aspectType,
            'status' => $status,
        ];
    } else {
        $query =  ['aspectType' => $aspectType];
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    $productID = ApiBaseUrl()['productID'];
    $clientID = ApiBaseUrl()['clientID'];
    $post_data = [
        'componentConfig' => [
            'moduleName' => $moduleName,
            'aspectType' => $aspectType,
            'query' => $query,
            'productID' => $productID,
            'clientID' => $clientID,
            'skip' => 0,
            'next' => 1220,
        ],
    ];
    $dataJson = json_encode($post_data);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

    $headers = array();

    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return isset($response['data']) ?  $response['data'] : array();
}

function sortBySequenceId($array)
{
    $sequenceIds = array();
    foreach ($array as $event) {
        $sequenceId = isset($event['sequenceId']) ? $event['sequenceId'] : PHP_INT_MAX;
        $sequenceIds[] = $sequenceId;
    }
    array_multisort($sequenceIds, SORT_ASC, $array);

    return $array;
}

function getServiceRequestData($filter)
{
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Constructing the data array
    $postData = array(
        'componentConfig' => array(
            'query' => $filter['query'], // Using the provided query parameter
            'moduleName' => 'Temple Services',
            'aspectType' => 'ServiceSetup',
            'collectionType' => 'Business',
            'productID' => ApiBaseUrl()['productID'],
            'clientID' => ApiBaseUrl()['clientID'],
            'skip' => 0,
            'next' => 1024
        )
    );

    // Encode the data array into JSON
    $postDataJson = json_encode($postData);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

    $headers = array();
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);

    return isset($response['data']) ?  $response['data'] : array();
}


function format_event_date($start_date = '', $end_date = '', $start_time = '', $end_time = '')
{

    // Convert US date format to DateTime object
    if (!empty($start_date)) {
        $start_date = DateTime::createFromFormat('m/d/Y', $start_date);
    } else {
        $start_date = '';
    }
    if (!empty($end_date)) {
        $end_date = DateTime::createFromFormat('m/d/Y', $end_date);
    } else {
        $end_date = '';
    }

    // Convert start and end times to DateTime object
    if (!empty($start_time)) {
        $start_time = DateTime::createFromFormat('g:i A', $start_time);
    } else {
        $start_time = '';
    }
    if (!empty($end_time)) {
        $end_time = DateTime::createFromFormat('g:i A', $end_time);
    } else {
        $end_time = '';
    }

    // Format the date range string
    $date_range = '';
    if ($start_date && $end_date) {
        // If start and end dates are in the same month and year
        if ($start_date->format('mY') == $end_date->format('mY')) {
            $start_day = $start_date->format('d');
            $end_day = $end_date->format('d');
            // If the start and end days are the same, only show one day
            if ($start_day == $end_day) {
                $date_range = $start_date->format('M d');
            } else {
                $date_range = $start_date->format('M d') . ' - ' . $end_date->format('d');
            }
        } else {
            $date_range = $start_date->format('M d') . ' - ' . $end_date->format('M d');
        }
    } else {
        // If either start or end date is missing
        $date_range = ($start_date ? $start_date->format('M d') : '') . ($end_date ? ' - ' . $end_date->format('M d') : '');
    }

    // Format the time range string
    if (($end_time ? $end_time->format('A') : '') == ($start_time ? $start_time->format('A') : '')) {
        $time_range = ($start_time ? $start_time->format('g:i') : '') . ($end_time ? ' - ' . $end_time->format('g:i A') : '');
    } else {
        $time_range = ($start_time ? $start_time->format('g:i A') : '') . ($end_time ? ' - ' . $end_time->format('g:i A') : '');
    }

    // Combine date and time strings and return
    return ($date_range ? $date_range : '') . ($time_range ? ($date_range ? ' | ' . $time_range : $time_range) : '');
}


function getPanchangamData($lat, $long, $tzone, $year, $month, $day, $hours, $minute)
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $url = 'https://vedicrishi-horoscope-matching-v1.p.rapidapi.com/basic_panchang/';
    $data = array(
        'day'   => $day,
        'month' => $month,
        'year'  => $year,
        'hour'  => $hours,
        'min'   => $minute,
        'lat'   => $lat,
        'lon'   => $long,
        'tzone' => $tzone
    );

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $headers = array(
        'X-Rapidapi-Host: vedicrishi-horoscope-matching-v1.p.rapidapi.com',
        'X-Rapidapi-Key: c134901be4mshe8183baaade0a64p1b5249jsnb1b2b8a71111',
        'Content-Type: application/json'
    );

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);
    return $response;
}


function getUserDetails()
{
    if (Session::get('logged_in') == 1) {
        $email = base64_decode(Session::get('email'));
        $phone = base64_decode(Session::get('phone'));

        if (!empty($email)) {
            $data = array('email' => $email, 'isMobile' => false, 'phone' => '');
        } elseif (!empty($phone)) {
            $data = array('email' => '', 'isMobile' => true, 'phone' => $phone);
        }

        $postfield = json_encode($data);

        if (Session::get('userType') == 'Managements') {
            $moduleName = 'Management Directory';
        } else {
            $moduleName = customerLogin()['moduleName'];
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . customerLogin()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{"dataJson": ' . $postfield . ',
			"componentConfig": {"moduleName": "' . $moduleName . '","productID": "' . ApiBaseUrl()['productID'] . '","clientID": "' . ApiBaseUrl()['clientID'] . '"}}');
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $response = json_decode($result);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        return $response;
    } else {
        return redirect()->route('home');
    }
}

function customerLogin()
{
    $data = array(
        'url' => "api/customerDetails/customerLoginWeb",
        'moduleName' => "Contacts"
    );
    return $data;
}

function getProjectName()
{
    if (defined('PROJECT_NAME') && PROJECT_NAME !== null && PROJECT_NAME !== '') {
        return PROJECT_NAME;
    } else {
        return 'Carolina Murugan Temple';
    }
}
function filterValidData($data)
{
    if (!empty($data['endDate'])) {
        $endDateTimestamp = strtotime($data['endDate']);
        $currentTimestamp = time();
        if ($endDateTimestamp >= $currentTimestamp) {
            return 1;
        }
    } else if (!empty($data['startDate'])) {
        $startDateTimestamp = strtotime($data['startDate']);
        $currentTimestamp = time();
        if ($startDateTimestamp >= $currentTimestamp) {
            return 1;
        }
    } else {
        return 1;
    }
    return 0;
}

function formatPhoneNumber($phoneNumber)
{
    $phoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

    if (strlen($phoneNumber) > 10) {
        $countryCode = substr($phoneNumber, 0, strlen($phoneNumber) - 10);
        $areaCode = substr($phoneNumber, -10, 3);
        $nextThree = substr($phoneNumber, -7, 3);
        $lastFour = substr($phoneNumber, -4, 4);

        $phoneNumber = '+' . $countryCode . ' (' . $areaCode . ') ' . $nextThree . '-' . $lastFour;
    } else if (strlen($phoneNumber) == 10) {
        $areaCode = substr($phoneNumber, 0, 3);
        $nextThree = substr($phoneNumber, 3, 3);
        $lastFour = substr($phoneNumber, 6, 4);

        $phoneNumber = '' . $areaCode . '-' . $nextThree . '-' . $lastFour;
    } else if (strlen($phoneNumber) == 7) {
        $nextThree = substr($phoneNumber, 0, 3);
        $lastFour = substr($phoneNumber, 3, 4);

        $phoneNumber = $nextThree . '-' . $lastFour;
    }

    return $phoneNumber;
}
function camelCase($str)
{
    $str = ucwords(strtolower($str));
    return $str;
}

function upcomingevents()
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    $productID = ApiBaseUrl()['productID'];
    $clientID = ApiBaseUrl()['clientID'];
    $post_data = [
        'componentConfig' => [
            'moduleName' => 'Temple Events',
            'aspectType' => 'ServiceSetup',
            'query' => [
                'aspectType' => 'ServiceSetup',
            ],
            'productID' => $productID,
            'clientID' => $clientID,
            'skip' => 0,
            'next' => 1220,
        ],
    ];
    $dataJson = json_encode($post_data);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

    $headers = array();

    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return $response;
}
function GeneralSettings()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $baseUrl = ApiBaseUrl();
    $settingsUrl = settings();

    curl_setopt($ch, CURLOPT_URL, $baseUrl['url'] . $settingsUrl['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "action" => "getClientSetting",
        "productId" => $baseUrl['productID'],
        "clientId" => $baseUrl['clientID']
    ]));

    $headers = array();
    $headers[] = 'Content-Type: application/json';

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        // Handle the error gracefully, maybe log it or throw an exception
        // Here we are just returning false
        return false;
    }

    curl_close($ch);

    $response = json_decode($result, true);
    return $response;

    if (isset($response['result']['data'][0]['generalSetting'])) {
        return $response['result']['data'][0]['generalSetting'];
    } else {
        // Handle the case where the expected data is not present in the response
        // Here we are just returning false
        return false;
    }
}

function getCurrencySymbol()
{
    $GeneralSettings = GeneralSettings();

    $currencySymbol = isset($GeneralSettings['currencySymbol']) ? (CheckEmptyNullVar($GeneralSettings['currencySymbol']) != '' ? $GeneralSettings['currencySymbol'] : '$') : '$';

    return $currencySymbol;
}
function settings()
{
    $data = array(
        'url' => 'api/appsettings/setting'
    );
    return $data;
}
function getServiceTypes()
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $url = ApiBaseUrl()['url'] . filterAPI()['url'];

    $data = array(
        'componentConfig' => array(
            'query' => array(
                // 'aspectType' => 'servicesDisplayGroup'
                'aspectType' => 'serviceCategoryTypes'
            ),
            'moduleName' => 'Master Data Management',
            // 'aspectType' => 'servicesDisplayGroup',
            'aspectType' => 'serviceCategoryTypes',
            // 'collectionType' => 'Business',
            'productID' => ApiBaseUrl()['productID'],
            'clientID' => ApiBaseUrl()['clientID'],
            'skip' => 0,
            'next' => 1000
        )
    );

    $headers = array(
        'Content-Type: application/json'
    );

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    $response = json_decode($result);

    return json_decode(json_encode($response->data), true);
}

// getServicesBySerivceType
function getServicesByServiceType($serviceCategory, $session_data)
{
    // function getServicesByServiceType($serviceCategory,$serviceType, $session_data){
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    // \"serviceTypes\":\"".$serviceType."\",
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
            "componentConfig": {
                "query": {
                    "aspectType": "ServiceSetup",
                    "serviceCategoryTypes": "' . $serviceCategory . '",
                    "sourceTypes": "WEBSITE",
                    "status": "ACTIVE"
                    },
                    "moduleName": "Temple Services",
                    "aspectType": "ServiceSetup",
                    "collectionType": "Business",
                    "productID": "' . ApiBaseUrl()['productID'] . '",
                    "clientID": "' . ApiBaseUrl()['clientID'] . '",
                    "skip": 0,
                    "next": 20
                }
            }');


    // $token = $CI->session->userdata('token');
    $token = session('token');

    $headers = array();
    $headers[] = 'Authorization: Bearer ' . $token . '';
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);
    $services = json_decode(json_encode($response->data), true);
    $services = sortBySequenceId($services);

    $currency = GeneralSettings();

    $html = '';

    // echo '<pre>';
    //dd($services);
    // die;
    if ($services != array()) {

        foreach ($services as $key => $item) {
            $isValid = filterValidData($item);
            if ($isValid == 1) {
                $includeSankalpam = 'NO';
                if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

                    $includeSankalpam = 'YES';
                }
                $cartDateCount = 1;
                if (in_array($item['_id'], $session_data['ids'])) {
                    $newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
                    $cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

                    if (!empty($cartDate)) {
                        $cartDateCount = count(explode(',', $cartDate));
                    }
                }
                if ($item['qtyCounter'] == 'YES') {
                    $quantityContainer_display = 'inline-flex';
                } else {
                    $quantityContainer_display = 'none';
                }
                if (isset($item['Image']) && !empty($item['Image'])) {
                    $src = ApiBaseUrl()['url'] . $item['Image'];
                } else {
                    $src = asset('assets/img/services-listing.png');
                }

                if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

                    if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

                        $bookingType = 'PAY NOW';
                    } else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
                        $bookingType = 'PAY LATER';
                    } else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
                        $bookingType = 'OPTIONAL';
                    } else {
                        $bookingType = 'PAY NOW';
                    }
                } else {
                    $bookingType = 'PAY NOW';
                }

                if ($item['serviceAmount'] != 0) {
                    $is_availibility_check = checkServiceAvailability(isset($item['isAvailable']), $item);
                    // dd($is_availibility_check);
                    $available_count_design = '';
                    $filter_color = '';
                    $available_count = '';
                    $disable_input_field = '';

                    if ($is_availibility_check == 1) {
                        $available_count_design = '';
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {

                        if ($is_availibility_check == 3) {
                            if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                $available_count_design = ' <a href="javascript:void(0)">
                                    <div class="mask">
                                    <div class="d-flex justify-content-start align-items-end h-100">
                                    <h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
                                    </div>
                                    </div>
                                    <div class="hover-overlay">
                                    <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                                    </div>
                                    </a>';
                            } else {
                                $available_count_design = ' <a href="javascript:void(0)">
                                    <div class="mask">
                                    <div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
                                    <h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
                                    </div>
                                    </div>
                                    <div class="hover-overlay">
                                    <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                                    </div>
                                    </a>';
                            }
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
                                <input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . $includeSankalpam . '"  available_count="' . $item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
                                </div>';
                        } else if ($is_availibility_check == 2) {
                            $filter_color = 'filter: grayscale(1);';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            $disable_input_field = 'disabled readonly';
                        } else {
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
                                <input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . $includeSankalpam . '"  available_count="' . isset($item['AvailableCount']) . '" style="padding:14px!important" is_date_required="' . isset($item['isDTVisible']) . '">
                                </div>';
                        }
                    }



                    $limitPerdayFeature = '';
                    $BookingLimitPerDay  = CheckEmptyNullVar(isset($item['BookingLimitPerDay']));
                    $BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

                    if ($BookingLimitPerDay > 0) {

                        $limitPerdayFeature     .= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
                    } else {
                        $limitPerdayFeature     .= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
                    }


                    if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
                        $dateTimeCode = '';
                        $dateTimeCode = '<div class="row m-0 pt-3">
                            <div class="col-md-4 m-0 p-0">
                            <div class="input-group">
                            <span class="input-group-text" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

                            ' . $limitPerdayFeature . '
                            </div>
                            </div>

                            <div class="col-md-4 p-0">

                            <div class="input-group">
                            <span class="input-group-text" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

                            <input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
                            </div>

                            </div>

                            </div>';
                    } else {
                        $dateTimeCode = '';
                    }

                    if (isset($item['description']) && $item['description'] != '') {
                        $descriptionWithEyeIcon = '

                            <span class="fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
                            ' . $item['description'] . '
                            </span>
                            <span>

                            </span>';
                    } else {
                        $descriptionWithEyeIcon = '';
                    }


                    if ($item['qtyCounter'] != 'YES') {
                        $style_res_amount = 'display: flex!important;flex-direction: row;justify-content: flex-end;align-items: stretch;padding: 0px;border-left:1px solid white;';
                    } else {
                        $style_res_amount = 'display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;border-left:1px solid white;';
                    }


                    $pageLength = $key + 1;



                    $html .= '<div class="text-end d-none align-middle" style="background-color:#005D4B;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . isset($currency['currencySymbol']) . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
                        </div>
                        <div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
                        <div class="col-md-12 col-xl-12 px-0">
                        <div class="card shadow-0 border rounded-3 px-0">
                        <div class="card-body p-0 m-0">
                        <div class="row" id="searchHere" style="background-color:#005D4B;color:white">
                        <div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
                        <div class="bg-image hover-zoom ripple rounded ripple-surface">
                        <div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>
                        <a href="#!">
                        <div class="hover-overlay">
                        <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
                        </div>
                        </a>
                        </div>
                        </div>
                        <div class="col-md-6 col-lg-7 col-xl-7" style="background-color:#005d4b!important;display: flex; flex-direction: row; align-items: center;">
                        <div>
                        <label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br>
                        ' . $descriptionWithEyeIcon . '
                        ' . $dateTimeCode . '
                        </div>
                        </div>

                        <div class="col-md-6 col-lg-4 col-xl-4" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

                        <div class="res-amount" style="' . $style_res_amount . '">

                        <div class="quantity-container" style="display:' . $quantityContainer_display . '">

                        <button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: #005D4B;color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

                        <input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

                        <button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: #005D4B;color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

                        </div>

                        <span style="font-size:20px!important;font-weight:bold; ' . ($item['qtyCounter'] != 'YES' ?  'padding-right: 36px;' : '') . '" id="Totalprice_' . $item['_id'] . '">' . getCurrencySymbol() . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($item['serviceAmount']) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
                        ' . $checkbox . '
                        </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        <input type="hidden" value="' . $pageLength . '" id="pageLength">';
                } else {


                    $is_availibility_check = checkServiceAvailability($item['isAvailable'], $item);

                    $available_count_design = '';
                    $filter_color = '';
                    $available_count = '';
                    $disable_input_field = '';

                    if ($is_availibility_check == 1) {
                        $available_count_design = '';
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {

                        if ($is_availibility_check == 3) {
                            if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                $available_count_design = ' <a href="javascript:void(0)">
                                    <div class="mask">
                                    <div class="d-flex justify-content-start align-items-end h-100">
                                    <h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
                                    </div>
                                    </div>
                                    <div class="hover-overlay">
                                    <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                                    </div>
                                    </a>';
                            } else {
                                $available_count_design = ' <a href="javascript:void(0)">
                                    <div class="mask">
                                    <div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
                                    <h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
                                    </div>
                                    </div>
                                    <div class="hover-overlay">
                                    <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                                    </div>
                                    </a>';
                            }
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
                                <input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . $BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
                                </div>';
                        } else if ($is_availibility_check == 2) {
                            $filter_color = 'filter: grayscale(1);';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            $disable_input_field = 'disabled readonly';
                        } else {
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
                                <input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
                                </div>';
                        }
                    }



                    $html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
                        <td class="p-0 col-7 " style="color:#fff!important">
                        <div class="col-md-12 m-0 p-0">
                        <div class="row m-0 p-0">
                        <div class="col-md-2 m-0 p-0">
                        <div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 100px;width:100%;width: 83%;margin-left: 10px;">
                        ' . $available_count_design . '
                        </div>
                        </div>
                        <div class="col-md-10" style="background-color:#005d4b!important;">
                        <label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
                        <br>

                        <div class="row m-0 p-0">
                        <div class="col-md-3 m-0 p-0">
                        <div class="input-group">
                        <div class="input-group-addon" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
                        <label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
                        </div>

                        <input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


                        </div>
                        </div>
                        <div class="col-md-3">

                        <div class="input-group">
                        <div class="input-group-addon timepicker-services" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
                        <label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
                        </div>

                        <input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
                        </div>
                        </div>
                        </div>

                        </div>
                        </div>
                        </div>
                        </td>
                        <td class="text-center col-2 align-middle"  style="background-color:#005d4b;"><span></span></td>

                        <td colspan="2" class="text-end col-2 align-middle"  style="background-color:#005d4b;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;">


                        <span>Request A Service</span>
                        <span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
                        </td>

                        <td class="text-center col-1 align-middle" style="background-color:#005d4b;color:#000000!important;font-weight:bold;">
                        ' . $checkbox . '
                        </td>
                        </tr>';
                }
            }
        }
        $html .= '</tbody>

            </table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
    } else {
        $html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
    }


    return $html;
}

function CheckEmptyNullVar($val = '')
{
    if ($val == '' || $val == 'null') {
        return '';
    } else {
        return $val;
    }
}

// CheckSerivceAvailability
function checkServiceAvailability($isAvailable, $data)
{
    if ($isAvailable == 0) {
        return 0;
    } else if ($isAvailable == 1) {
        return 1;
    } else if ($isAvailable == 2) {

        // 	echo  date('h:i A').'    =   ';
        // echo $data['timedStartTime'].'    =   ';
        // echo  $data['timedEndTime'];
        $currentTime = strtotime(date('h:i A'));
        $startTime = strtotime($data['timedStartTime']);
        $endTime = strtotime($data['timedEndTime']);
        // Check if the current time is within the time range
        if ($currentTime >= $startTime && $currentTime <= $endTime) {
            return 2;
        }
        return 0;
    } else if ($isAvailable == 3) {

        if (isset($data['AvailableCount']) && $data['AvailableCount'] > 0) {
            return 3;
        } else {
            return 1;
        }
    }
    return 0;
}

//replacesingquotes
function replaceSingleQuotesWithBackticks($inputString)
{
    // Use str_replace to replace single quotes with backticks
    $outputString = str_replace("'", "`", $inputString);
    return $outputString;
}
// price format
function price_format($price, $zeroAfterPoint)
{

    return sprintf("%." . $zeroAfterPoint . "f", $price);
}

// getThithiNext90Days
function getThithiNext90Days($tithi)
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/event/getThithiNext90Days');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {\"moduleName\": \"Annual Registration\", \"aspectType\": \"annualRegistrations\",\"productID\": \"" . ApiBaseUrl()['productID'] . "\", \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", \"tithi\": \"" . $tithi . "\"}}");

    $headers = array();
    $headers[] = 'Content-Type: application/json';

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    $response = json_decode($result, true);


    return $response;
}

function customerSignup()
{

    $data = array(
        'url' => 'api/customerDetails/addCustomerDetailWeb',
        'moduleName' => 'Contacts'
    );
    return $data;
}
function sendEmailOTP()
{
    $data = array(
        'url' => 'api/auth/sendMemberAuthCode'
    );
    return $data;
}
function verifyEmailOTP()
{
    $data = array(
        'url' => 'api/auth/verifyMemberCode'
    );
    return $data;
}
function GetState()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'componentConfig' => [
            'moduleName' => 'Master Data Management',
            'productID' => ApiBaseUrl()['productID'],
            'clientID' => ApiBaseUrl()['clientID'],
            'aspectType' => 'stateTypes',
            'query' => [
                'aspectType' => 'stateTypes'
            ],
            'skip' => 0,
            'next' => 700
        ]
    ]));

    $headers = array();
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    $response = json_decode($result);

    return $response->data;
}
function getPreferredLanguage()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
        "componentConfig": {
            "moduleName": "Master Data Management",
            "productID": "' . ApiBaseUrl()['productID'] . '",
            "clientID": "' . ApiBaseUrl()['clientID'] . '",
            "aspectType": "languageTypes",
            "query": {
                "aspectType": "languageTypes"
            },
            "skip": 0,
            "next": 1024
        }
    }');

    $headers = array();
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);

    return json_decode($result);
}
function getPriest()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Assuming ApiBaseUrl() and filterAPI() are functions that return an array.
    $apiBaseUrl = ApiBaseUrl();
    $filterApi = filterAPI();

    curl_setopt($ch, CURLOPT_URL, $apiBaseUrl['url'] . $filterApi['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    // Properly escape and format the JSON data.
    $postData = [
        "componentConfig" => [
            "moduleName" => "Contacts",
            "productID" => $apiBaseUrl['productID'],
            "clientID" => $apiBaseUrl['clientID'],
            "aspectType" => "Member Directory",
            "query" => [
                "aspectType" => "Member Directory",
                "memberTypes" => "PRIEST",
                "status" => "ACTIVE"
            ],
            "skip" => 0,
            "next" => 1024
        ]
    ];
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

    $headers = [
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result, true); // Decoding as associative array

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    return $response;
}
function getNakshtra()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
        "componentConfig": {
            "moduleName": "Master Data Management",
            "productID": "' . ApiBaseUrl()['productID'] . '",
            "clientID": "' . ApiBaseUrl()['clientID'] . '",
            "aspectType": "nakshatraTypes",
            "query": {
                "aspectType": "nakshatraTypes"
            },
            "skip": 0,
            "next": 1024
        }
    }');

    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    return json_decode($result, true);
}
function getGotra()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
        "componentConfig": {
            "moduleName": "Master Data Management",
            "productID": "' . ApiBaseUrl()['productID'] . '",
            "clientID": "' . ApiBaseUrl()['clientID'] . '",
            "aspectType": "gotraTypes",
            "query": {
                "aspectType": "gotraTypes"
            },
            "skip": 0,
            "next": 1024
        }
    }');

    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    return json_decode($result, true);
}

function getRashi()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
        "componentConfig": {
            "moduleName": "Master Data Management",
            "productID": "' . ApiBaseUrl()['productID'] . '",
            "clientID": "' . ApiBaseUrl()['clientID'] . '",
            "aspectType": "rashiTypes",
            "query": {
                "aspectType": "rashiTypes"
            },
            "skip": 0,
            "next": 1024
        }
    }');

    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    return json_decode($result, true);
}
function backgroundMusic()
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    $productID = ApiBaseUrl()['productID'];
    $clientID = ApiBaseUrl()['clientID'];
    $post_data = [
        'componentConfig' => [
            'moduleName' => 'Background Music',
            'aspectType' => 'backgroundMusic',
            'query' => [
                'aspectType' => 'backgroundMusic',
            ],
            'productID' => $productID,
            'clientID' => $clientID,
            'skip' => 0,
            'next' => 1220,
        ],
    ];
    $dataJson = json_encode($post_data);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

    $headers = array();

    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return $response;
}
function checkForYesValue($array)
{
    foreach ($array as $value) {
        if ($value === "YES") {
            return 'YES';
        }
    }
    return 'NO';
}

function getFullPaymentSettings()
{
    // Initialize curl
    $ch = curl_init();

    // Set curl options
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "action" => "getClientSetting",
        "productId" => ApiBaseUrl()['productID'],
        "clientId" => ApiBaseUrl()['clientID']
    ]));

    // Set headers
    $headers = [
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute curl request
    $result = curl_exec($ch);

    // Check for errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    // Close curl
    curl_close($ch);

    // Return decoded result
    return json_decode($result, true);
}
function getPaymentGatewaySettings()
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "action" => "getClientSetting",
        "productId" => ApiBaseUrl()['productID'],
        "clientId" => ApiBaseUrl()['clientID']
    ]));

    $headers = [
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);

    // Check if response is valid and contains required data
    if (isset($response['result']['data'][0]['paymentGatewaySettings'][1]['paymentGateway'][0])) {
        return $response['result']['data'][0]['paymentGatewaySettings'][1]['paymentGateway'][0];
    } else {
        return null; // or handle the case when the data is not found
    }
}
function getClientInfoById()
{
    //$CI = &get_instance();
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/webgen/getclientInfoById');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "_id" => ApiBaseUrl()['clientID']
    ]));

    $token = session('token');
    $headers = [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json',
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return json_decode($result, true);
}


// Donation

function getDonationsByDonationsTypes($donationTypes, $session_data)
{



    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    // \"serviceTypes\":\"".$serviceType."\",
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceTypes":"' . $donationTypes . '",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


    $token = session('token');
    $headers = array();
    $headers[] = 'Authorization: Bearer ' . $token . '';
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);
    $services = json_decode(json_encode($response->data), true);
    $services = sortBySequenceId($services);
    //print_r($services);


    $html = '';


    if ($services != array()) {

        foreach ($services as $key => $item) {


            $pageLength = $key + 1;
            // echo $item['qtyCounter'];

            if ($item['qtyCounter'] == 'YES') {
                $quantityContainer_display = 'inline-flex';
            } else {
                $quantityContainer_display = 'none';
            }



            if (isset($item['Image']) && !empty($item['Image'])) {
                $src = ApiBaseUrl()['url'] . $item['Image'];
            } else {
                $src = url('assets/img/') . "services-listing.png";
            }

            $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

            $available_count_design = '';
            $filter_color = '';
            $available_count = '';
            $disable_input_field = '';
            $disable_input_field = '';

            if ($item['serviceAmount'] == 0) {

                if ($is_availibility_check == 1) {
                    $available_count_design = '';
                    $disable_input_field = 'disabled readonly';
                    $filter_color = 'filter: grayscale(1);';
                    $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                } else {

                    if ($is_availibility_check == 3) {
                        $disable_input_field = '';
                        if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                            $available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
                        } else {
                            $available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
                        }
                        $checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
                    } else if ($is_availibility_check == 2) {
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {
                        $checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
                        $disable_input_field = '';
                    }
                }

                $item['serviceAmount'] = 1;
                $amountSection = '<div class="input-group" style="width: 50%;">
				<span class="input-group-text">$</span>
				<input id="anyAmtDonation' . $item['_id'] . '" service-id="' . $item['_id'] . '" placeholder="0.00" type="text" class="form-control amount-input-donations" placeholder="enter amount you like to donate"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  '') . '" ' . $disable_input_field . '>
				</div>


				<div class="d-none col-md-12" style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';
            } else {
                $amountSection = '<div style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';


                $checkbox = '<div class="form-check">
				<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
				</div>';
            }



            $html .= '<div class="text-end d-none align-middle" style="background-color:#005D4B;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @getCurrencySymbol() . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
			</div><div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '"> <div class="col-md-12 col-xl-12 px-0"> <div class="card shadow-0 border rounded-3 px-0"> <div class="card-body p-0 m-0"> <div class="row" id="searchHere" style="background-color:#005D4B;color:white"> <div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">

			<div class="bg-image hover-zoom ripple rounded ripple-surface">
			<a href="' . $src . '" data-lightbox="set">
			<img src="' . $src . '" class="crop-center img-responsive bg-light" style="border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat; font-weight:bold;">' . $available_count_design . '
			</a>

			<a href="#!"> <div class="hover-overlay"> <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div> </div> </a> </div> </div> <div class="col-md-6 col-lg-7 col-xl-7" style="background-color:#005d4b!important;display: flex; flex-direction: row; align-items: center;"> <div> <label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> <p class="text-white mb-0 pb-2" style="padding-left: 12px;line-height:20px;font-size:13px!important"> ' . @replaceSingleQuotesWithBackticks($item['description']) . ' </p> </div> </div> <div class="col-md-6 col-lg-4 col-xl-4" style=" display: flex; flex-direction: column; justify-content: center; ">

			<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-evenly; align-items: stretch;">




			' . $amountSection . '




			' . $checkbox . '


			</div> </div> </div> </div> </div> </div> </div><input type="hidden" value="' . $pageLength . '" id="pageLength">';
        }
    } else {
        $html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
    }


    return $html;
}


function getDonationsCatTypes()
{
    // Initialize cURL session
    $ch = curl_init();

    // Disable SSL verification (use with caution in production)
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Set the API URL
    $apiBaseUrl = ApiBaseUrl();
    $filterApiUrl = filterAPI();
    $url = $apiBaseUrl['url'] . $filterApiUrl['url'];
    curl_setopt($ch, CURLOPT_URL, $url);

    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    // Set the request payload
    $payload = [
        "componentConfig" => [
            "moduleName" => "Master Data Management",
            "productID" => $apiBaseUrl['productID'],
            "clientID" => $apiBaseUrl['clientID'],
            "aspectType" => "serviceTypes",
            "query" => [
                "aspectType" => "serviceTypes",
                "refDataCode" => "DONATIONS",
                "status" => "ACTIVE"
            ],
            "userName" => "",
            "skip" => 0,
            "next" => 1024
        ]
    ];
    $payloadJson = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payloadJson);

    // Set headers
    $headers = [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($payloadJson) // Add content length header
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute cURL request
    $result = curl_exec($ch);

    // Check for cURL errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    // Close cURL session
    curl_close($ch);

    // Decode JSON response
    $response = json_decode($result, true);

    // Return data
    return isset($response['data']) ? $response['data'] : null;
}



function getSponsorTypes($serviceType = '')
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $url = ApiBaseUrl()['url'] . filterAPI()['url'];

    if ($serviceType != '') {
        $data = array(
            'componentConfig' => array(
                'query' => array(
                    'aspectType' => 'serviceTypes',
                    'refDataCode' => 'SPONSORSHIP',
                    'refDataName' => $serviceType
                ),
                'moduleName' => 'Master Data Management',
                'aspectType' => 'serviceTypes',
                'productID' => ApiBaseUrl()['productID'],
                'clientID' => ApiBaseUrl()['clientID'],
                'skip' => 0,
                'next' => 1000
            )
        );
    } else {
        $data = array(
            'componentConfig' => array(
                'query' => array(
                    'aspectType' => 'serviceTypes',
                    'refDataCode' => 'SPONSORSHIP'
                ),
                'moduleName' => 'Master Data Management',
                'aspectType' => 'serviceTypes',
                'productID' => ApiBaseUrl()['productID'],
                'clientID' => ApiBaseUrl()['clientID'],
                'skip' => 0,
                'next' => 1000
            )
        );
    }


    $headers = array(
        'Content-Type: application/json'
    );

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    $response = json_decode($result);

    return json_decode(json_encode($response->data), true);
}


function getRecurringSponsorTypesServicesByServiceType($serviceTypes, $session_data)
{

    //$CI = &get_instance();
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    $productID = ApiBaseUrl()['productID'];
    $clientID = ApiBaseUrl()['clientID'];

    $data = [
        "componentConfig" => [
            "query" => [
                "aspectType" => "ServiceSetup",
                "serviceCategoryTypes" => "DONATIONS",
                "serviceTypes" => $serviceTypes,
                "sourceTypes" => "WEBSITE",
                "status" => "ACTIVE"
            ],
            "moduleName" => "Temple Services",
            "aspectType" => "ServiceSetup",
            "collectionType" => "Business",
            "productID" => $productID,
            "clientID" => $clientID,
            "skip" => 0,
            // "next" => 1024
            "next" => 4
        ]
    ];

    $postData = json_encode($data);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


    $token = session('token');
    $headers = array();
    $headers[] = 'Authorization: Bearer ' . $token . '';
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    $response = json_decode($result);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    curl_close($ch);
    $services = json_decode(json_encode($response->data), true);
    $services = sortBySequenceId($services);



    $currency = GeneralSettings();
    $currencySymbol = isset($currency['currencySymbol']) ? (CheckEmptyNullVar($currency['currencySymbol']) != '' ? $currency['currencySymbol'] : '$') : '$';

    $html = '';


    if ($services != array()) {

        foreach ($services as $key => $item) {


            $pageLength = $key + 1;
            // echo $item['qtyCounter'];

            if ($item['qtyCounter'] == 'YES') {
                $quantityContainer_display = 'inline-flex';
            } else {
                $quantityContainer_display = 'none';
            }



            if (isset($item['Image']) && !empty($item['Image'])) {
                $src = ApiBaseUrl()['url'] . $item['Image'];
            } else {
                $src = url('assets/img/') . "services-listing.png";
            }

            $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

            $available_count_design = '';
            $filter_color = '';
            $available_count = '';
            $disable_input_field = '';
            $disable_input_field = '';

            if ($item['serviceAmount'] == 0) {



                if ($is_availibility_check == 1) {
                    $available_count_design = '';
                    $disable_input_field = 'disabled readonly';
                    $filter_color = 'filter: grayscale(1);';
                    $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                } else {

                    if ($is_availibility_check == 3) {
                        $disable_input_field = '';
                        if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                            $available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
                        } else {
                            $available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
                        }
                        $checkbox = '<div class="form-check" style="width:50%">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
                    } else if ($is_availibility_check == 2) {
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {
                        $checkbox = '<div class="form-check" style="width:50%">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
                        $disable_input_field = '';
                    }
                }

                $item['serviceAmount'] = 1;
                $amountSection = '<div class="input-group">
				<span class="input-group-text">$</span>
				<input id="anyAmtDonation' . $item['_id'] . '" service-id="' . $item['_id'] . '" placeholder="Enter amount you like to donate" type="text" class="form-control amount-input-donations" placeholder="enter amount you like to donate"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format(0, 2)) . '" ' . $disable_input_field . '>
				</div>


				<div class="d-none col-md-12" style="padding: 0px 30px;">
				' . @$currencySymbol['currencySymbol'] . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';
            } else {
                $amountSection = '<div style="padding: 0px 30px;">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';


                $checkbox = '<div class="form-check" style="width:50%">
				<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
				</div>';
            }



            $html .= '<div class="text-end d-none align-middle" style="background-color:#005D4B;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency['currencySymbol'] . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
			</div><div class="row serviceSearch justify-content-center mb-3" style="' . $filter_color . '"> <div class="col-md-12 col-xl-12 px-0"> <div class="card shadow-0 border rounded-3 px-0"> <div class="card-body p-0 m-0"> <div class="row" id="searchHere" style="background-color:#005D4B;color:white">

			<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0"> <div class="bg-image hover-zoom ripple rounded ripple-surface"> <div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

			<a href="#!"> <div class="hover-overlay"> <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div> </div> </a> </div> </div> <div class="col-md-6 col-lg-7 col-xl-7" style="background-color:#005d4b!important;display: flex; flex-direction: row; align-items: center;"> <div> <label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> <p class="text-white mb-0 pb-2" style="padding-left: 12px;line-height:20px;font-size:13px!important"> ' . @replaceSingleQuotesWithBackticks($item['description']) . ' </p> </div> </div> <div class="col-md-6 col-lg-4 col-xl-4" style=" display: flex; flex-direction: column; justify-content: center; ">

			<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-evenly; align-items: stretch;">




			' . $amountSection . '




			' . $checkbox . '


			</div> </div> </div> </div> </div> </div> </div><input type="hidden" value="' . $pageLength . '" id="pageLength">';
        }
        // $html .= '</tbody></table></table><input type="hidden" value="'.$pageLength.'" id="pageLength">';
    } else {
        $html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
    }


    return $html;
}


function getPreferredLocations()
{
    //$CI = &get_instance();
    $userName = session('refDataName');

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Define API base URL and filter URL outside of CURLOPT_URL for clarity
    $baseUrl = ApiBaseUrl();
    $filterUrl = filterAPI();

    // Prepare the request payload
    $payload = [
        'componentConfig' => [
            'moduleName' => 'Master Data Management',
            'productID' => $baseUrl['productID'],
            'clientID' => $baseUrl['clientID'],
            'aspectType' => 'serviceRequestCategory',
            'query' => [
                'aspectType' => 'serviceRequestCategory'
            ],
            'userName' => $userName,
            'skip' => 0,
            'next' => 1024
        ]
    ];

    // Set CURLOPT_URL using the defined URLs
    curl_setopt($ch, CURLOPT_URL, $baseUrl['url'] . $filterUrl['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload)); // Encode payload as JSON

    // Set request headers
    $headers = [
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute the request
    $result = curl_exec($ch);

    // Check for errors
    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    // Close the cURL handle
    curl_close($ch);

    // Decode the response and return it
    return json_decode($result);
}
function getServiceDetailbyId()
{

    $data = array(
        'url' => "api/bookingService/getServiceDetailbyId"
    );
    return $data;
}
function getEventDisplayGroups($serviceTypes)
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $url = ApiBaseUrl()['url'] . filterAPI()['url'];

    $data = array(
        'componentConfig' => array(
            'query' => array(
                'aspectType' => 'eventDisplayGroup',
                'eventType' => $serviceTypes,
                'status' => 'ACTIVE'
            ),
            'moduleName' => 'Master Data Management',
            'aspectType' => 'eventDisplayGroup',
            'productID' => ApiBaseUrl()['productID'],
            'clientID' => ApiBaseUrl()['clientID'],
            'skip' => 0,
            'next' => 1000
        )
    );

    $headers = array(
        'Content-Type: application/json'
    );

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    $response = json_decode($result);

    return json_decode(json_encode($response->data), true);
}

function GetChildEventByParentEvent($ParentEvent, $serviceTypes, $serviceCategoryTypes, $session_data)
{
    // $CI = & get_instance();

    $eventGroups = getEventDisplayGroups($serviceTypes);



    $html = '';
    if (!empty($eventGroups)) {

        $eventGroups = sortBySequenceId($eventGroups);
        $html .= '<div id="scrl-container" class="row">';
        foreach ($eventGroups as $key => $value) {

            $html .= '<div class="serviceSearch col-md-4 mt-3" id="scrl-flex-scroll"><div class="scrl-box"><center class="mb-3"><center><h4 class="fw-bold">' . camelCase($value['refDataCode']) . '</h4><img src="' . asset('assets/img/border.png') . '" width="250px"></center>';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

            $url = ApiBaseUrl()['url'] . filterAPI()['url'];
            $componentConfig = [
                "moduleName" => "Temple Events",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "aspectType" => "ServiceSetup",
                "query" => [
                    "sourceTypes" => "WEBSITE",
                    "aspectType" => "ServiceSetup",
                    "parentService" => $ParentEvent,
                    "serviceCategoryTypes" => $serviceCategoryTypes,
                    "EventDispay" => $value['refDataCode']
                ],
                "userName" => "",
                "skip" => 0,
                "next" => 1024
            ];
            $data = json_encode(["componentConfig" => $componentConfig]);

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $headers = [
                'Content-Type: application/json'
            ];
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = curl_exec($ch);
            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }

            curl_close($ch);

            $response = json_decode($result);

            $services = isset($response->data) ? json_decode(json_encode($response->data), true) : [];


            $currency = GeneralSettings();
            $currencySymbol = isset($currency['currencySymbol']) ? (CheckEmptyNullVar($currency['currencySymbol']) != '' ? $currency['currencySymbol'] : '$') : '$';
            print_r($services);
            die;

            if ($services != array()) {
                $services = sortBySequenceId($services);

                $html .= '<style>

				*{

					padding:0;
					margin:0;
				}


				.event-card{
					overflow:hidden;
					width: 50px;
					height:50px;
					padding-bottom: 0.5em;
					border-style: solid;
					border-width: 0px;
					border-style: solid;


				}
				/*controls the image*/
				.event-card img{
					width: 100%;
					height:105px!important;
					-o-object-fit:cover;
					object-fit:cover;
				}



				/*small calender item in top left corner*/
				.event-card .date-ribbon {
					position: absolute;
					top: 53px;
					background:white;
					left: 91px;
					color: #black;
					padding: 0.2em 1em;
					padding: 14px 6px;
					border-radius: 7px;
					border-style: solid;
					border-width: 2px 2px;
				}
				.event-card .date-ribbon h1{
					text-align:center;
					font-weight: 900;
					margin-bottom: 0px;
					font-size: 18px;
					margin-top:-0.09em;
				}
				</style><div class="row px-0">';

                foreach ($services as $key => $item) {

                    $isValid = filterValidData($item);

                    if ($isValid == 1) {



                        $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

                        $available_count_design = '';
                        $filter_color = '';
                        $available_count = '';
                        $disable_input_field = '';

                        if ($is_availibility_check == 1) {
                            $available_count_design = '';
                            $filter_color = 'filter: grayscale(1);';
                            $disable_input_field = 'disabled readonly';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        } else {

                            if ($is_availibility_check == 3) {
                                if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                    $available_count_design = ' <a href="javascript:void(0)">
									<div class="mask">
									<div class="d-flex justify-content-start align-items-end h-100">
									<h5 style="font-size: 11px!important;"><span class="badge bg-success mt-2 ms-1" style="font-size: 11px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
									</div>
									</div>
									<div class="hover-overlay">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
									</div>
									</a>';
                                } else {
                                    $available_count_design = ' <a href="javascript:void(0)">
									<div class="mask">
									<div class="d-flex justify-content-start align-items-end h-100">
									<h5 style="font-size: 11px!important;"><span class="badge bg-danger mt-2 ms-1" style="font-size: 11px!important;">Avl. 0</span></h5>
									</div>
									</div>
									<div class="hover-overlay">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
									</div>
									</a>';
                                }
                                $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
								<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="EVENTS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"   available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;">
								</div>';
                            } else if ($is_availibility_check == 2) {
                                $filter_color = 'filter: grayscale(1);';
                                $disable_input_field = 'disabled readonly';
                                $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            } else {
                                $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
								<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="EVENTS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"   available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;">
								</div>';
                            }
                        }

                        $dt_visibility = '';
                        if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'NO') {
                            $dt_visibility = 'd-none';
                        }


                        if ($item['qtyCounter'] == 'YES') {
                            $quantityContainer_display = 'inline-flex';
                        } else {
                            $quantityContainer_display = 'none';
                        }



                        if (isset($item['Image']) && !empty($item['Image'])) {
                            $src = ApiBaseUrl()['url'] . $item['Image'];
                        } else {
                            $src = asset('assets/img/') . "services-listing.png";
                        }



                        if ($item['serviceAmount'] != 0 || $item['serviceAmount'] != '') {

                            $amountSection = @$currencySymbol['currencySymbol'] . '&nbsp;<span style="font-size:14px!important" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
                        } else {

                            $item['serviceAmount'] = 1;
                            $amountSection = '<div class="input-group pb-2" style="padding-right: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;background-color:transparent;color:white;border:0;padding-right:10px;font-weight:bold">$</span>
							<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="Enter Any Amount"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format(0, 2)) . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
							</div>


							<div class="d-none col-md-12" style="padding: 0px 30px;">
							' . @$currencySymbol['currencySymbol'] . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
							</div>';
                        }


                        if ($item['startDate'] != '') {

                            $formattedDate = date('M d, Y', strtotime($item['startDate']));

                            $dayName = date('(D)', strtotime($item['startDate']));
                            $day = date('d', strtotime($item['startDate']));


                            if ($day % 10 == 1 && $day != 11) {
                                $suffix = 'st';
                            } elseif ($day % 10 == 2 && $day != 12) {
                                $suffix = 'nd';
                            } elseif ($day % 10 == 3 && $day != 13) {
                                $suffix = 'rd';
                            } else {
                                $suffix = 'th';
                            }
                            $formattedDay = $day . $suffix;

                            $formattedDay = '<div class="date-ribbon">
							<h1>' . $formattedDay . '</h1>

							</div>';
                        } else {
                            $formattedDay = '';
                        }


                        $start_date_input_field = '';



                        if ($item['startDate'] != '' && $item['endDate'] != '') {


                            $start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

							<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . ('' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
                        } else if ($item['startDate'] != '') {

                            $start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

							<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $item['startDate'] . '" disabled  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
                        }


                        $start_time_input_field = '';

                        if ($item['startTime'] != '') {
                            $start_time_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>
							<input type="text"  class=" form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $item['startTime'] . '" readonly>';
                        }

                        if (isset($item['description']) && $item['description'] != '') {
                            $descriptionWithEyeIcon = '<style>
							.collapse.in { display: inline !important; }
							</style>

							<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
							' . $item['description'] . '
							</span>
							<span>
							<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:green"></i></a>
							</span>';
                        } else {
                            $descriptionWithEyeIcon = '';
                        }





                        $html .= '<div class="col-md-12 my-1 serviceSearch px-0 mx-0" style="' . $filter_color . '' . '">
						<div class="row " style="background: #fff3f5 !important;border: 1px solid #7d1456;    border-radius: 13px;    min-height: 100px;">
						<div class="col-lg-1 col-md-1 col-sm-1 col-xs-1" style="padding-left: 0px; display: flex; flex-direction: column; justify-content: space-evenly; align-items: stretch;">


						<div class="event-card card" style="display: flex; flex-direction: column; justify-content: space-around;">

						<img src="' . $src . '" alt="' . $item['refDataName'] . '">



						' . $formattedDay . '

						</div>
						' . $available_count_design . '


						</div>
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-10 text-left" style="display: flex; justify-content: center; align-items: baseline; flex-direction: column; align-content: space-between; flex-wrap: wrap;padding-left:26px">
						<h3 class="mt-0 fw-bold mb-1" style="font-size:14px!important">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</h3>
						<p class="mt-0 mb-1" style="font-size:15px!important;line-height:1.4">' . $descriptionWithEyeIcon . '</p>
						<div class="input-group ' . $dt_visibility . ' " style="width: 110%;">

						' . $start_date_input_field . '

						' . $start_time_input_field . '


						</div>

						</div>
						<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center pr-0" style="
						padding: 0;background: #7d1456;color: white;border-radius: 0px 13px 13px 0px;display: flex; justify-content: center; align-items: center;
						">

						<div class="row">
						<div class="col-md-12" style="display: flex; justify-content: center; align-items: center;padding:0">
						<div class="display:flex">
						<style type="text/css">.form-check-input[type=checkbox] {margin-right:0px!important; margin-top: 0px!important}</style>
						<span class="suffix">' . $amountSection . '</span>
						' . $checkbox . '
						</div>
						</div>
						</div>

						</div>
						</div>
						</div>';
                    }
                }
                $html .= '</div>';
            } else {
                $html .= '';
            }

            $html .= '</div></div>';
        }



        $html .= '</div>';
    } else {


        // $CI = & get_instance();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        // Assuming ApiBaseUrl() and filterAPI() are functions that return an array containing 'url', 'productID', and 'clientID'
        $baseUrl = ApiBaseUrl();
        $filterApi = filterAPI();

        curl_setopt($ch, CURLOPT_URL, $baseUrl['url'] . $filterApi['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        // Constructing the JSON payload
        $payload = [
            "componentConfig" => [
                "moduleName" => "Temple Events",
                "productID" => $baseUrl['productID'],
                "clientID" => $baseUrl['clientID'],
                "aspectType" => "ServiceSetup",
                "query" => [
                    "sourceTypes" => "WEBSITE",
                    "aspectType" => "ServiceSetup",
                    "parentService" => $ParentEvent, // Assuming $ParentEvent is defined elsewhere
                    "serviceCategoryTypes" => $serviceCategoryTypes // Assuming $serviceCategoryTypes is defined elsewhere
                ],
                "userName" => "",
                "skip" => 0,
                "next" => 1024
            ]
        ];
        $jsonPayload = json_encode($payload);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonPayload);

        $headers = [
            'Content-Type: application/json'
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        } else {
            $response = json_decode($result);
            // Assuming $response->data exists
            $services = json_decode(json_encode($response->data), true);
        }

        curl_close($ch);

        $currency = GeneralSettings();
        $currencySymbol = isset($currency['currencySymbol']) ? (CheckEmptyNullVar($currency['currencySymbol']) != '' ? $currency['currencySymbol'] : '$') : '$';

        $html = '';


        if ($services != array()) {
            $services = sortBySequenceId($services);
            $html .= '<style>

            *{

                padding:0;
                margin:0;
            }


            .event-card{
                overflow:hidden;
                width: 50px;
                height:50px;
                padding-bottom: 0.5em;
                border-style: solid;
                border-width: 0px;
                border-style: solid;


            }
            /*controls the image*/
            .event-card img{
                width: 100%;
                height:105px!important;
                -o-object-fit:cover;
                object-fit:cover;
            }



            /*small calender item in top left corner*/
            .event-card .date-ribbon {
                position: absolute;
                top: 53px;
                background:white;
                left: 91px;
                color: #black;
                padding: 0.2em 1em;
                padding: 14px 6px;
                border-radius: 7px;
                border-style: solid;
                border-width: 2px 2px;
            }
            .event-card .date-ribbon h1{
                text-align:center;
                font-weight: 900;
                margin-bottom: 0px;
                font-size: 18px;
                margin-top:-0.09em;
            }
            </style><div class="row px-0">';

            usort($services, function ($a, $b) {
                $dateA = DateTime::createFromFormat('m/d/Y', $a['startDate']);
                $dateB = DateTime::createFromFormat('m/d/Y', $b['startDate']);
                // ascending ordering, use `<=` for descending
                return $dateA >= $dateB;
            });

            foreach ($services as $key => $item) {
                $isValid = filterValidData($item);
                if ($isValid == 1) {
                    $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

                    $available_count_design = '';
                    $filter_color = '';
                    $available_count = '';
                    $disable_input_field = '';
                    if ($is_availibility_check == 1) {
                        $available_count_design = '';
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {

                        if ($is_availibility_check == 3) {
                            if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 11px!important;"><span class="badge bg-success mt-2 ms-1" style="font-size: 11px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            } else {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 11px!important;"><span class="badge bg-danger mt-2 ms-1" style="font-size: 11px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            }
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;">
							</div>';
                        } else if ($is_availibility_check == 2) {
                            $filter_color = 'filter: grayscale(1);';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            $disable_input_field = 'disabled readonly';
                        } else {
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;margin-left:10px">
							</div>';
                        }
                    }

                    $dt_visibility = '';
                    if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'NO') {
                        $dt_visibility = 'd-none';
                    }


                    if ($item['qtyCounter'] == 'YES') {
                        $quantityContainer_display = 'inline-flex';
                    } else {
                        $quantityContainer_display = 'none';
                    }



                    if (isset($item['Image']) && !empty($item['Image'])) {
                        $src = ApiBaseUrl()['url'] . $item['Image'];
                    } else {
                        $src = asset('assets/img/') . "services-listing.png";
                    }


                    if ($item['serviceAmount'] != 0 || $item['serviceAmount'] != '') {
                        if (is_array($currencySymbol) && isset($currencySymbol['currencySymbol'])) {
                            $amountSection = @$currencySymbol['currencySymbol'] . '&nbsp;<span style="font-size:14px!important;font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
                        }
                    } else {
                        // Handle the case where $currencySymbol is not an array or does not have the expected structure
                        // You might want to set a default currency symbol or log an error
                        $amountSection = 'Invalid currency symbol';

                        $item['serviceAmount'] = 1;
                        $amountSection = '<div class="input-group pb-2" style="padding-right: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;background-color:transparent;color:white;border:0;padding-right:10px;font-weight:bold">$</span>
						<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="Enter Any Amount"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format(0, 2)) . '" ' . $disable_input_field . '>
						</div>


						<div class="d-none col-md-12" style="padding: 0px 30px;">
						' . @$currencySymbol['currencySymbol'] . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
						</div>';
                    }


                    if ($item['startDate'] != '') {
                        $formattedDate = date('M d, Y', strtotime($item['startDate']));
                        $dayName = date('(D)', strtotime($item['startDate']));
                        $day = date('d', strtotime($item['startDate']));
                        if ($day % 10 == 1 && $day != 11) {
                            $suffix = 'st';
                        } elseif ($day % 10 == 2 && $day != 12) {
                            $suffix = 'nd';
                        } elseif ($day % 10 == 3 && $day != 13) {
                            $suffix = 'rd';
                        } else {
                            $suffix = 'th';
                        }
                        $formattedDay = $day . $suffix;

                        $formattedDay = '<div class="date-ribbon">
						<h1>' . $formattedDay . '</h1>

						</div>';
                    } else {
                        $formattedDay = '';
                    }


                    $start_date_input_field = '';
                    if ($item['startDate'] != '' && $item['endDate'] != '') {
                        $start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . ('' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
                    } else if ($item['startDate'] != '') {

                        $start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $item['startDate'] . '" disabled  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
                    }
                    $start_time_input_field = '';
                    if ($item['startTime'] != '') {
                        $start_time_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>
						<input type="text"  class=" form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $item['startTime'] . '" readonly ' . $disable_input_field . '>';
                    }

                    if (isset($item['description']) && $item['description'] != '') {
                        $descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span>
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:green"></i></a>
						</span>';
                    } else {
                        $descriptionWithEyeIcon = '';
                    }

                    $html .= '<div class="col-md-12 my-1 serviceSearch" style="' . $filter_color . '' . '">
					<div class="row " style="background: #fff3f5 !important;border: 1px solid #7d1456;    border-radius: 13px">
					<div class="col-lg-1 col-md-1 col-sm-1 col-xs-1" style="padding-left:0px">


					<div class="event-card card">

					<img src="' . $src . '" alt="' . $item['refDataName'] . '">



					' . $formattedDay . '

					</div>
					' . $available_count_design . '

					</div>
					<div class="col-lg-9 col-md-9 col-sm-7 col-xs-11 text-left" style="display: flex; justify-content: center; align-items: baseline; flex-direction: column; align-content: space-between; flex-wrap: wrap;padding-left:70px">
					<h3 class="mt-0 fw-bold mb-1" style="font-size:20px!important">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</h3>
					<p class="mt-0 mb-1" style="font-size:15px!important;line-height:1.4">' . $descriptionWithEyeIcon . '</p>
					<div class="input-group ' . $dt_visibility . ' " style="width: 35%;">

					' . $start_date_input_field . '

					' . $start_time_input_field . '


					</div>

					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 text-center pr-0" style="
					padding: 0;background: #7d1456;color: white;border-radius: 0px 13px 13px 0px;display: flex; justify-content: center; align-items: center;
					">

					<div class="row" style="padding:15px">
					<div class="col-md-8" style="display: flex; justify-content: center; align-items: center;">
					<style type="text/css">.form-check-input[type=checkbox] {margin-right:0px!important; margin-top: 0px!important}</style>
					<span class="suffix FestivalDay" style="font-size:15px!important"></span>
					</div>
					<div class="col-md-4" style="display: flex; justify-content: center; align-items: center;">
					' . $checkbox . '
					</div>
					</div>

					</div>
					</div>
					</div>';
                }
            }
            $html .= '</div>';
        } else {
            $html .= '';
        }
    }




    return $html;
}


function postAPI()
{
    $data = array(
        'url' => "api/appgen/postAPI"
    );
    return $data;
}

function refundRequest()
{
    $data = array(
        'url' => "api/payment/refundRequest"
    );
    return $data;
}
function addServiceRequest()
{
    $data = array(
        'url' => "api/bookingService/addServiceRequest"
    );
    return $data;
}
function sendBookingDataPdfOnMail()
{
    $data = array(
        'url' => "api/emailSend/sendBookingDataPdfOnMail"
    );
    return $data;
}

function GetRentalTypes()
{

    $ch = curl_init();
    $url = ApiBaseUrl()['url'] . 'api/appgen/filterAPI';
    $data = [
        "componentConfig" => [
            "moduleName" => "Master Data Management",
            "aspectType" => "rentalTypes",
            "productID" => ApiBaseUrl()['productID'],
            "clientID" => ApiBaseUrl()['clientID'],
            "query" => [
                "aspectType" => "rentalTypes"
            ],
            "skip" => 0,
            "next" => 100
        ]
    ];
    $data_string = json_encode($data);

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); // You may want to remove these lines in a production environment
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $headers = [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($data_string)
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return json_decode($result, true);
}



function getRentalServicesByRentalTypes($refDataCode, $refDataname, $session_data = '')
{
    //   $CI = &get_instance();

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/appgen/filterAPI');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    $data = [
        "componentConfig" => [
            "moduleName" => "Rental Setup",
            "aspectType" => "rentalSetup",
            "productID" => ApiBaseUrl()['productID'],
            "clientID" => ApiBaseUrl()['clientID'],
            "query" => [
                "aspectType" => "rentalSetup",
                "rentalCategory" => $refDataCode,
                "refDataCode" => $refDataname
            ],
            "skip" => 0,
            "next" => 1024
        ]
    ];

    $postData = json_encode($data);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


    $headers = array();
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);


    $response = json_decode($result, true);


    $rentals = $response['data'];
    $rentals = sortBySequenceId($rentals);


    $html = '';

    if ($rentals != array()) {

        foreach ($rentals as $key => $item) {

            $isValid = filterValidData($item);
            if ($isValid == 1) {

                if (isset($item['rentalBookingTypes']) && CheckEmptyNullVar($item['rentalBookingTypes']) != '') {

                    $rental_booking_types = $item['rentalBookingTypes'];

                    $options = json_decode($rental_booking_types);
                    $rental_booking_types_options =  '<select style="padding: 4px; border-radius: 5px; margin-bottom: 10px;" id="booking_type' . $item['_id'] . '" onchange="showSection(this, `' . $item['_id'] . '`)">';
                    $rental_booking_types_options .=  '<option value=" ">Select Type</option>';
                    foreach ($options as $option) {
                        $rental_booking_types_options .= "<option value='$option'" . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['bookingTypes'][array_search($item['_id'], $session_data['ids'])] == $option ? 'selected' : '')  : '') . ">" . $option . "</option>";
                    }
                    $rental_booking_types_options .=  '</select>';
                } else {

                    $rental_booking_types_options = '';
                }


                if ($item['qtyCounter'] == 'YES') {
                    $quantityContainer_display = 'inline-flex';
                } else {
                    $quantityContainer_display = 'none';
                }



                if (isset($item['image']) && !empty($item['image'])) {
                    $src = ApiBaseUrl()['url'] . $item['image'];
                } else {
                    $src = ('assets/img/') . "services-listing.png";
                }



                if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

                    if ($item['bookingType'] == 'PAY NOW'  &&  $item['costPerUnit'] > 0) {

                        $bookingType = 'PAY NOW';
                    } else if ($item['bookingType'] == 'PAY LATER'  &&  $item['costPerUnit'] > 0) {
                        $bookingType = 'PAY LATER';
                    } else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['costPerUnit'] > 0) {
                        $bookingType = 'OPTIONAL';
                    } else {
                        $bookingType = 'PAY NOW';
                    }
                } else {
                    $bookingType = 'PAY NOW';
                }




                if (isset($item['costPerUnit']) && $item['costPerUnit'] != 0) {



                    $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

                    $available_count_design = '';
                    $filter_color = '';
                    $available_count = '';
                    $disable_input_field = '';

                    if ($is_availibility_check == 1) {
                        $available_count_design = '';
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {

                        if ($is_availibility_check == 3) {
                            if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            } else {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            }
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important">
							</div>';
                        } else if ($is_availibility_check == 2) {
                            $filter_color = 'filter: grayscale(1);';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            $disable_input_field = 'disabled readonly';
                        } else {
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important">
							</div>';
                        }
                    }

                    $limitPerdayFeature = '';
                    $BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
                    $BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

                    if ($BookingLimitPerDay > 0) {

                        $limitPerdayFeature     .= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
                    } else {
                        $limitPerdayFeature     .= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
                    }

                    if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
                        $dateTimeCode = '';
                        $dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">



						' . $rental_booking_types_options . '


						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['bookingTypes'][array_search($item['_id'], $session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['bookingTypes'][array_search($item['_id'], $session_data['ids'])] == "HOURLY" ? '' : 'd-none')  : 'd-none') . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">


						<table class="table-inputs mb-2">
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" type="text" class="hasTimepicker start" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['start_time'][array_search($item['_id'], $session_data['ids'])])  : '') . '">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" type="text" class="hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['end_time'][array_search($item['_id'], $session_data['ids'])])  : '') . '">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>

						</div>';
                    } else {
                        $dateTimeCode = '';
                    }

                    if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
                        $descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span>
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
                    } else {
                        $descriptionWithEyeIcon = '';
                    }


                    $pageLength = $key + 1;



                    $html .= '<div class="text-end d-none align-middle" style="background-color:#005D4B;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . getCurrencySymbol() . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:#005D4B;color:white">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-5 col-xl-5" style="background-color:#005d4b!important;display: flex; flex-direction: row; align-items: center;">
					<div>
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br>
					<p style="color: white!important; font-size: 12px!important; text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
					' . $dateTimeCode . '
					</div>
					</div>

					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;">


					<span  >' . getCurrencySymbol() . '&nbsp;' . (price_format($item['costPerUnit'], 2)) . (isset($item['unitTypes']) ? ' / ' . isset($item['unitTypes']) : '') . '</span>

					</div>
					</div>

					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;">


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: #005D4B;color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: #005D4B;color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;border-left:1px solid white;">


					<span id="Totalprice_' . $item['_id'] . '">' . getCurrencySymbol() . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['costPerUnit']), 2)  :  price_format($item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
                } else {


                    $is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

                    $available_count_design = '';
                    $filter_color = '';
                    $available_count = '';
                    $disable_input_field = '';

                    if ($is_availibility_check == 1) {
                        $available_count_design = '';
                        $filter_color = 'filter: grayscale(1);';
                        $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                        $disable_input_field = 'disabled readonly';
                    } else {

                        if ($is_availibility_check == 3) {
                            if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            } else {
                                $available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
                            }
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important">
							</div>';
                        } else if ($is_availibility_check == 2) {
                            $filter_color = 'filter: grayscale(1);';
                            $checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
                            $disable_input_field = 'disabled readonly';
                        } else {
                            $checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important">
							</div>';
                        }
                    }



                    $html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0 col-7 " style="color:#fff!important">
					<div class="col-md-12 m-0 p-0">
					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 100px;width:100%;width: 83%;margin-left: 10px;">
					' . $available_count_design . '
					</div>
					</div>
					<div class="col-md-10" style="background-color:#005d4b!important;">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>

					<div class="row m-0 p-0">
					<div class="col-md-3 m-0 p-0">
					<div class="input-group">

					<div class="input-group-addon" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


					</div>
					</div>
					<div class="col-md-3">

					<div class="input-group">
					<div class="input-group-addon timepicker-services" style="color: #F9F61F;background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
					</div>
					</div>
					</div>

					</div>
					</div>
					</div>
					</td>
					<td class="text-center col-2 align-middle"  style="background-color:#005d4b;"><span></span></td>

					<td colspan="2" class="text-end col-2 align-middle"  style="background-color:#005d4b;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;">


					<span>Request This Facilities.</span>
					<span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
					</td>

					<td class="text-center col-1 align-middle" style="background-color:#005d4b;color:#000000!important;font-weight:bold;">
					' . $checkbox . '
					</td>
					</tr>';
                }
            }
        }
        $html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
    } else {
        $html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
    }


    return $html;
}

function VolunteerTypes()
{

    // Initialize curl session
    $ch = curl_init();

    // Disable SSL verification (not recommended for production)
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Set API URL
    $url = ApiBaseUrl()['url'] . filterAPI()['url'];
    curl_setopt($ch, CURLOPT_URL, $url);

    // Set request method to POST
    curl_setopt($ch, CURLOPT_POST, 1);

    // Prepare POST data
    $postData = array(
        "componentConfig" => array(
            "moduleName" => "Master Data Management",
            "productID" => ApiBaseUrl()['productID'],
            "clientID" => ApiBaseUrl()['clientID'],
            "aspectType" => "volunteerArea",
            "query" => array(
                "aspectType" => "volunteerArea"
            ),
            "skip" => 0,
            "next" => 700
        )
    );
    $postDataJson = json_encode($postData);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

    // Set headers
    $headers = array(
        'Content-Type: application/json',
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Set option to return the transfer as a string
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Execute the request
    $result = curl_exec($ch);

    // Check for errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    // Close cURL session
    curl_close($ch);

    // Decode JSON response
    $response = json_decode($result);

    // Return response data
    return $response->data;
}

function addAPI()
{
    $data = array(
        'url' => "api/appgen/addAPI"
    );
    return $data;
}

function getMasterData($aspectType)
{


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    // Define the data as an associative array
    $data = [
        'componentConfig' => [
            'moduleName' => 'Master Data Management',
            'productID' => ApiBaseUrl()['productID'],
            'clientID' => ApiBaseUrl()['clientID'],
            'aspectType' => $aspectType,
            'query' => [
                'aspectType' => $aspectType
            ],
            'skip' => 0,
            'next' => 700
        ]
    ];

    // Convert the array to a JSON string
    $jsonData = json_encode($data);

    // Set the CURLOPT_POSTFIELDS using the variable
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);


    $headers = array();

    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);

    $response = json_decode($result, true);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    return $response['data'];
}


function addVolunteer()
{
    $data = array(
        'url' => "api/volunteer/addVolunteer"
    );
    return $data;
}


function RegardingTypes()
{


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Assuming you have defined ApiBaseUrl() and filterAPI() functions elsewhere

    // Set the URL
    $url = ApiBaseUrl()['url'] . filterAPI()['url'];
    curl_setopt($ch, CURLOPT_URL, $url);

    // Set other CURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    // Construct the POST data as an array
    $postData = array(
        "componentConfig" => array(
            "moduleName" => "Master Data Management",
            "productID" => ApiBaseUrl()['productID'],
            "clientID" => ApiBaseUrl()['clientID'],
            "aspectType" => "Regardingtypes",
            "query" => array(
                "aspectType" => "Regardingtypes"
            ),
            "skip" => 0,
            "next" => 700
        )
    );

    // Convert the POST data array to JSON
    $jsonData = json_encode($postData);

    // Set POST fields
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    // Set headers
    $headers = array(
        'Content-Type: application/json',
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute the CURL request
    $result = curl_exec($ch);

    // Check for CURL errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    // Close CURL connection
    curl_close($ch);

    // Decode the response JSON
    $response = json_decode($result);

    // Return the data
    return $response->data;
}

function sendContactEmail()
{
    $data = array(
        'url' => "api/emailSend/sendContactEmail"
    );
    return $data;
}

function SettingsApi() {
    $ch = curl_init();

    // Set API URL
    $apiBaseUrl = ApiBaseUrl();
    $settingsUrl = settings()['url'];
    curl_setopt($ch, CURLOPT_URL, $apiBaseUrl['url'] . $settingsUrl);

    // Set curl options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);

    // Prepare POST data
    $postData = json_encode(array(
        "action" => "getClientSetting",
        "productId" => $apiBaseUrl['productID'],
        "clientId" => $apiBaseUrl['clientID']
    ));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

    // Set headers
    $headers = array(
        'Content-Type: application/json'
    );

    // Example for Authorization header if needed
    // $token = $this->session->userdata('token');
    // if ($token) {
    //     $headers[] = 'Authorization: Bearer ' . $token;
    // }
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Disable SSL verification if required (consider security implications)
    // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    // Execute curl request
    $result = curl_exec($ch);

    // Check for curl errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }

    // Close curl session
    curl_close($ch);

    // Decode JSON response
    $response = json_decode($result, true);

    return @$response;
}