<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\RequestStack;

class AdminController extends Controller
{
    //

    public function dashboard()
    {
        //return "Admin Dashboard";
        $response = getUserDetails();
        // dd();
        if ($response->statusCode == 1) {
            $data['page'] = 'Dashboard';
            $data['title'] = 'Dashboard';
            $data['header'] = 'Dashboard';
            $data['userDetails'] = $response->data[0];
            return view('admin.dashboard', $data);
        } else {
            echo json_encode('User not found!!');
            Session::forget('logged_in');
            return redirect()->route('home');
        }
    }
    //  My Profile

    public function MyProfile()
    {
        $response = getUserDetails();
        // dd( $response );
        if ($response->statusCode == 1) {
            $data['page'] = 'MY-PROFILE';
            $data['title'] = 'MY PROFILE';
            $data['header'] = 'MY PROFILE';
            $data['userDetails'] = $response->data[0];

            if (Session::get('userType') == 'Managements') {
                return 'management profile';
                // $this->load->view( 'admin/managements/my-profile', $data );
            } else {
                return view('admin.my-profile', $data);
            }
        } else {
            echo json_encode('User not found!!');
            Session::forget('logged_in');
            return redirect()->route('home');
        }
    }

    // Edit Profile

    public function EditProfile()
    {
        $data['page'] = 'MY-PROFILE';
        $data['title'] = 'MY PROFILE';
        $data['header'] = 'EDIT PROFILE';
        $data['GetState'] = GetState();
        $data['userDetails'] = getUserDetails()->data[0];
        // dd( getUserDetails() );
        $data['preferredLanguage'] = getPreferredLanguage();
        $data['priest_data'] = getPriest();
        // print_r( $data[ 'priest_data' ] );
        // die();
        $data['nakshtra_data'] = getNakshtra()['data'];
        $data['gotra_data'] = getGotra()['data'];
        $data['rashi_data'] = getRashi()['data'];
        return view('admin.edit-profile', $data);
    }

    // Update Profile

    public function updateProfile(Request $request)
    {
        return $request->all();
        $post_data = $request->all();
        //return $post_data;
        $inputArray = array();

        $member_phone_plain = '';
        $member_email_plain = '';
        foreach ($post_data['family_member_name'] as $key => $family_member_name) {
            // $newEntry = new stdClass();
            $newEntry = array();
            $newEntry['memberName'] = $family_member_name;
            $newEntry['dob'] = $post_data['dateofbirth'][$key];
            $newEntry['nakshatra'] = @strtoupper($post_data['family_member_stars'][$key]);
            $newEntry['status'] = $post_data['family_member_status'][$key];
            $newEntry['relationship'] = $post_data['relationship'][$key];
            $newEntry['anniversaryDate'] = $post_data['anniversary'][$key];
            $newEntry['gotraName'] = $post_data['family_member_gotraName'][$key];
            $newEntry['householdInd'] = $post_data['member_household_indicator'][$key];
            $newEntry['member_email'] = $post_data['member_email'][$key] != '' ? base64_encode($post_data['member_email'][$key]) : '';
            $newEntry['member_phone'] = $post_data['member_phone'][$key] != '' ? base64_encode(str_replace([' ', '(', ')', '-'], '', $post_data['member_phone'][$key])) : '';

            $inputArray[] = $newEntry;
        }
        return  $inputArray;

        foreach ($inputArray as $item) {
            // Check if any of the fields in the object are empty
            if (!empty($item->memberName)) {
                $jsonArray[] = $item;
            }
        }

        $userName = $request->refDataName;

        $fname = $request->fname;
        $lname = $request->lname;
        $gothram = strtoupper($request->othram);

        $main_email = $request->main_email;
        $main_email = $main_email != '' ? base64_encode($main_email) : '';

        $main_phone = $request->main_phone;
        $main_phone = $main_phone != '' ? base64_encode(str_replace([' ', '(', ')', '-'], '', $main_phone)) : '';

        $stars = strtoupper($request->stars);
        $rashi = strtoupper($request->rashi);
        $county = $request->county;
        $address_line1 = $request->address_line1;
        $address_line2 = $request->address_line2;

        $spouseName = $request->spouseName;
        $spouseDob = $request->spousedateofbirth;
        $spousePhone = $request->spousePhone;
        $preferredLanguage = $request->preferredLanguage;
        $spouseEmail = $request->spouseEmail;
        $spouseGothram = strtoupper($request->spouseGothram);
        $spouseStars = strtoupper($request->spouseStars);
        $spouseRashi = strtoupper($request->spouseRashi);
        $spouse_household_indicator = $request->household_indicator;


        $spouse_household_indicator_final = $spouse_household_indicator == 'on' ? 'YES' : 'NO';


        $dob = $request->dob;


        $priestName = $request->priestName;
        $priestEmail = $request->priestEmail;
        $priestEmail  = $priestEmail != '' ? base64_encode($priestEmail) : '';
        $priestPhone = $request->priestPhone;
        $priestPhone  = $priestPhone != '' ? base64_encode($priestPhone) : '';
        $priestId = $request->priestId;

        $email = base64_encode($request->main_email);

        $phone = $request->main_phone;

        $phone = base64_encode(str_replace([' ', '(', ')', '-'], '', $phone));

        $full_address = $request->full_address;
        $state = $request->state;
        $city = strtoupper($request->city);

        if ($city) {
            $city = strtoupper($city);
        }
        $zipcode = $request->zipcode;
        $company_name = $request->company_name;
        $company_email = $request->company_email;
        $company_phone = $request->company_phone;

        $company_phone = str_replace([' ', '(', ')', '-'], '', $company_phone);


        $company_website = $request->company_website;
        $Id = session('id');

        $emailNoti = $request->emailNotification;
        $phoneSms = $request->phoneNotification;
        $phoneCallPref = $request->phoneCallPref;

        $emailSubscription = $emailNoti == 'on' ? 'true' : 'false';
        $phoneSubscription = $phoneSms == 'on' ? 'true' : 'false';
        $phoneCallSubscription = $phoneCallPref == 'on' ? 'true' : 'false';



        $moduleName = customerLogin()['moduleName'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . postAPI()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        $post_json_data = [
            "_id" => $Id,
            "dataJson" => [
                "refDataName" => $fname . " " . $lname,
                "email" => $main_email,
                // Add other fields here
                "zip" => $zipcode,
                "phone" => $main_phone,
                "cityTypes" => $city,
                "stateTypes" => $state,
                "addressLine1" => $address_line1,
                "addressLine2" => $address_line2,
                "county" => $county,
                "rashi" => $rashi,
                "gotraName" => strtoupper($gothram),
                "Nakshtra" => $stars,

                "spouseName" => $spouseName,
                "spouseDob" => $spouseDob,
                "spousePhone" => base64_encode($spousePhone),
                "spouseEmail" => base64_encode($spouseEmail),
                "spouseGotra" => $spouseGothram,
                "spouseNakshtra" => $spouseStars,
                "householdInd" => $spouse_household_indicator_final,
                "spouseRashi" => $spouseRashi,
                "dob" => $dob,
                "languagePreferenceName" => $preferredLanguage,

                "requestForPriestName" => $priestName,
                "priestEmail" => $priestEmail,
                "priestPhone" => $priestPhone,
                "requestedPriestId" => $priestId,

                "companyName" => $company_name,
                "companyEmail" => base64_encode($company_email),
                "companyPhone" => base64_encode($company_phone),
                "website" => $company_website,
                "emailPref" => $emailSubscription,
                "smsPref" => $phoneSubscription,
                "phoneCallPref" => $phoneCallSubscription,
                "memberDetail" => $jsonArray,
            ],
            "componentConfig" => [
                "moduleName" => "Contacts",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "userName" => $userName
            ]
        ];

        $payload = json_encode($post_json_data);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

        $headers = [
            'Content-Type: application/json'
        ];

        $token = session('token');
        if ($token) {
            $headers[] = 'Authorization: Bearer ' . $token;
        } else {
            // Handle token absence
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if ($result === false) {
            echo 'Error:' . curl_error($ch);
        } else {
            $response = json_decode($result);
            if ($response->statusCode == 1) {
                Session::flash('success', '<div class="alert alert-success alert-dismissible fade show text-center"><strong>Updated!</strong> Your profile has been updated.<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
                return redirect()->route('admin.my-profile');
            } else {
                return "else part";
                // $data['page'] = 'MY-PROFILE';
                // $data['title'] = 'MY PROFILE';
                // $data['header'] = 'EDIT PROFILE';
                // $data['GetState'] = GetState();
                // $data['userDetails'] = getUserDetails()->data[0];
                // $data['preferredLanguage'] = getPreferredLanguage();
                // Session::flash('success', '<div class="alert alert-danger alert-dismissible fade show text-center"><strong>Error!</strong> Something Went Wrong.<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
                // return view('admin.edit-profile', $data);
            }
            // Handle response
        }

        curl_close($ch);
    }


    // logout function

    public function logout()
    {
        Session::flush();
        Session::forget('logged_in');
        return redirect()->route('home');
    }


    public function In_Temple_Bookings()
    {
        $data['page'] = 'MY-BOOKINGS';
        $data['title'] = 'MY BOOKINGS';
        $data['header'] = 'MY BOOKINGS';

        return view('admin.my-bookings', $data);
    }

    public function FilterBookingData()
    {

        //  request()->input('aspectType');
        session('id');
        $userName = session('refDataName');
        $email = session('email');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);


        if (request()->input('aspectType') == 'Rental Request Form') {

            $aspectType = request()->input('aspectType');

            $requestData = array(
                'componentConfig' => array(
                    'moduleName' => 'Calendar',
                    'productID' => ApiBaseUrl()['productID'],
                    'clientID' => ApiBaseUrl()['clientID'],
                    'aspectType' => 'Service Schedules',
                    'query' => array(
                        'aspectType' => $aspectType,
                        'memberId' => session('id')
                    ),
                    'userName' => $userName,
                    'skip' => 0,
                    'next' => 1020,
                )
            );
        } else {

            $serviceCategoryTypes = request()->input('aspectType');
            $data['page'] =  'MY-BOOKINGS';
            $data['header'] =  'MY BOOKINGS';

            $requestData = array(
                'componentConfig' => array(
                    'moduleName' => 'Calendar',
                    'productID' => ApiBaseUrl()['productID'],
                    'clientID' => ApiBaseUrl()['clientID'],
                    'aspectType' => 'Service Schedules',
                    'query' => array(
                        'aspectType' => 'serviceBooking',
                        'paymentStatus' => 'COMPLETED',
                        'memberId' => session('id'),
                        'serviceCategoryTypes' => $serviceCategoryTypes,
                    ),
                    'userName' => $userName,
                    'skip' => 0,
                    'next' => 1020,
                )
            );
        }


        $jsonData = json_encode($requestData);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $token = session('token');
        $headers = array();
        $headers[] = 'Authorization: Bearer ' . $token . '';
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        $response = json_decode($result);
        // return  $response;

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        curl_close($ch);
        $html = '';
        if ($response != '') {

            //usort($response->data, 'sortByTimestampDesc');
            $booking_data  = json_decode(json_encode($response->data), true);



            $html .= '<table id="myBookings" class="table table-hovered">';
            $html .=         '<thead  style="background-color: #2978b5; color: white;">';
            $html .=             '<tr>';
            $html .=                 '<th class="text-center">Order&nbsp;#</th>';
            $html .=                 '<th>Service Name</th>';
            $html .=                 '<th style="text-align:right">Amount</th>';
            $html .=                 '<th class="text-center">Booking&nbsp;Date</th>';
            $html .=                 '<th class="text-center">Service&nbsp;Date</th>';
            $html .=                '<th class="text-center">Status</th>';
            $html .=                '<th class="text-center">Cancel&nbspBooking</th>';
            $html .=                '<th class="text-center">View&nbsp;Receipt</th>';
            $html .=             '</tr>';
            $html .=        '</thead>';
            $html .=        '<tbody>';
            foreach ($booking_data as $val) {

                if (isset($val['status']) && $val['status'] != '') {
                    $status = $val['status'];
                } else {
                    $status = $val['statusName'];
                }

                if ($status == 'SCHEDULED') {
                    $status = '<a href="javascript:void(0)" onclick="show_booking_status(`' . camelCase($val['ServiceSetup']) . '` ,`' . $val['status'] . '`)"><img src="' . asset('admin_assets/img/icons/booking-confirmed-icon.png') . '" height="35"width="35" style="vertical-align: middle!important;"></a>';
                } else {
                    $status = '<span class="badge">' . camelCase($status) . '</span>';
                }
                $html .= '<tr><td class="text-center">' . $val['tokenNumber'] . '</td>';
                $html .= '<td>' . camelCase($val['ServiceSetup']) . '</td>';
                $html .= '<td style="text-align:right;padding-right:25px">$ ' . sprintf("%.2f", $val['serviceAmount']) . '</td>';
                $html .= '<td class="text-center">' . $val['recCreDate'] . '</td>';
                $html .= '<td class="text-center">' . $val['serviceDate'] . '</td>';
                $html .= '<td class="text-center">' . $status . '</td>';
                $html .= '<td class="text-center"><a href="javascript:void(0)" onclick="CancelBooking(' . "'" . trim($val['_id']) . "'" . ')"><img src="' . asset('admin_assets/img/icons/booking-cancel-icon.png') . '" height="35"width="35" style="vertical-align: middle!important;"></a></td>';

                $serviceCategoryTypes = @$serviceCategoryTypes ? @$serviceCategoryTypes : @$aspectType;

                $html .= '<td class="text-center"><a href="#" id="btnExport" ><i class="fa fa-eye text-blue" style="font-size:22px"></i></a></td>
                </tr>';
            }
            $html .=         '</tbody>';
            $html .=     '</table>';

            echo $html;
        } else {
            echo $html;
        }
    }



    public function CancelBooking(Request $request)
    {
        // return "hgdh";
        $id = $request->_id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        $url = ApiBaseUrl()['url'] . postAPI()['url'];
        $data = array(
            "_id" => $id,
            "dataJson" => array("status" => "CANCELED"),
            "componentConfig" => array(
                "moduleName" => "Calendar",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "userName" => @session('refDataName')
            )
        );
        $data_string = json_encode($data);

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

        $token = session('token');
        $headers = array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        $response = json_decode($result);

        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        }
        curl_close($ch);

        echo json_encode($response);
    }

    // my donation

    public function MyDonations()
    {
        $data['page'] = 'MY-DONATIONS';
        $data['title'] = 'MY DONATIONS';
        $data['header'] = 'MY DONATIONS';

        $userName = session('refDataName');
        $email = session('email');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        // Assuming ApiBaseUrl() and filterAPI() are functions returning an associative array.
        $apiBaseUrl = ApiBaseUrl();
        $filterApi = filterAPI();

        $url = $apiBaseUrl['url'] . $filterApi['url'];

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        // Create an associative array to represent the data structure
        $postdata = array(
            "componentConfig" => array(
                "moduleName" => "Calendar",
                "productID" => $apiBaseUrl['productID'],
                "clientID" => $apiBaseUrl['clientID'],
                "aspectType" => "Service Schedules",
                "query" => array(
                    "aspectType" => "serviceBooking",
                    "paymentStatus" => "COMPLETED",
                    "memberId" => session('id'),
                    "serviceCategoryTypes" => "DONATIONS"
                ),
                "userName" => $userName, // Assuming $userName is defined somewhere
                "skip" => 0,
                "next" => 1020
            )
        );

        $jsonData = json_encode($postdata);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

        $token = session('token'); // Assuming session is set correctly
        $headers = array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        curl_close($ch);

        $response = json_decode($result);

        // Handle $response here as needed
        //usort($response->data, 'sortByTimestampDesc');

        $data['donations_data']  = json_decode(json_encode($response->data), true);
        return view('admin.my-donations', $data);
    }


    public function MyPayments()
    {
        $email = session('email');
        $userName = session('refDataName');


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); // Set it to 2 for strict host verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // Set it to 1 for peer verification

        // Constructing JSON data for the request body
        $request_data = array(
            "componentConfig" => array(
                "moduleName" => "Payments",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "aspectType" => "Payments",
                "query" => array(
                    "aspectType" => "Payments",
                    "memberId" => session()->get('id')
                ),
                "userName" => $userName,
                "skip" => 0,
                "next" => 1020
            )
        );

        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($request_data));

        $token = session()->get('token_key');
        $headers = array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        } else {
            $response = json_decode($result);

            // Check if the response was successful
            if ($response && isset($response->statusCode) && $response->statusCode == 1) {
                // Sort data by timestamp
                //usort($response->data, 'sortByTimestampDesc');
                $data['payments_data'] = $response->data;

                $data['page'] = 'MY-PAYMENTS';
                $data['title'] = 'MY PAYMENTS';
                $data['header'] = 'MY PAYMENTS';

                return view('admin.my-payments', $data);
            } else {
                // Handle unsuccessful response
                echo 'Error: Unsuccessful response received';
            }
        }

        curl_close($ch);
    }

    public function RefundPayment($payment_id)
    {
        $payment_id = base64_decode($payment_id);
        $email = session()->get('email');
        $userName = session()->get('refDataName');
        $ch = curl_init();

        // Set SSL options to ignore certificate verification (not recommended in production)
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        // Assuming ApiBaseUrl() and filterAPI() are functions returning the base URL and filter API URL respectively
        $url = ApiBaseUrl()['url'] . filterAPI()['url'];

        // Set cURL options
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        // Assuming $email, $payment_id, and $userName are defined somewhere in your code
        $postData = array(
            "componentConfig" => array(
                "moduleName" => "Payments",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "aspectType" => "Payments",
                "query" => array(
                    "aspectType" => "Payments",
                    "prsnEmail" => $email,
                    "insertedId" => $payment_id
                ),
                "userName" => $userName,
                "skip" => 0,
                "next" => 1020
            )
        );

        // Encode data as JSON
        $postDataJson = json_encode($postData);

        // Set the request payload
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

        // Set headers
        $token = session()->get('token');
        $headers = array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Execute the cURL request
        $result = curl_exec($ch);

        // Check for errors
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        // Close cURL resource
        curl_close($ch);

        // Decode the JSON response
        $response = json_decode($result, true);

        // Assuming $response['data'] contains payment data
        $data['payment_data'] = $response['data'];
        $data['page'] = 'REFUND PAYMENT FORM';
        $data['title'] = 'REFUND PAYMENT';
        $data['header'] = 'REFUND PAYMENT';

        // Load the view with payment data
        return view('admin.refund-form', $data);
    }


    //  Refund payment

    public function SubmitRefundForm(Request $request, $payment_id, $member_id)
    {
        // return $request->reason;
        $payment_id = base64_decode($payment_id);
        $member_id = base64_decode($member_id);
        $reason_of_refund = $request->reason;
        $orderno = $request->orderno;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        $url = ApiBaseUrl()['url'] . refundRequest()['url'];
        $data = [
            "memberId" => $member_id,
            "clientId" => ApiBaseUrl()['clientID'],
            "productId" => ApiBaseUrl()['productID'],
            "paymentId" => $payment_id,
            "refundReason" => $reason_of_refund
        ];
        $data_string = json_encode($data);

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

        $headers = [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string)
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $response = json_decode($result, true);

        if ($response['statusCode'] == 1) {
            $request->session()->flash('success', '<div class="alert alert-success alert-dismissible fade show" role="alert">Your Refund Request For <strong>Order No#: ' . $orderno . '</strong> has been sent Successfully. <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
        } else {
            $request->session()->flash('failure', '<div class="alert alert-danger alert-dismissible fade show" role="alert"><strong>Something went wrong.</strong> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
        }

        return redirect()->route('admin.my-payments');
    }


    public function YearlyTaxLetter()
    {
        $data['page'] = 'YEARLY-TAX-LETTER';
        $data['title'] = 'YEARLY TAX LETTER';
        $data['header'] = 'YEARLY TAX LETTER';
        return view('admin.YearlyTaxLetter', $data);
    }

    public function DownlaodTaxLetter(Request $request)
    {
        $year = $request->Year;
        // return $year;
        if (!empty($year)) { // Check if $year is not empty

            // Initialize cURL session
            $ch = curl_init();

            // Set cURL options
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . sendBookingDataPdfOnMail()['url']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);

            // Construct JSON data
            $postData = array(
                "userID" => "asdf",
                "memberId" => session('id'),
                "emailId" => base64_decode(session('email')),
                "clientId" => ApiBaseUrl()['clientID'],
                "year" => $year
            );

            // Set JSON data as POST fields
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

            // Set HTTP headers
            $headers = array(
                'Content-Type: application/json'
            );
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            // Execute cURL request
            $result = curl_exec($ch);

            // Check for cURL errors
            if (curl_errno($ch)) {
                echo 'Error: ' . curl_error($ch);
            }

            // Close cURL session
            curl_close($ch);

            // Decode the response JSON
            $response = json_decode($result);

            // Check the response status
            if ($response->statusCode == 1) {
                Session::flash('success', 'Your yearly tax letter (PDF) has been sent to your registered email id.');
                return redirect()->route('admin.yearly-Tax-Letter',);
            } else {
                Session::flash('failure', camelCase('Something went wrong!'));
                return redirect()->route('admin.yearly-Tax-Letter',);
            }
        } else {
            Session::flash('failure', camelCase('Please choose a year!'));
            return redirect()->route('admin.yearly-Tax-Letter',);
        }
    }
}
