<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class DonationsController extends Controller
{
    //

    public function index()
    {
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        $data['donationCategoryTypes'] = getDonationsCatTypes();
        $currency = '';
        $data['currency'] = GeneralSettings();
        $data['page'] = 'DONATIONS';
        $data['title'] = 'Donations';
        return view('donation.donations', $data);
    }

    public function addCart(Request $request)
    {



        $data = $request->all();
        //return $data;
        // Find the indexes where serviceAmount is 0.00
        $indexesToRemove = array_keys($data['serviceAmount'], '0.00');

        // Remove the elements with 0.00 serviceAmount from arrays
        foreach ($data as &$array) {
            if (is_array($array)) {
                foreach ($indexesToRemove as $index) {
                    unset($array[$index]);
                }
                // Re-index the array to reset keys
                $array = array_values($array);
            }
        }


        // print_r($data);

        if ($data) {
            session(['donations_cart' => $data]); // Use session() helper function to set session data
        }

        //dd(Session::get('donations_cart'));

        $response = array(
            'status' => '1',
            'message' => "Success"
        );
        echo json_encode($response);
    }

   

    public function Checkout()
    {
        $data['GeneralSettings'] = GeneralSettings();
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        if (!empty(session('logged_in')) && session('logged_in') == 1) {
            $data['page'] = 'DONATIONS';
            $data['title'] = 'Checkout';
            $data['session_data'] = 'donations_cart';
            return view('donation.donations-checkout', $data);
        } else {
            return redirect()->route('home');
        }
    }


   
    
}