<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class EventController extends Controller
{
    //
    public function index($eventName, $eventId)
    {

        $serviceId = $eventId;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        // Assuming ApiBaseUrl() is a function that returns an array with 'url', 'productID', and 'clientID' keys
        $baseUrl = ApiBaseUrl();
        $data = array(
            "_id" => $serviceId,
            "productId" => $baseUrl['productID'],
            "clientId" => $baseUrl['clientID']
        );

        $data_string = json_encode($data);

        curl_setopt($ch, CURLOPT_URL, $baseUrl['url'] . getServiceDetailbyId()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

        $headers = array('Content-Type: application/json');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        $response = json_decode($result);

        $data['serviceDetails'] = json_decode(json_encode($response->data[0]), true);

        curl_close($ch);
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        return view('events.events-details', $data);
    }

    public function allUpcomingEvents()
    {
        $data['page'] = 'Events';
        $data['title'] = 'Events';
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        $filter['query'] = ['aspectType' => 'ServiceSetup', 'serviceCategoryTypes' => 'EVENTS', 'sourceTypes' => 'WEBSITE', 'status' => 'ACTIVE', '$expr' => ['$eq' => ['$parentService', '']]];
        $data['upcoming_events'] = sortBySequenceId(getServiceRequestData($filter));
        return view('events.all-upcoming-events', $data);
    }
}
