<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Session;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class FormsController extends Controller
{
    //

    public function Volunteers()
    {
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');

        $data['page'] = 'VOLUNTEERS FORM';
        $data['title'] = 'VOLUNTEER-FORM';
        return view('volunteers', $data);
    }


    public function AddVolunteers(Request $request)
    {
        //return $request->all();
        $url = ApiBaseUrl()['url']  . 'api/upload/docsmany'; // Replace 'config('app.api_base_url')' with your actual base URL

        $file_path = request()->file('idcard')->path();

        $file_mime_type = request()->file('idcard')->getMimeType();

        $response = Http::withOptions([
            'verify' => false, // Disables SSL verification (use with caution)
        ])->attach('image', file_get_contents($file_path), basename($file_path), ['Content-Type' => $file_mime_type])
            ->post($url, [
                'type' => 'profile',
            ]);

        // Handle response
        if ($response->successful()) {
            $result = $response->json();
            if ($result['success'] == 1) {
                $idcard = json_decode($result['result']['message']['path'], true);
                $idcard_final = $idcard[0]['paths'];
                echo $idcard_final;
            }
        } else {
            $error = $response->status() . ': ' . $response->body();
            // Handle error
            echo 'Error: ' . $error;
        }
        $fname = $request->input('fname');
        $lname = $request->input('lname');

        $name = $fname . ' ' . $lname;

        $email = $request->input('email');
        $volunteerPhone = $request->input('volunteerPhone');
        $volunteerPhone = str_replace('-', '', $volunteerPhone);
        $Emrg_Contact_Name = $request->input('Emrg_Contact_Name');
        $Emrg_Contact_Number = $request->input('Emrg_Contact_Number');
        $Emrg_Contact_Number = str_replace('-', '', $Emrg_Contact_Number);
        $address = $request->input('address');
        $county = $request->input('county');
        $state = $request->input('state');
        $city = $request->input('city');
        $zipcode = $request->input('zipcode');
        $VolunteerArea = $request->input('VolunteerArea');
        $dob = $request->input('dob');
        $gender = $request->input('gender');
        $hours = $request->input('hours');
        $notes = $request->input('notes');

        $postdata = array(
            "productId" => ApiBaseUrl()['productID'],
            "clientId" => ApiBaseUrl()['clientID'],
            "date" => date("m/d/Y"),
            "time" => date("h:i A"),
            "volunteerID" => "",
            "name" => $name,
            "mobile" => $volunteerPhone,
            "email" => $email,
            "volunteerArea" => $VolunteerArea,
            "isInsert" => true,
            "emrgContactName" => $Emrg_Contact_Name,
            "emrgContactNumber" => $Emrg_Contact_Number,
            "dob" => $dob,
            "gender" => $gender,
            "workingHours" => $hours,
            "base64" => '/uploads/others/' . $idcard_final,
            "notes" => $notes,
            "country" => $county,
            "state" => $state,
            "city" => $city,
            "zip" => $zipcode,
            "address" => $address
        );

        $json_postdata = json_encode($postdata);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . addVolunteer()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json_postdata);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        $response = json_decode($result);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        // print_r($result); die();

        if ($response->statusCode == 1) {
            session::flash('success', '<div class="alert alert-success alert-dismissible fade show text-center">Volunteer Details Added Successfully!<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
            return redirect()->back();
        } else {
            session::flash('failure', '<div class="alert alert-warning alert-dismissible fade show text-center">Something Went Wrong!<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
            return redirect()->back();
        }
    }
}
