<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
class GharbhalayaLandController extends Controller
{
    //
      public function index(){
         $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
         
        return view('donation.GharbhalayaLand.gharbhalaya_land',$data);
    }

     public function addCart(Request $request)
    {                
        $data = $request->all();
        $_id = $data['_id'];
        $infoValue = $data['totalAmt'];
        $totalSum = Session::get('totalSum', 0);
        $cartItems = Session::get('ghabhalaya_service_cart', []);
        $found = false;
        foreach ($cartItems as $key => $item) {
            if ($item['_id'] == $_id) {
                // Item found, adjust the total sum and count
                if (isset($item['count']) && $item['count'] > 1) {
                    // Decrement the count and adjust the total amount
                    $cartItems[$key]['count']--;
                    $totalSum -= $infoValue;
                } else {
                    // Remove the item if count is 1 or less
                    $totalSum -= $item['totalAmt'];
                    unset($cartItems[$key]);
                }
                $found = true;
                break;
            }
        }

        if (!$found) {
            // Item not found, add it to the cart with count 1
            $totalSum += $infoValue;
            $data['count'] = 1;
            $cartItems[] = $data;
            $message = 'Item added successfully';
            $statusCode = 1;
        } else {
            $message = 'Item removed successfully';
            $statusCode = 0;
        }

        Session::put('totalSum', $totalSum);
        Session::put('ghabhalaya_service_cart', $cartItems);

        $response = [
            'status' => '1',
            'message' => $message,
            'data' => $cartItems, // Optionally include updated cart items in the response
            'totalSum' => $totalSum,
            'statusCode' => $statusCode,
            'count' => array_sum(array_column($cartItems, 'count')), // Add the total count of items
        ];

        return response()->json($response);

        
   


    }
   


    public function checkout(){
           $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
           
        return view('donation.GharbhalayaLand.gharbhalaya_land_checkout',$data);
    }
}