<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{

    public function home()
    {
        $banner = getWebSyncsData('Banner Images', 'bannerImages', 'ACTIVE');
        $data['slider_image'] = sortBySequenceId($banner);
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');

        $filter['query'] = ['aspectType' => 'ServiceSetup', 'serviceCategoryTypes' => 'EVENTS', 'sourceTypes' => 'WEBSITE', 'status' => 'ACTIVE', '$expr' => ['$eq' => ['$parentService', '']]];


        $data['upcoming_events'] = sortBySequenceId(getServiceRequestData($filter));
        return view('index', $data);
    }

    public function index()
    {
        return view('about');
    }

    //
    public function getpanchangamData(Request $result)
    {
        // dd( $result->all() );
        $lat = $result->input('lat');
        $long = $result->input('long');
        $tzone = $result->input('tzone');

        $year = date('Y');
        $month = date('m');
        $day = date('d');
        $hours = date('H');
        $minute = date('i');

        $panchangam = getPanchangamData($lat, $long, $tzone, $year, $month, $day, $hours, $minute);

        $panchangam = json_decode(json_encode($panchangam), true);
        //dd($panchangam);
        $html = '';
        $html .= '<div class="table-responsive">
       <table class="table table-responsive table-bordered table-striped" style="border-collapse: collapse;min-height:420px">
       <tbody>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Date</td>
       <td>' . date('m/d/Y') . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Day</td>
       <td>' . $panchangam['day'] . '</td>
       <tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Tithi</td>
       <td>' . $panchangam['tithi'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Nakshatra</td>
       <td>' . $panchangam['nakshatra'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Yog</td>
       <td>' . $panchangam['yog'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Karan</td>
       <td>' . $panchangam['karan'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Sunrise</td>
       <td>' . $panchangam['sunrise'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Sunset</td>
       <td>' . $panchangam['sunset'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Vedic Sunrise</td>
       <td>' . $panchangam['vedic_sunrise'] . '</td>
       </tr>
       <tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
       <td>Vedic Sunset</td>
       <td>' . $panchangam['vedic_sunset'] . '</td>
       </tr>
       </tbody>
       </table>
       </div>';
        echo json_encode($html);
    }

    public function SignUp(Request $result)
    {
        //dd($result->all());
        if (!empty($result->input('fname')) || !empty($result->input('email')) || !empty($result->input('email'))) {
            $fname = $result->input('fname');
            $lname =  $result->input('lname');
            $email = $result->input('email');
            $phone = $result->input('phone');
            $countryCode = $result->input('countryCode');
            $data = array(
                'refDataName' => $fname . ' ' . $lname,
                'email' => $email,
                'phone' => $phone,
                'contryCode' => $countryCode
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $url = ApiBaseUrl()['url'] . customerSignup()['url'];
            $postfield = json_encode(array(
                'dataJson' => $data,
                'componentConfig' => array(
                    'moduleName' => customerSignup()['moduleName'],
                    'productID' => ApiBaseUrl()['productID'],
                    'clientID' => ApiBaseUrl()['clientID']
                )
            ));
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postfield);
            $headers = array('Content-Type: application/json');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $result = curl_exec($ch);
            if (curl_errno($ch)) {
                echo 'Error: ' . curl_error($ch);
            } else {
                echo $result;
            }

            curl_close($ch);
        }
    }

    //   Send OTP

    public function sendEmailOTP(Request $request)
    {
        // dd($request->all());
        $email = $request->email;
        $postfield = array(
            'email' => $email,
            'isMobile' => false,
            'phone' => ''
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $url = ApiBaseUrl()['url'] . customerLogin()['url'];
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        $requestData = json_encode(array(
            'dataJson' => $postfield,
            'componentConfig' => array(
                'moduleName' => customerLogin()['moduleName'],
                'productID' => ApiBaseUrl()['productID'],
                'clientID' => ApiBaseUrl()['clientID']
            )
        ));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requestData);
        $headers = array('Content-Type: application/json');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $response = json_decode($result);
        // dd( $response );
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        }
        //dd($response);
        if ($response->statusCode == 1) {
            // dd( 'jjg' );
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $url = ApiBaseUrl()['url'] . sendEmailOTP()['url'];
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);

            $postData = json_encode(array(
                'emailID' => $email,
                'clientID' => ApiBaseUrl()['clientID']
            ));

            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

            $headers = array('Content-Type: application/json');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = curl_exec($ch);
            // dd( $result );
            $response = json_decode($result);
            if (curl_errno($ch)) {
                echo 'Error: ' . curl_error($ch);
            }
            curl_close($ch);

            if ($response->user->statusCode == 0) {
                $response->user->statusCode = '2';
            }

            echo json_encode($response->user);
        } else {
            echo json_encode($response);
        }
    }

    //verify OTP


    // public function verifyEmailOTP(Request $request)
    // {
    //     // Get OTP and email from request
    //     $otp = $request->otp;
    //     $email = $request->email;

    //     // Initialize cURL
    //     $ch = curl_init();

    //     // Set cURL options
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    //     curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . verifyEmailOTP()['url']);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    //     curl_setopt($ch, CURLOPT_POST, 1);
    //     // Set request data in JSON format
    //     $postData = [
    //         'emailID' => $email,
    //         'code' => $otp
    //     ];
    //     $postDataJson = json_encode($postData);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

    //     // Set request headers
    //     $headers = array(
    //         'Content-Type: application/json',
    //         'Content-Length: ' . strlen($postDataJson)
    //     );
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    //     // Execute cURL request
    //     $result = curl_exec($ch);
    //     $otp = $request->otp;
    //     $email = $request->email;
    //     // Initialize cURL
    //     $ch = curl_init();

    //     // Set cURL options
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    //     curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . verifyEmailOTP()['url']);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    //     curl_setopt($ch, CURLOPT_POST, 1);
    //     // Set request data in JSON format
    //     $postData = [
    //         'emailID' => $email,
    //         'code' => $otp
    //     ];
    //     $postDataJson = json_encode($postData);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

    //     // Set request headers
    //     $headers = array(
    //         'Content-Type: application/json',
    //         'Content-Length: ' . strlen($postDataJson)
    //     );
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    //     // Execute cURL request
    //     $result = curl_exec($ch);

    //     // Check for cURL errors
    //     if (curl_errno($ch)) {
    //         echo 'Error:' . curl_error($ch);
    //     }

    //     // Close cURL
    //     curl_close($ch);

    //     // Decode JSON response
    //     //$response = json_decode($result);
    //     //return $response;
    //     // Output response
    //     // dd($result);
    // }
    // public function verifyEmailOTP(Request $request)
    // {
    //     //print_r($request->all());die;
    //     $otp =  $request->otp;
    //     $email =  $request->email;

    //     $response = Http::withOptions([
    //         'verify' => false, // Set to true if SSL verification is required
    //     ])
    //         ->post(ApiBaseUrl()['url'] . verifyEmailOTP()['url'], [
    //             'emailID' => $email,
    //             'code' => $otp,
    //         ]);

    //     if ($response->failed()) {
    //         // Handle the error
    //         echo 'Error: ' . $response->body();
    //     } else {
    //         $responseData = $response->json();
    //         dd($responseData['user']);
    //         echo json_encode($responseData['user']);
    //     }
    // }
    public function login(Request $request)
    {
        // dd($request->all());

        // dd( $request->LoginTabName );
        if (!empty($request->email) || !empty($request->phone)) {
            $email = $request->email;
            $phone = $request->phone;
            $LoginTabName = $request->LoginTabName;

            if ($LoginTabName == 'Management') {
                $moduleName = 'Management Directory';
            } else {
                $moduleName = customerLogin()['moduleName'];
            }

            if (!empty($email)) {
                $data = array('email' => $email, 'isMobile' => false, 'phone' => $phone);
            } else {
                $data = array('email' => $email, 'isMobile' => true, 'phone' => $phone);
            }

            $postfield =  $data;
            //print_r($postfield);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

            $url = ApiBaseUrl()['url'] . customerLogin()['url'];
            $postfield = json_encode([
                'dataJson' => $postfield, // Assuming $postfield is defined elsewhere
                'componentConfig' => [
                    'moduleName' => $moduleName,
                    'productID' => ApiBaseUrl()['productID'],
                    'clientID' => ApiBaseUrl()['clientID']
                ]
            ]);

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postfield);

            $headers = array('Content-Type: application/json');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = curl_exec($ch);
            $response = json_decode($result);

            if (curl_errno($ch)) {
                echo 'Error: ' . curl_error($ch);
            }

            curl_close($ch);

            //dd($response);
            //die;
            if ($response->statusCode == 1) {
                if ($email != '' || $request->sessionCreate == 1) {

                    if ($moduleName == 'Management Directory') {

                        $logged_in_sess = array(
                            'id'           => $response->data[0]->_id,
                            'refDataName'         => $response->data[0]->refDataName,
                            'email'         => $response->data[0]->email,
                            'phone'       => $response->data[0]->phone,
                            'logged_in'    => 1,
                            'token' => $response->data[0]->token,
                            'memberTypes' => @$response->data[0]->memberTypes,
                            'address' => @$response->data[0]->address,
                            'userType' => 'Managements'

                        );
                    } else {

                        $logged_in_sess = array(
                            'id'           => $response->data[0]->_id,
                            'refDataName'         => $response->data[0]->refDataName,
                            'email'         => $response->data[0]->email,
                            'phone'       => $response->data[0]->phone,
                            'logged_in'    => 1,
                            'token' => $response->data[0]->token,
                            'memberTypes' => $response->data[0]->memberTypes,
                            'address' => @$response->data[0]->address,
                            'userType' => 'Devotee'

                        );
                    }
                    session($logged_in_sess);
                }

                echo json_encode($response);
            } else {
                echo json_encode('User not found!!');
            }
        } else {
            echo json_encode('Something Went Wrong!!');
        }
    }
    public function verifyEmailOTP(Request $request)
    {
        $otp = $request->otp;
        $email = $request->email;

        $postData = json_encode(array('emailID' => $email, 'code' => $otp));

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . verifyEmailOTP()['url']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

        $headers = array(
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $error = 'Error:' . curl_error($ch);
            curl_close($ch);
            return response()->json(['error' => $error], 500);
        }

        curl_close($ch);

        $response = json_decode($result);

        if (isset($response->user)) {
            return response()->json($response->user);
        } else {
            return response()->json(['error' => 'User not found'], 404);
        }
    }

    public function checkLoginStatus(Request $request)
    {
        // return $request->all();
        if ($request->session()->get('logged_in') == 1) {
            return response()->json(1);
        } else {
            return response()->json(0);
        }
    }

    // calendar

    public function calendar()
    {
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        $data['calendar_events'] =  getWebSyncsData('Temple Calendar', 'templeCalendar', '');
        return view('calendar', $data);
    }



    public function GetCity(Request $request)
    {
        $stateName = $request->stateCode;



        $ch = curl_init();
        $url = ApiBaseUrl()['url'] . filterAPI()['url'];
        //  $stateName = "YourStateName"; // Define your state name here

        // Set cURL options
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        // Prepare POST data
        $postData = [
            "componentConfig" => [
                "moduleName" => "Master Data Management",
                "productID" => ApiBaseUrl()['productID'],
                "clientID" => ApiBaseUrl()['clientID'],
                "aspectType" => "cityTypes",
                "query" => [
                    "aspectType" => "cityTypes",
                    "refDataCode" => $stateName
                ],
                "skip" => 0,
                "next" => 700
            ]
        ];
        $postDataJson = json_encode($postData);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

        $headers = [
            'Content-Type: application/json'
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Execute cURL request
        $result = curl_exec($ch);

        // Check for errors
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        } else {
            // Decode JSON response
            $response = json_decode($result);
            // return  $response;
            // Check if the response is successful
            if ($response->statusCode == 1) {
                $option = '<option value="" selected disabled>Select City</option>';

                // Sort the data by refDataName
                usort($response->data, function ($a, $b) {
                    return strcmp($a->refDataName, $b->refDataName);
                });

                foreach ($response->data as $item) {
                    $option .= '<option value="' . $item->refDataName . '">' . $item->refDataName . '</option>';
                }

                echo $option;
            } else {
                echo "Error: " . $response->error;
            }
        }

        // Close cURL session
        curl_close($ch);
    }
    public function contact_us()
    {
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        $data['page'] = 'CONTACT-US';
        $data['title'] = 'CONTACT-US';
        return view('contact_us', $data);
    }


    public function submitContactForm(Request $request)
    {
        // return $request->all();
        $phone = request('phone');

        $new_phone = str_replace('-', '', $phone);

        $fname = request('fname');
        $lname = request('lname');
        $email = request('email');
        $regardingTypes = request('regardingTypes');
        $state = request('state');
        $city = request('city');
        $zipcode = request('zipcode');
        $address = request('address');
        $message = request('message');

        $captcha_response = trim(request('g-recaptcha-response'));
        // dd($captcha_response);
        if ($captcha_response != '') {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . sendContactEmail()['url']);

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "firstName" => $fname,
                "lastName" => $lname,
                "phone" => $new_phone,
                "email" => $email,
                "regardingTypes" => $regardingTypes,
                "address" => $address,
                "state" => $state,
                "city" => $city,
                "zipcode" => $zipcode,
                "purpose" => "",
                "message" => $message,
                "clientID" => ApiBaseUrl()['clientID']
            ]));

            $headers = array('Content-Type: application/json');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = curl_exec($ch);
            $response = json_decode($result);

            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);

            // print_r($response);
            // die();

            if (@$response->statusCode == 1) {
                session::flash('success', 'We will contact you as soon as possible.');
                return redirect()->back();
            } else {
                session::flash('failure', 'Something went wrong!');
                return redirect()->back();
            }
        } else {
            session::flash('failure', 'Captcha Validation Failed');
            return redirect()->back();
        }
    }
}