<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class RecurringSponsorNowController extends Controller
{
    //
    public function getRecurringSponsorServices($serviceType)
    {
        if ($serviceType == 'recurring-donations') {
            $serviceType = 'RECURRING DONATIONS';
        }

        if (!empty(session('recurring_donations_cart')['serviceTypes'])) {
            $sessionArray = session('recurring_donations_cart')['serviceTypes'];
            if (session('recurring_donations_cart')['serviceTypes'][0] != $serviceType) {
                session()->forget('recurring_donations_cart');
            }
        }

        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        $data['sponsorType_details'] = getSponsorTypes($serviceType);
        $data['page'] = 'RECURRING-DONATIONS';
        $data['title'] = 'RECURRING DONATIONS';
        $data['serviceType'] = $serviceType;
        return view('recurring-donations.recurring-donations', $data);
    }

    public function Checkout()
    {

        $data['GeneralSettings'] = GeneralSettings();
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        if (!empty(session('logged_in')) && session('logged_in') == 1) {

            $data['page'] = 'RECURRING-DONATIONS';
            $data['title'] = 'Checkout';

            $data['session_data'] = 'recurring_donations_cart';

            // dd($data['session_data']);
            return  view('recurring-donations.recurring-checkout', $data);
        } else {
            return redirect()->route('home');
        }
    }
}
