<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Session;

class ServiceController extends Controller
{
    //
    public function index()
    {
        $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');
        if (session('logged_in') == 1 && session('userType') == 'Devotee') {
            $data['userDetails'] =  getUserDetails()->data[0];
        }
        return view('services.services', $data);
    }

    public function ServiceRequestForm($request_page)
    {
        //   return $request_page;

        $currency = '';
        $data['currency'] = GeneralSettings();
        $data['page'] = 'Services';
        if ((session('logged_in') == 1 && $request_page == 'outside-temple') || (session('logged_in') == 1 && $request_page == 'aparakarya')) {

            $data['header_data'] = getWebSyncsData('Header Settings', 'headerSettings', '');

            $data['preferredLocations'] = getPreferredLocations()->data;

            $data['userDetails'] =  getUserDetails()->data[0];

            //           $data['PriestData'] = getPriest()->data;

            return view('services.services', $data);
        } else {
            return redirect('services');
        }
    }
    public function getThithiNext90Days(Request $request)
    {
        return $request->all();

        $tithi = $request('tithi');
        $datesArray = getThithiNext90Days($tithi);


        if (!empty($datesArray['data'])) {
            $dates = array();
            foreach ($datesArray['data'] as $key => $value) {

                $newDate = str_replace("T00:00:00.000Z", "", $value['startDate']);

                array_push($dates, $newDate);
                // $dates =  $newDate;
            }
            echo json_encode($dates);
            // echo '<pre>';
            // print_r($datesArray);
            // die();

        } else {
            echo json_encode($datesArray);
        }
    }

    public function addCart(Request $request)
    {
        //return $request->all();
        if ($request) {
            Session::put('service_cart', $request->all());

            $cartList = Session::get('service_cart');

            if (isset($cartList['includeSankalpam'])) {
                $includeSankalpam = checkForYesValue($cartList['includeSankalpam']);
            } else {

                $includeSankalpam = 'NO';
            }
        }


        $response = array(
            'status' => '1',
            'message' => "Success",
            'includeSankalpam' => $includeSankalpam
        );
        return json_encode($response);
    }
}
