@extends('includes.master')
@section('title', 'Services')


@section('style-section')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style type="text/css">
        .custom-form-control {
            padding: 1rem 0.75rem;
            border: 1px solid #758085;
            margin: 5px;
        }

        .contact-icons {
            color: white;
            border-radius: 50%;
            background-color: var(--headerFooter);
            font-size: 19px;
            text-align: center;
            padding: 11px 11px;
            height: 41px;
            width: 41px;
        }

        .custom-form-select {
            height: 59px !important;
            color: #758085 !important;
        }

        #g-recaptcha-response {
            display: block !important;
            position: absolute;
            margin: -78px 0 0 0 !important;
            width: 302px !important;
            height: 76px !important;
            z-index: -999999;
            opacity: 0
        }

        .clearbtn:hover {
            box-shadow: 1px 1px 10px red !important;
        }

        .submitbtn:hover {
            box-shadow: 1px 1px 10px #8AB4F8 !important;
        }

        .icon {
            color: white;
            background-color: #b02135;
            font-size: 20px;
            padding: 14px;
        }
    </style>
@section('content')
    @php
        $conatctus_data = getWebSyncsData('Contactus Settings', 'contactusSettings', '');
    @endphp

    <section class="" style="background-color:var(--page-wrapper-bg-color)!important">
        <div style="padding:0px 50px">
            <!--Section heading-->
            <div class="row m-0 p-0">
                <!--Grid column-->
                <div class="col-md-4 m-0 p-0">
                    <div class="row m-0 p-0" id="service-data">
                        <center>
                            <h2 id="temple-services" class="text-center bottomborder p-4">GET IN TOUCH</h2>
                        </center><br>
                        <div class="col-md-12 py-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row mx-4">
                                        <div class="col-md-12">
                                            <h4><b>{{ GetProjectName() }}</b></h4>
                                        </div>
                                    </div>
                                    <div class="row m-4">
                                        <div class="col-md-3"><i class="contact-icons fa fa-map-marker icon"></i></div>
                                        <div class="col-md-9">
                                            {!! (isset($conatctus_data[0]['refDataName']) && $conatctus_data[0]['refDataName']) != ''
                                                ? $conatctus_data[0]['refDataName']
                                                : '' !!}
                                        </div>
                                    </div>
                                    <div class="row m-4">
                                        <div class="col-md-3"><i class="contact-icons fa fa-phone icon"></i></div>
                                        <div class="col-md-9">
                                            {{ (isset($conatctus_data[0]['templePhone']) && $conatctus_data[0]['templePhone']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['templePhone']) : '' }}
                                        </div>
                                    </div>
                                    <div class="row m-4">
                                        <div class="col-md-3"><i class="contact-icons fa fa-envelope icon"></i></div>
                                        <div class="col-md-9">
                                            {{ (isset($conatctus_data[0]['templeEmail']) && $conatctus_data[0]['templeEmail']) != '' ? $conatctus_data[0]['templeEmail'] : '' }}
                                        </div>
                                    </div>
                                    <div class="row m-4">
                                        <?php  if (isset($conatctus_data[0]['priestName1']) && $conatctus_data[0]['priestName1']) {?>
                                        <div class="row m-4">
                                            <div class="col-md-12">
                                                <h4><b>For Priest Services</b></h4>
                                            </div>
                                        </div>


                                        <div class="col-md-3 my-2"><i class="contact-icons fa fa-phone icon"></i></div>
                                        <div class="col-md-9"><span
                                                class="fw-bold">{{ (isset($conatctus_data[0]['priestName1']) && $conatctus_data[0]['priestName1']) != '' ? $conatctus_data[0]['priestName1'] : '' }}</span><br>
                                            <a
                                                href="tel:{{ (isset($conatctus_data[0]['priestPhone1']) && $conatctus_data[0]['priestPhone1']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone1']) : '' }}">{{ (isset($conatctus_data[0]['priestPhone1']) && $conatctus_data[0]['priestPhone1']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone1']) : '' }}</a>
                                        </div>
                                        <?php } ?>


                                        <?php  if (isset($conatctus_data[0]['priestName2']) && $conatctus_data[0]['priestName2']) {?>
                                        <div class="col-md-3 my-3"><i class="contact-icons fa fa-phone icon"></i></div>
                                        <div class="col-md-9"><span
                                                class="fw-bold">{{ (isset($conatctus_data[0]['priestName2']) && $conatctus_data[0]['priestName2']) != '' ? $conatctus_data[0]['priestName2'] : '' }}</span><br>
                                            <a
                                                href="tel:{{ (isset($conatctus_data[0]['templePhone']) && $conatctus_data[0]['priestPhone2']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone2']) : '' }}">{{ (isset($conatctus_data[0]['priestPhone2']) && $conatctus_data[0]['priestPhone2']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone2']) : '' }}</a>
                                        </div>
                                        <?php } ?>


                                        <?php  if (isset($conatctus_data[0]['priestName3']) && $conatctus_data[0]['priestName3']) {?>
                                        <div class="col-md-3 my-2"><i class="contact-icons fa fa-phone icon"></i></div>
                                        <div class="col-md-9"><span
                                                class="fw-bold">{{ (isset($conatctus_data[0]['priestName3']) && $conatctus_data[0]['priestName3']) != '' ? $conatctus_data[0]['priestName3'] : '' }}</span><br>
                                            <a
                                                href="tel:{{ (isset($conatctus_data[0]['priestPhone3']) && $conatctus_data[0]['priestPhone3']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone3']) : '' }}">{{ (isset($conatctus_data[0]['priestPhone3']) && $conatctus_data[0]['priestPhone3']) != '' ? '+1 ' . formatPhoneNumber($conatctus_data[0]['priestPhone3']) : '' }}</a>
                                        </div>
                                        <?php } ?>

                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-12 mx-2">
                            <h4><b>FOLLOW US</b></h4>
                            <span class=""
                                style="position:absolute!important;margin-top: -12px!important; width: 50px!important;"></span>
                            <a
                                href="{{ (isset($conatctus_data[0]['facebookLink']) && $conatctus_data[0]['facebookLink']) != '' ? $conatctus_data[0]['facebookLink'] : 'javascript:void(0)' }}"><i
                                    class="contact-icons fa fa-facebook icon"></i></a>

                            <a
                                href="{{ (isset($conatctus_data[0]['youtubeLink']) && $conatctus_data[0]['youtubeLink']) != '' ? $conatctus_data[0]['youtubeLink'] : 'javascript:void(0)' }}"><i
                                    class="contact-icons fa fa-youtube icon"></i></a>


                        </div>
                    </div>

                </div>
                <!--Grid column-->
                <div class="col-md-8 mb-0 p-0">
                    <h2 id="temple-services" class="text-center bottomborder p-4"> CONTACT US</h2>
                    <form id="contact-form" name="contact-form" action="{{ url('your-query') }}" method="POST">
                        @csrf
                        @if (session()->has('failure'))
                            <div class="alert alert-danger alert-dismissible fade show text-center">
                                <strong>Failed!</strong> {{ session('failure') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        @if (session()->has('success'))
                            <div class="alert alert-success alert-dismissible fade show text-center">
                                <strong>Success!</strong> {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <!--Grid row-->
                        <div class="row">
                            <!--Grid column-->
                            <div class="col-md-6">
                                <div class="md-form mb-0">
                                    <input type="text" id="fname" name="fname"
                                        class="custom-form-control form-control" placeholder="First Name*" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="md-form mb-0">
                                    <input type="text" id="lname" name="lname"
                                        class="custom-form-control form-control" placeholder="Last Name*">
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="md-form mb-0">
                                    <input type="email" id="email" name="email"
                                        class="custom-form-control form-control" placeholder="Email*" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="md-form mb-0">
                                    <input id="phone" type="text" name="phone"
                                        class="custom-form-control form-control" placeholder="Phone Number*" required />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">

                                <div class="md-form mb-0">
                                    <input type="text" class="form-control" name="address" id="address"
                                        placeholder="Address" required />
                                </div>

                            </div>
                        </div>
                        <div class="row mt-3">

                            <div class="col-md-4">
                                <div class="md-form mb-0">
                                    <select class="form-control form-select " name="state" id="stateSelect">
                                        <option value="" selected disabled>Select State</option>
                                        <?php
										$GetState = GetState();
										$keys = array_column($GetState, 'refDataName');
										array_multisort($keys, SORT_ASC, $GetState);

										foreach ($GetState as $state) { ?>
                                        <option value="<?= @$state->refDataName ?>"><?= @$state->refDataName ?></option>
                                        <?php } ?>
                                    </select>

                                </div>
                            </div>
                            <div class="col-md-4">

                                <div class="md-form mb-0">

                                    <select class="form-control form-select" name="city" id="city">
                                        <option value="" selected disabled>Select City</option>
                                    </select>
                                </div>

                            </div>

                            <div class="col-md-4">

                                <div class="md-form mb-0">

                                    <input type="number" class="form-control" maxlength="6" name="zipcode"
                                        placeholder="Zipcode" />
                                </div>

                            </div>
                            <div class="col-md-4 mt-3">
                                <div class="md-form mb-0">
                                    <select class="form-control form-select " name="regardingTypes" id="regardingTypes">
                                        <option value=" " selected disabled>Regarding</option>
                                        <?php
										$RegardingTypes = RegardingTypes();
										$keys = array_column($RegardingTypes, 'refDataName');
										array_multisort($keys, SORT_ASC, $RegardingTypes);

										foreach ($RegardingTypes as $regarding) { ?>
                                        <option value="{{ @$regarding->refDataName }}">{{ @$regarding->refDataName }}
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>

                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">

                                <div class="md-form">
                                    <textarea type="text" id="message" name="message" rows="2" class="form-control md-textarea"
                                        placeholder="Your Comments*" required></textarea>
                                </div>

                            </div>

                            <div class="col-md-6 mt-3">
                                <div class="md-form mx-2">
                                    <div class="g-recaptcha" data-sitekey="6LdJ_7EnAAAAABrUBeevWReokh9uIecIz4zdev0Z">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <center class="my-3">

                            <button class="btn btn-primary text-white clearbtn" type="reset"
                                style="color: black; border-radius: 20px;  border-color: white; background: #B02135; !important; box-shadow: 1px 1px 10px #7e455561;padding: 5px 30px;">CLEAR</button>
                            <button class="btn text-white  submitbtn" type="submit"
                                style="color: #635C81; border-radius: 20px;  border-color: white; background: #008080 !important; box-shadow: 1px 1px 10px #7e455561;padding: 5px 30px;"
                                onclick="ldldSample.full.toggle();">SUBMIT</button>

                        </center>
                    </form>
                    <div class="status"></div>
                </div>
                <!--Grid column-->
                <div class="col-md-12 mt-5">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d5514.606689654719!2d-119.35296755777101!3d46.28394744895695!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x54986fe392c1a209%3A0xce626dc2061088a!2sHindu%20Society%20of%20Eastern%20Washington!5e0!3m2!1sen!2sin!4v1701241023800!5m2!1sen!2sin"
                        width="100%" height="500px" style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
        </div>
    </section>
@endsection
<script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>
<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>

<script type="text/javascript">
    $(document).ready(function() {
        function phone_formatting(ele, restore) {
            var new_number,
                selection_start = ele.selectionStart,
                selection_end = ele.selectionEnd,
                number = ele.value.replace(/\D/g, '');
            if (number.length > 2) {
                new_number = number.substring(0, 3) + '-';
                if (number.length === 4 || number.length === 5) {
                    new_number += number.substr(3);
                } else if (number.length > 5) {
                    new_number += number.substring(3, 6) + '-';
                }
                if (number.length > 6) {
                    new_number += number.substring(6);
                }
            } else {
                new_number = number;
            }


            ele.value = (new_number.length > 12) ? new_number.substring(12, 0) : new_number;

            document.getElementById('msg').innerHTML = '<p>Selection is: ' + selection_end +
                ' and length is: ' + new_number
                .length + '</p>';

            if (new_number.slice(-1) === '-' && restore === false &&
                (new_number.length === 8 && selection_end === 7) ||
                (new_number.length === 4 && selection_end === 3)) {
                selection_start = new_number.length;
                selection_end = new_number.length;
            } else if (restore === 'revert') {
                selection_start--;
                selection_end--;
            }
            ele.setSelectionRange(selection_start, selection_end);

        }

        function phone_number_check(field, e) {
            var key_code = e.keyCode,
                key_string = String.fromCharCode(key_code),
                press_delete = false,
                dash_key = 189,
                delete_key = [8, 46],
                direction_key = [33, 34, 35, 36, 37, 38, 39, 40],
                selection_end = field.selectionEnd;

            // delete key was pressed
            if (delete_key.indexOf(key_code) > -1) {
                press_delete = true;
            }
            if (key_string.match(/^\d+$/) || press_delete) {
                phone_formatting(field, press_delete);
            } else if (direction_key.indexOf(key_code) > -1) {
                // do nothing
            } else if (dash_key === key_code) {
                if (selection_end === field.value.length) {
                    field.value = field.value.slice(0, -1)
                } else {
                    field.value = field.value.substring(0, (selection_end - 1)) + field.value.substr(
                        selection_end)
                    field.selectionEnd = selection_end - 1;
                }
            } else {
                e.preventDefault();
                phone_formatting(field, 'revert');
            }
        }

        document.getElementById('phone').onkeyup = function(e) {
            phone_number_check(this, e);
        }

    });

    window.addEventListener('load', () => {
        const $recaptcha = document.querySelector('#g-recaptcha-response');
        if ($recaptcha) {
            $recaptcha.setAttribute('required', 'required');
        }
    })



    $(document).ready(function() {
        $('#stateSelect').change(function() {

            var stateCode = $(this).val();
            // alert(stateCode);
            $.ajax({
                url: "{{ url('getcity') }}",
                type: "POST",
                // dataType: "json",
                data: {
                    'stateCode': stateCode
                },
                success: function(data) {
                    $("#city").html(data);
                }
            });

        });
    });


    $(document).ready(function() {
        window.scrollTo({
            top: 250,
            behavior: 'smooth'
        });
    });
</script>
