@extends('includes.master')
@section('title', 'About Priest')

@section('style-section')
    <style type="text/css">
        @import url(//fonts.googleapis.com/css?family=Montserrat:300,500);

        .team4 {
            font-family: "Montserrat", sans-serif;
            color: #8d97ad;
            font-weight: 300;
        }

        .team4 h1,
        .team4 h2,
        .team4 h3,
        .team4 h4,
        .team4 h5,
        .team4 h6 {
            color: #3e4555;
        }

        .team4 .font-weight-medium {
            font-weight: 500;
        }

        .team4 h5 {
            line-height: 22px;
            font-size: 18px;
        }

        .team4 .subtitle {
            color: #8d97ad;
            line-height: 24px;
            font-size: 13px;
        }

        .team4 ul li a {
            color: #8d97ad;
            padding-right: 15px;
            -webkit-transition: 0.1s ease-in;
            -o-transition: 0.1s ease-in;
            transition: 0.1s ease-in;
        }

        .team4 ul li a:hover {
            -webkit-transform: translate3d(0px, -5px, 0px);
            transform: translate3d(0px, -5px, 0px);
            color: #316ce8;
        }

        .container-fluid {
            padding: 0px !important;
        }
    </style>
@section('content')

    <!-- ======= About Committee Section ======= -->
    <section style="background-color: var(--page-wrapper-bg-color)!important">
        <div class="responsive-container">
            <center>
                <h2 class="bottomborder p-4" style="font-weight:bold!important;font-size: 35px!important;">Our Beloved Priests
                </h2>
            </center>


            <div class="py-5 team4">
                <div class="container-fluid">
                    <div class="row ">

                        <?php foreach($priest_data['data'] as $item){ ?>
                        <!-- column  -->
                        <div class="col-lg-3 rounded "
                            style="background: #ffbc00;border: 10px solid #fff8e1;    padding-bottom: 30px;">
                            <!-- Row -->
                            <div class="row px-0">
                                <div class="col-md-12 px-0" style="padding-top: 10px;">
                                    <img src="{{ ApiBaseUrl()['url'] . $item['image'] }}" alt="{{ $item['refDataName'] }}"
                                        class="img-fluid rounded-circle" style="border: 3px solid black;" />
                                </div>
                                <div class="col-md-12 px-0">
                                    <div class="pt-2 mb-5">
                                        <h4 class="mt-4 mb-3 font-weight-medium mb-0">{{ $item['refDataName'] }}</h4>
                                        <!-- <h6 class="subtitle mb-3">Property Specialist</h6> -->
                                        <span class="pt-3 text-center"
                                            style="line-height:35px;font-weight: 400;color: #7D1456!important;">Serving
                                            Hanuman Mandir and Atlanta Community: <span
                                                style="font-weight: 600;color: #7D1456;text-decoration: underline;">{{ isset($item['servingYear']) }}</span></span><br>

                                        <span
                                            style="color: #7D1456!important;line-height:35px;font-weight: 400;margin-top: 15px!important;">Priest
                                            Speaks:<span
                                                style="font-weight: 600;color: #7D1456;text-decoration: underline;">
                                                {{ isset($item['spokenLanguages']) }}</span></span><br>

                                        <span
                                            style="color: #7D1456!important;line-height:35px;font-weight: 400;margin-top: 15px!important;">Phone:<span
                                                style="font-weight: 600;color: #7D1456;text-decoration: underline;">
                                                {{ base64_decode($item['phone']) }}</span></span>



                                    </div>
                                </div>
                            </div>
                            <!-- Row -->
                        </div>
                        <?php } ?>


                    </div>
                </div>
            </div>


        </div>





    </section><!-- End About Committee Section -->
@endsection
<script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        window.scrollTo({
            top: 225,
            behavior: 'smooth'
        });
    });
</script>
