@include('admin.includes.head')
@include('admin.includes.sidebar')
@include('admin.includes.topbar')

<!-- Main content-->
{{-- @dd($userDetails); --}}

<div class="container">
    <div class="row">
        <div class="col-md-12 mx-auto d-block shadow-lg bg-body rounded">
            {{ session('success') }}

            <form action="{{ route('admin.save-profile') }}" method="post" id="UpdateProfileForm">
                @csrf
                <fieldset class="border-2">
                    <legend class="legend-outer  float-none w-auto"> Personal Details </legend>
                    <div class="row">
                        @php
                            // dd($userDetails);
                            // die();
                            $parts = explode(' ', $userDetails->refDataName);
                            $lastname = array_pop($parts);
                            $firstname = implode(' ', $parts);

                            if (empty($firstname)) {
                                $firstname = $lastname;
                                $lastname = '';
                            }
                            // print_r($userDetails);
                        @endphp
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">First Name<span
                                        class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                <!-- <div class="input-group"></div> -->

                                <div class="input-group">
                                    <i class="fa fa-user"></i>
                                    <input type="text" class="form-control" id="fname" name="fname"
                                        placeholder="First Name" value="{{ $firstname }}" required aria-label="fname"
                                        aria-describedby="basic-addon1">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Last Name<span
                                        class="text-danger fw-bold" style="font-size: 20px;">*</span><span
                                        class="text-danger fw-bold" style="font-size: 20px;"></span></legend>
                                <div class="input-group">
                                    <i class="fa fa-user"></i>
                                    <input type="text" class="form-control" id="lname" name="lname"
                                        value="{{ $lastname }}" placeholder="Last Name" aria-label="lname" required
                                        aria-describedby="basic-addon1">
                                </div>
                            </fieldset>

                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">

                                <legend class="legend-inner float-none w-auto">Date Of Birth <span
                                        class="text-danger fw-bold text-white" style="font-size: 20px;">*</span>
                                </legend>
                                <div class="input-group">
                                    <label class="fa fa-calendar" for="dob"></label>
                                    <input type="text" name="dob" id="dob" class="form-control datepicker"
                                        value="{{ $userDetails->dob ?? '' }}" placeholder="MM/DD/YYYY" aria-label="dob"
                                        aria-describedby="basic-addon1">


                                </div>
                            </fieldset>

                        </div>
                        {{-- @dd($gotra_data[0]['refDataName']) --}}
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Gothram<span class="text-danger fw-bold"
                                        style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <select id="gothram" name="gothram" style="color:black!important;"
                                        class="form-control rounded select3 form-select pt-0" required>
                                        <option value=" " selected disabled>Select Gothram</option>
                                        <option value="DON'T KNOW"
                                            {{ old('gothram') == "DON'T KNOW" ? 'selected' : '' }}
                                            style="font-weight: bold;">DON'T KNOW</option>

                                        @foreach ($gotra_data as $item)
                                            <option value="{{ $item['refDataName'] }}"
                                                {{ old('gothram') == $item['refDataName'] ? 'selected' : '' }}>
                                                {{ $item['refDataName'] }}
                                            </option>
                                        @endforeach
                                    </select>


                                </div>

                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Nakshatra<span
                                        class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <select id="stars" name="stars" style="color:black!important;"
                                        class="form-control rounded select3 form-select pt-0" required>
                                        <option value=" " selected disabled>Select Nakshtra</option>
                                        <option value="DON'T KNOW"
                                            {{ old('gothram') == "DON'T KNOW" ? 'selected' : '' }}
                                            style="font-weight: bold;">DON'T KNOW
                                        </option>
                                        @foreach ($nakshtra_data as $item)
                                            <option value="{{ $item['refDataName'] }}"
                                                {{ old('gothram') == $item['refDataName'] ? 'selected' : '' }}>
                                                {{ $item['refDataName'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Rashi<span class="text-danger fw-bold"
                                        style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <select id="rashi" name="rashi" style="color:black!important;"
                                        class="form-control rounded select3 form-select pt-0" required>
                                        <option value=" " selected disabled>Select Rashi</option>
                                        <option value="DON'T KNOW" {{ old('rashi') == "DON'T KNOW" ? 'selected' : '' }}
                                            style="font-weight: bold;">DON'T KNOW
                                        </option>
                                        @foreach ($rashi_data as $item)
                                            <option value="{{ $item['refDataName'] }}"
                                                {{ old('rashi') == $item['refDataName'] ? 'selected' : '' }}>
                                                {{ $item['refDataName'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                            </fieldset>
                        </div>
                        <div class="col-md-6">

                            <fieldset class="border" style="background-color: #e7e6e6;" readonly>
                                <legend class="legend-inner float-none w-auto">Email<span class="text-danger fw-bold"
                                        style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa-envelope"></i>

                                    <input type="text" class="form-control"
                                        value="{{ base64_decode($userDetails->email ?? '') }}" readonly disabled
                                        style="background-color: #e7e6e6;">

                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">

                            <fieldset class="border" style="background-color: #e7e6e6;" readonly>
                                <legend class="legend-inner float-none w-auto">Phone<span class="text-danger fw-bold"
                                        style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa-phone"></i>

                                    <input type="text" class="form-control"
                                        value="{{ formatPhoneNumber(base64_decode($userDetails->phone ?? '')) }}"
                                        readonly disabled style="background-color: #e7e6e6;">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-12">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Address Line 1</legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-map-marker"></i>

                                    <input type="text" class="form-control"
                                        value="{{ $userDetails->addressLine1 ?? '' }}" placeholder="Address Line 1">

                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Address Line 2<span
                                        class="text-danger fw-bold" style="font-size: 20px;">&nbsp;</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-map-marker"></i>
                                    <input type="text" class="form-control"
                                        value="{{ $userDetails->addressLine2 ?? '' }}" placeholder="Address Line 2">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">County<span class="text-danger fw-bold"
                                        style="font-size: 20px;">&nbsp;</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-map-marker"></i>
                                    <input type="text" class="form-control"
                                        value="{{ $userDetails->county ?? '' }} " placeholder="Country">
                                </div>
                            </fieldset>
                        </div>
                        <!-- State  -->
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">State<span class="text-danger fw-bold"
                                        style="font-size: 20px;">*</span></legend>
                                <div class="input-group">
                                    <select id="stateSelect" name="state" style="color:black!important;"
                                        class="form-control rounded select3 form-select pt-0" required>
                                        <option value=" " selected disabled>Select State</option>
                                        <option value="DON'T KNOW"
                                            {{ old('state') == "DON'T KNOW" ? 'selected' : '' }}
                                            style="font-weight: bold;">DON'T KNOW
                                        </option>
                                        @foreach ($GetState as $state)
                                            <option value="{{ $state->refDataName }}"
                                                {{ old('state') == $state->refDataName ? 'selected' : '' }}>
                                                {{ $state->refDataName }}
                                            </option>
                                        @endforeach
                                    </select>

                                </div>

                            </fieldset>
                        </div>
                        <!-- City  -->
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">City</legend>
                                <div class="input-group">
                                    <select class="form-control rounded select2 form-select pt-0" name="city"
                                        id="city">
                                        <option value="" selected disabled>Select City</option>
                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        {{-- Zip  code --}}
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Zip Code</legend>
                                <div class="input-group">
                                    <i class="fa fa-file"></i>
                                    <input type="number" class="form-control"
                                        onKeyPress="if(this.value.length==6) return false;" name="zipcode"
                                        id="zipcode" value="{{ $userDetails->zip ?? '' }}" placeholder="Zip Code"
                                        aria-label="zipcode" aria-describedby="basic-addon1">
                                </div>
                            </fieldset>
                        </div>
                        {{--  spouse Name --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Name</legend>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="spouseName" name="spouseName"
                                        placeholder="Spouse Name" value="{{ $userDetails->spouseName ?? '' }}"
                                        aria-label="spouseName">
                                </div>
                            </fieldset>

                        </div>
                        {{-- Spouse Birth  Day --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Date Of Birth</legend>
                                <div class="input-group">
                                    <input name="spousedateofbirth" id="spousedateofbirth" type="text"
                                        class="form-control datepicker" placeholder="MM/DD/YYYY"
                                        aria-label="spousedateofbirth" aria-describedby="basic-addon1"
                                        value="{{ $userDetails->spouseDob ?? '' }}">
                                </div>
                            </fieldset>
                        </div>
                        {{-- Spouse Nakshtra --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Nakshatra</legend>
                                <div class="input-group">

                                    <select id="spouseStars" name="spouseStars" style="color:black!important;"
                                        class="form-control rounded select2 form-select pt-0">
                                        <option value=" " selected disabled>Select Nakshtra</option>
                                        @foreach ($nakshtra_data as $key => $item)
                                            <option value="{{ $item['refDataName'] }}"
                                                {{ $item['refDataName'] == isset($userDetails->spouseNakshtra) ? ($userDetails->spouseNakshtra ? 'selected' : '') : '' }}>
                                                {{ $item['refDataName'] }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        {{--  Spouse Rashi --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Rashi</legend>
                                <div class="input-group">
                                    <select id="spouseRashi" name="spouseRashi" style="color:black!important;"
                                        class="form-control rounded select2 form-select pt-0">
                                        <option value=" " selected disabled>Select Rashi</option>
                                        @foreach ($rashi_data as $key => $item)
                                            <option value="{{ $item['refDataName'] }}"
                                                {{ $item['refDataName'] == (isset($userDetails->spouseRashi) && $userDetails->spouseRashi == $item['refDataName'] ? 'selected' : '') }}>
                                                {{ $item['refDataName'] }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        {{--  Spouse Email --}}

                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Email</legend>
                                <div class="input-group">
                                    <input type="email" class="form-control" id="spouseEmail" name="spouseEmail"
                                        placeholder="Spouse Email"
                                        value="{{ formatPhoneNumber(base64_decode(isset($userDetails->spousePhone) ? $userDetails->spousePhone : '')) }}"
                                        aria-label="spouseEmail">
                                </div>
                            </fieldset>
                        </div>
                        {{-- Spouse Phone --}}
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Spouse Phone</legend>
                                <div class="input-group">
                                    <input type="text" class="form-control phone" id="spousePhone"
                                        name="spousePhone" placeholder="Spouse Phone"
                                        value="{{ formatPhoneNumber(base64_decode(isset($userDetails->spousePhone) ? $userDetails->spousePhone : '')) }}"
                                        aria-label="spousePhone">
                                </div>
                            </fieldset>
                        </div>
                        {{-- Household Indicator --}}
                        <div class="col-md-4">

                            <legend class="legend-inner float-none w-auto fw-bold">Household Indicator &nbsp;<i
                                    class="fa fa-eye" style="font-size:18px" title="Household Indicator"></i>
                            </legend>


                            <div class="form-check form-check-inline" style="padding-bottom: 5px;">
                                <input class="form-check-input" type="checkbox" id="inlineCheckbox2"
                                    name="household_indicator[]"
                                    {{ isset($userDetails->householdInd) ? ($userDetails->householdInd == 'YES' ? 'checked' : '') : '' }}>
                                <label class="form-check-label m-auto pt-2" for="inlineCheckbox2">Yes</label>
                            </div>

                            <div class="form-check form-check-inline mx-5" style="padding-bottom: 5px;">
                                <input class="form-check-input" type="checkbox" id="inlineCheckbox1"
                                    name="household_indicator[]"
                                    {{ isset($userDetails->householdInd) ? ($userDetails->householdInd == 'YES' ? '' : 'checked') : '' }}>
                                <label class="form-check-label m-auto pt-2" for="inlineCheckbox1">No</label>
                            </div>

                        </div>
                        {{-- Company Name --}}
                        <div class="col-md-6 d-none">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Company Name</legend>
                                <div class="input-group">
                                    <i class="fa fa-building-o"></i>
                                    <input type="text" class="form-control" name="company_name" id="company_name"
                                        value="{{ $userDetails->companyName ?? '' }}" placeholder="Company Name"
                                        aria-label="company_name" aria-describedby="basic-addon1">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6 d-none">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Company Email</legend>
                                <div class="input-group">
                                    <i class="fa fa-envelope"></i>
                                    <input type="email" class="form-control" name="company_email"
                                        id="company_email"
                                        value="{{ base64_decode($userDetails->companyEmail ?? '') }}"
                                        placeholder="Company Email" aria-label="company_email"
                                        aria-describedby="basic-addon1">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6 d-none">
                            <fieldset class="border" style="background-color: #e7e6e6;" readonly>
                                <legend class="legend-inner float-none w-auto">Company Phone Number</legend>
                                <div class="input-group">
                                    <i class="fa fa-phone"></i>
                                    <input type="hidden" class="form-control"
                                        value="{{ formatPhoneNumber(base64_decode($userDetails->companyPhone ?? '')) }}"
                                        readonly disabled style="background-color: #e7e6e6;">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6 d-none">
                            <fieldset class="border" style="background-color: #e7e6e6;" readonly>
                                <legend class="legend-inner float-none w-auto">Company Website</legend>
                                <div class="input-group">
                                    <i class="fa fa-globe"></i>

                                    <input type="hidden" class="form-control"
                                        value="{{ $userDetails->website ?? '' }}" readonly disabled
                                        style="background-color: #e7e6e6;">



                                </div>
                            </fieldset>
                        </div>
                        {{-- Preferred Language --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Preferred Language</legend>
                                <div class="input-group">
                                    <select id="preferredLanguage" name="preferredLanguage"
                                        style="color:black!important;"
                                        class="form-control rounded select2 form-select pt-0">
                                        <option value=" " selected disabled>Select Preferred Language</option>
                                        @foreach ($preferredLanguage->data as $item)
                                            <option value="{{ optional($item)->refDataName }}"
                                                {{ optional($item)->refDataName == optional($userDetails)->languagePreferenceName ? 'selected' : '' }}>
                                                {{ optional($item)->refDataName }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        {{-- Preferred Priest --}}
                        {{-- @dd($priest_data->data) --}}
                        <div class="col-md-3">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Preferred Priest</legend>
                                <div class="input-group">

                                    <select id="priestName" name="priestName" style="color:black!important;"
                                        class="form-control rounded select2  form-select pt-0">
                                        @if ($priest_data != '')
                                            <option value=" " selected disabled>Select Preferred Priest</option>
                                            {{-- @foreach ($priest_data->data as $key => $item)
                                            <option value="{{ $item->refDataName ?? '' }}"
                                                email="{{ base64_decode($item->email ?? '') }}"
                                                phone="{{ base64_decode($item->phone ?? '') }}"
                                                priestID="{{ $item->_id ?? '' }}"
                                                {{ $item->refDataName == $userDetails->requestForPriestName ? 'selected' : '' }}>
                                                {{ $item->refDataName ?? '' }}
                                            </option>
                                        @endforeach --}}
                                        @else
                                            <option value=" " selected disabled>Priest Not Available.</option>
                                        @endif
                                    </select>

                                    <input type="hidden" name="priestPhone" id="priestPhone"
                                        value="<?= json_decode(@$userDetails->priestPhone) ?>">
                                    <input type="hidden" name="priestEmail" id="priestEmail"
                                        value="<?= json_decode(@$userDetails->priestEmail) ?>">
                                    <input type="hidden" name="priestId" id="priestId"
                                        value="<?= @$userDetails->requestedPriestId ?>">




                                </div>
                            </fieldset>
                        </div>
                        {{-- Do you want to receive temple newsletter and communications? --}}
                        <div class="col-md-6">

                            <legend class="legend-inner float-none w-auto fw-bold">Do you want to receive temple
                                newsletter
                                and communications?</legend>


                            <div class="form-check form-check-inline mx-4" style="padding-bottom: 5px;">
                                <input class="form-check-input" type="checkbox" id="inlineCheckbox2"
                                    name="emailNotification"
                                    {{ isset($userDetails->emailPref) ? ($userDetails->emailPref == true ? 'checked' : '') : '' }}>
                                <label class="form-check-label m-auto pt-2" for="inlineCheckbox2">On Email</label>
                            </div>

                            <div class="form-check form-check-inline mx-4" style="padding-bottom: 5px;">
                                <input class="form-check-input" type="checkbox" id="inlineCheckbox1"
                                    name="phoneNotification"
                                    {{ isset($userDetails->smsPref) ? ($userDetails->smsPref == true ? 'checked' : '') : '' }}>
                                <label class="form-check-label m-auto pt-2" for="inlineCheckbox1">On SMS</label>
                            </div>

                        </div>
                    </div>
                </fieldset>

                <fieldset class="border-2">
                    <legend class="legend-outer float-none w-auto">Family Members</legend>
                    <div class="row">
                        @if (empty($userDetails->memberDetail) || @$userDetails->memberDetail[0]->memberName == '')
                            <hr>
                            <div class="row customer_records px-0 familyMemberSection">
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Family Member 1</legend>
                                        <div class="input-group">
                                            <i class="fa fa-user"></i>
                                            <input name="family_member_name[]" id="familyMember"
                                                value="{{ isset($userDetails->memberDetail[0]->memberName) ? $userDetails->memberDetail[0]->memberName : '' }}"
                                                type="text" class="form-control" placeholder="Family Member"
                                                aria-label="familyMember" aria-describedby="basic-addon1">


                                            <input name="family_member_gotraName[]" id="family_member_gotraName"
                                                value="{{ isset($userDetails->memberDetail[0]->gotraName) ? $userDetails->memberDetail[0]->gotraName : '' }}"
                                                type="text" class="form-control"
                                                placeholder="family_member_gotraName" hidden>

                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Date Of Birth</legend>
                                        <div class="input-group">


                                            <input type="text" class="form-control"
                                                value="{{ $userDetails->memberDetail[0]->dob ?? '' }}">


                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Nakshatra</legend>
                                        <div class="input-group">


                                            <input type="text" class="form-control"
                                                value="{{ $userDetails->memberDetail[0]->nakshatra ?? '' }}">
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Relationship</legend>
                                        <div class="input-group">
                                            <select class="form-control select2 rounded form-select pt-0"
                                                name="relationship[]">
                                                <option value=" " selected>Select</option>
                                                <option value="FATHER"
                                                    {{ isset($userDetails->memberDetail[0]->relationship) ? ($userDetails->memberDetail[0]->relationship == 'FATHER' ? 'selected' : '') : '' }}>
                                                    FATHER</option>
                                                <option value="MOTHER"
                                                    {{ isset($userDetails->memberDetail[0]->relationship) ? ($userDetails->memberDetail[0]->relationship == 'MOTHER' ? 'selected' : '') : '' }}>
                                                    MOTHER</option>
                                                <option value="SPOUSE"
                                                    {{ isset($userDetails->memberDetail[0]->relationship) ? ($userDetails->memberDetail[0]->relationship == 'SPOUSE' ? 'selected' : '') : '' }}>
                                                    SPOUSE</option>
                                                <option value="SON"
                                                    {{ isset($userDetails->memberDetail[0]->relationship) ? ($userDetails->memberDetail[0]->relationship == 'SON' ? 'selected' : '') : '' }}>
                                                    SON</option>
                                                <option value="DAUGHTER"
                                                    {{ isset($userDetails->memberDetail[0]->relationship) ? ($userDetails->memberDetail[0]->relationship == 'DAUGHTER' ? 'selected' : '') : '' }}>
                                                    DAUGHTER</option>
                                            </select>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Anniversary</legend>
                                        <div class="input-group">

                                            <input type="text" class="form-control"
                                                value="{{ $userDetails->memberDetail[0]->anniversaryDate ?? '' }}">


                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Status</legend>
                                        <div class="input-group">
                                            <input type="text" class="form-control"
                                                value="{{ $userDetails->memberDetail[0]->status ?? '' }}">
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-4">
                                    <legend class="legend-inner float-none w-auto fw-bold">Household Indicator</legend>

                                    <div class="form-check form-check-inline" style="padding-bottom: 5px;">

                                        <input class="form-check-input" type="checkbox" id="inlineCheckboxYes1"
                                            name="member_household_indicator[]" onclick="selectOnlyThis(1, this)"
                                            value="YES">
                                        <label class="form-check-label m-auto pt-2"
                                            for="inlineCheckboxYes1">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline mx-5" style="padding-bottom: 5px;">

                                        <input class="form-check-input" type="checkbox" id="inlineCheckboxNo1"
                                            name="member_household_indicator[]" onclick="selectOnlyThis(1, this)"
                                            value="NO">

                                        <label class="form-check-label m-auto pt-2" for="inlineCheckboxNo1">No</label>

                                    </div>
                                </div>
                                <div class="col-md-4" id="member_email_section1"
                                    {{ isset($userDetails->memberDetail[0]->householdInd) ? ($userDetails->memberDetail[0]->householdInd == 'YES' ? 'style="display:block"' : 'style="display:none"') : '' }}>

                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Household Member Email</legend>
                                        <div class="input-group">
                                            <input type="email" class="form-control" id="member_email1"
                                                name="member_email[]" placeholder="Member Email" required>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-md-4" id="member_phone_section1"
                                    {{ isset($userDetails->memberDetail[0]->householdInd) ? ($userDetails->memberDetail[0]->householdInd == 'YES' ? 'style="display:block"' : 'style="display:none"') : '' }}>
                                    <fieldset class="border">
                                        <legend class="legend-inner float-none w-auto">Household Member Phone</legend>
                                        <div class="input-group">
                                            <input type="text" class="form-control phone" id="member_phone1"
                                                name="member_phone[]" placeholder="Member Phone">
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="text-end py-2">
                                    <p class="legend-inner float-none w-auto" style="font-weight: bold;">Would Your
                                        Like
                                        To Add Additional Family Members?</p>
                                    <a class="extra-fields-customer btn btn-success btn-sm"
                                        style="border-radius:5px!important" href="#">Add More</a>
                                </div>
                            </div>
                            @php $total_no_member = 0;@endphp
                        @else
                            @foreach ($userDetails->memberDetail as $key => $val)
                                <hr>
                                <div class="row customer_records px-0 familyMemberSection">
                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Family Member
                                                {{ $key + 1 }}
                                            </legend>
                                            <div class="input-group">
                                                <i class="fa fa-user"></i>
                                                <input name="family_member_name[]" id="familyMember"
                                                    value="{{ $val->memberName }}" id="family_member_name"
                                                    type="text" class="form-control" placeholder="Family Member"
                                                    aria-label="familyMember" aria-describedby="basic-addon1">

                                                <input name="family_member_gotraName[]" id="family_member_gotraName"
                                                    value="{{ $val->gotraName }}" type="text"
                                                    class="form-control" placeholder="family_member_gotraName" hidden>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Date Of Birth</legend>
                                            <div class="input-group">
                                                <input name="dateofbirth[]" id="dateofbirth{{ $key }}"
                                                    type="text" class="form-control datepicker"
                                                    placeholder="MM/DD/YYYY" aria-label="dateofbirth"
                                                    aria-describedby="basic-addon1" value="{{ $val->dob ?? '' }}">
                                            </div>
                                        </fieldset>

                                        {{-- <script type="text/javascript">
                                        $(document).ready(function() {
                                            $('#dateofbirth{{ $key }}').datepicker({
                                                dateFormat: "mm/dd/yy",
                                                changeMonth: true,
                                                changeYear: true,
                                                yearRange: "-70:+0",
                                                maxDate: new Date(),
                                                onSelect: function(dateText) {
                                                    console.log("Selected date:", dateText);
                                                    console.log(dateText);
                                                    $('#dateofbirth{{ $key }}').val(dateText);
                                                }
                                            });
                                        });
                                    </script> --}}
                                    </div>

                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Nakshatra</legend>
                                            <div class="input-group">

                                                <select name="family_member_stars[]" style="color:black!important;"
                                                    class="form-control select2 rounded form-select pt-0">
                                                    <option value=" " selected disabled>Select Nakshtra</option>
                                                    @foreach ($nakshtra_data as $key => $item)
                                                        <option value="{{ $item['refDataName'] }}"
                                                            {{ $item['refDataName'] == $val->nakshatra ? 'selected' : '' }}>
                                                            {{ $item['refDataName'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Relationship</legend>
                                            <div class="input-group">
                                                <select class="form-control select2 rounded form-select pt-0"
                                                    name="relationship[]">
                                                    <option value=" " selected>Select</option>
                                                    <option value="FATHER"
                                                        {{ $val->relationship == 'FATHER' ? 'selected' : '' }}>FATHER
                                                    </option>
                                                    <option value="MOTHER"
                                                        {{ $val->relationship == 'MOTHER' ? 'selected' : '' }}>MOTHER
                                                    </option>
                                                    <option value="SPOUSE"
                                                        {{ $val->relationship == 'SPOUSE' ? 'selected' : '' }}>SPOUSE
                                                    </option>
                                                    <option value="SON"
                                                        {{ $val->relationship == 'SON' ? 'selected' : '' }}>SON
                                                    </option>
                                                    <option value="DAUGHTER"
                                                        {{ $val->relationship == 'DAUGHTER' ? 'selected' : '' }}>
                                                        DAUGHTER
                                                    </option>
                                                </select>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Anniversary</legend>
                                            <div class="input-group">
                                                <input name="anniversary[]" id="anniversary{{ $key }}"
                                                    type="text" class="form-control datepicker"
                                                    placeholder="MM/DD/YYYY" aria-label="anniversary"
                                                    aria-describedby="basic-addon1"
                                                    value="{{ $val->anniversaryDate }}">
                                            </div>


                                            {{-- <script type="text/javascript">
                                            $(document).ready(function() {
                                                $('#anniversary{{ $key }}').datepicker({
                                                    dateFormat: "mm/dd/yy",
                                                    changeMonth: true,
                                                    changeYear: true,
                                                    yearRange: "-70:+0",
                                                    maxDate: new Date(),
                                                    onSelect: function(dateText) {
                                                        console.log("Selected date:", dateText);
                                                        console.log(dateText);
                                                        $('#anniversary{{ $key}}').val(dateText);
                                                    }
                                                });
                                            });
                                        </script> --}}
                                        </fieldset>
                                    </div>

                                    <div class="col-md-4">
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Status</legend>
                                            <div class="input-group">

                                                <select name="family_member_status[]" id="familyMemberStatus"
                                                    style="color:black!important;"
                                                    class="form-control rounded  form-select pt-0">
                                                    <option value=" " selected>Select Status</option>

                                                    =
                                                    <option value="ACTIVE"
                                                        {{ $val->status == 'ACTIVE' ? 'selected' : '' }}>ACTIVE
                                                    </option>
                                                    <option value="INACTIVE"
                                                        {{ $val->status == 'INACTIVE' ? 'selected' : '' }}>INACTIVE
                                                    </option>
                                                </select>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-md-4">


                                        <legend class="legend-inner float-none w-auto fw-bold">Household Indicator
                                        </legend>

                                        <div class="form-check form-check-inline" style="padding-bottom: 5px;">

                                            <input class="form-check-input" type="checkbox"
                                                id="inlineCheckboxYes{{ $key + 1 }}"
                                                name="member_household_indicator[]"
                                                onclick="selectOnlyThis({{ $key + 1 }}, this)" value="YES"
                                                {{ $val->householdInd == 'YES' ? 'checked' : '' }}>

                                            <label class="form-check-label m-auto pt-2"
                                                for="inlineCheckboxYes{{ $key + 1 }}">Yes</label>

                                        </div>



                                        <div class="form-check form-check-inline mx-5" style="padding-bottom: 5px;">

                                            <input class="form-check-input" type="checkbox"
                                                id="inlineCheckboxNo{{ $key + 1 }}"
                                                name="member_household_indicator[]"
                                                onclick="selectOnlyThis({{ $key + 1 }}, this)" value="NO"
                                                {{ $val->householdInd == 'YES' ? '' : 'checked' }}>

                                            <label class="form-check-label m-auto pt-2"
                                                for="inlineCheckboxNo{{ $key + 1 }}">No</label>

                                        </div>
                                    </div>
                                    <div class="col-md-4" id="member_email_section{{ $key + 1 }}"
                                        {{ $val->householdInd == 'YES' ? 'style="display:block"' : 'style="display:none"' }}>

                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Household Member Email
                                            </legend>
                                            <div class="input-group">
                                                <input type="email" class="form-control" id="member_email1"
                                                    name="member_email[]" placeholder="Member Email"
                                                    value="{{ base64_decode($val->member_email) }}" required>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-md-4" id="member_phone_section{{ $key + 1 }}"
                                        {{ $val->householdInd == 'YES' ? 'style="display:block"' : 'style="display:none"' }}>
                                        <fieldset class="border">
                                            <legend class="legend-inner float-none w-auto">Household Member Phone
                                            </legend>
                                            <div class="input-group">
                                                <input type="text" class="form-control phone"
                                                    id="member_phone<?= $key + 1 ?>" name="member_phone[]"
                                                    placeholder="Member Phone"
                                                    value="{{ formatPhoneNumber(base64_decode($val->member_phone)) }}">
                                            </div>
                                        </fieldset>
                                    </div>
                                    @if ($key == 0)
                                        <div class="text-end py-4">
                                            <p class="legend-inner float-none w-auto" style="font-weight: bold;">Would
                                                Your Like To Add Additional Family Members?</p>
                                            <a class="extra-fields-customer btn btn-success btn-sm"
                                                style="border-radius:5px!important" href="#">Add More</a>
                                        </div>
                                    @else
                                        <div class="text-end py-4"><a href="#"
                                                style="border-radius:5px!important"
                                                class="remove-field btn-remove-customer btn btn-danger btn-sm">Remove</a>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                            @php $total_no_member = $key; @endphp
                        @endif
                        <div class="customer_records_dynamic px-0"></div>
                    </div>
                    <input type="hidden" id="total_member_row" value="{{ $total_no_member + 1 }}">
                    <script type="text/javascript" id="newjs"></script>
                </fieldset>
        </div>
    </div>
</div>
<!-- End Main content-->

@include('admin.includes.footer')
<!-- Bootstrap core JS-->
<script src="{{ asset('admin_assets/js/bootstrap.bundle.min.js') }}"></script>
<!-- Core theme JS-->
<script src="{{ asset('admin_assets/js/theme.js') }}"></script>
<script src="{{ asset('assets/js/jquery-ui.min.js') }}"></script>

<link href="{{ asset('admin_assets/css/select2.min.css') }}" rel="stylesheet" />
<script src="{{ asset('admin_assets/js/select2.min.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $("#heading").text('Update Profile');
    });

    $(".select2").select2({
        tags: false
    });
    $(".select3").select2({
        tags: true
    });

    //  convert uper case
    $(document).ready(function() {

        $(document).on('input', '.select2-search__field', function() {
            var words = $(this).val().split(' ');
            for (var i = 0; i < words.length; i++) {
                words[i] = words[i].toUpperCase();
            }
            $(this).val(words.join(' '));
        });

        // Set a flag to prevent infinite loop
        var modificationFlag = false;

        $('.select2-selection__rendered').on('DOMNodeInserted', function(event) {
            // Check if the modification flag is set
            if (!modificationFlag) {
                // Set the flag to true to prevent further modifications
                modificationFlag = true;

                var $target = $(event.target);

                // Check if the target is a span
                if ($target.is('span')) {
                    var text = $target.text().toUpperCase();
                    $target.text(text);
                }

                // Set the flag back to false for future modifications
                modificationFlag = false;
            }
        });


    });

    $(document).ready(function() {
        $('document').on('change', '#stateSelect', function() {
            //alert("khsgfj");
            var stateCode = $(this).val();
            //     $.ajax({
            //         url: "{{ url('admin/getCityByState') }}",
            //         type: "POST",
            //         // dataType: "json",
            //         data: {
            //             'stateCode': stateCode
            //         },
            //         success: function(data) {
            //             $("#city").html(data);
            //         }
            //    });

        });
    });

    function submitForm() {
        event.preventDefault();
        console.log("Form submission prevented");
        Swal.fire({
            title: 'Do you want to save the changes?',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: 'Save',
            denyButtonText: `Don't save`,
        }).then((result) => {

            if (result.isConfirmed) {
                console.log("save prevented");
                $("#UpdateProfileForm").validate({
                    submitHandler: function(form) {
                        form.submit();
                        $("#UpdateProfileForm").submit();
                    }

                });


            } else if (result.isDenied) {
                Swal.fire('Changes are not saved', '', 'info')
            }
        });
    }
</script>
</body>

</html>
