@include('admin.includes.head')
@include('admin.includes.sidebar')
@include('admin.includes.topbar')



<!-- Main content-->
<div class="container px-2 mt-4">
    <div class="table-responsive">
        <table id="myDonations" class="table table-hovered bg-white">
            <thead style="background-color: #2978b5; color: white;">
                <tr>
                    <th class="text-center">Token&nbsp;#</th>
                    <th class="text-center">Donation&nbsp;Name</th>
                    <th class="text-end">Donation&nbsp;Amount</th>
                    <th class="text-center">Donation&nbsp;Category</th>
                    <th class="text-center">Donation</th>
                    <th class="text-center">Donated&nbsp;On&nbsp;Date</th>
                    {{-- <th class="text-center">Download&nbsp;Receipt</th> --}}
                </tr>
            </thead>
            <tbody>
                <?php
				foreach($donations_data as $val){  ?>
                <tr>
                    <td class="text-center">{{ $val['tokenNumber'] }}</td>
                    <td class="text-center">{{ camelCase($val['ServiceSetup']) }}</td>
                    <td class="text-end">{{ '$' . sprintf('%.2f', $val['serviceAmount']) }}</td>
                    <td class="text-center">{{ camelCase($val['serviceCategoryTypes']) }}</td>
                    <td class="text-center">{{ camelCase($val['serviceTypes']) }}</td>
                    <td class="text-center">
                        {{ $val['recCreDate'] ? $val['recCreDate'] : '' }}

                    </td>
                    <!-- <td class="text-center"><?= camelCase($val['paymentType']) ?></td> -->
                    {{-- <td style="text-align:center;"><a
                            href="{{ url('admin/download-reciept/' . base64_encode($val['tokenNumber']) . '/DONATIONS') }}"
                            id="btnExport" target="_blank"><i class="fa fa-eye text-blue" style="font-size:22px"></i>
                        </a></td> --}}

                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

</div>
<!-- End Main content-->


@include('admin.includes.footer')
<script>
    $(document).ready(function() {
        $("#heading").text('My Donations');


        $('#myDonations').DataTable({
            order: [
                [0, 'desc']
            ],
            "lengthChange": false,
            "scrollX": true,
            "ordering": false,
            "searching": true,
            language: {
                emptyTable: "No Donations Available to show..",
                search: ''
            }
        });
    });
</script>
</body>

</html>
