@include('admin.includes.head')
@include('admin.includes.sidebar')
@include('admin.includes.topbar')
<style>
    .table thead {
        vertical-align: bottom;
        background-color: #2978b5;
    }
</style>
<!-- Main content-->

<div class="container px-2 mt-4 ">
    {!! session('success') !!}

    <div class="table-responsive">
        <table id="myServiceRequest" class="table table-hovered">
            <thead>
                <tr>
                    <th>Service Date/Time</th>
                    <th>Service Name</th>
                    <th>Request Date</th>
                    <th>Service Amount</th>
                    <th>Status</th>
                    <!-- <th>Category</th> -->
                    <th>Preferred Priest</th>
                    <th>Location</th>
                    <!-- <th>Preferred Language</th> -->
                </tr>
            </thead>
            <?php  if (isset($myServiceRequests_data) && !empty($myServiceRequests_data)) { ?>
            <tbody>
                <?php

					foreach($myServiceRequests_data as $val) { ?>
                <tr>
                    <td><?= $val->serviceDate || $val->serviceTime ? $val->serviceDate . ' / ' . $val->serviceTime : '' ?>
                    </td>
                    <td><?= camelCase($val->ServiceSetup) ?></td>
                    <td><?= $val->recCreDate ? $val->recCreDate : '' ?></td>
                    <td><?= '$ ' . sprintf('%.2f', $val->serviceAmount) ?></td>
                    <td>
                        <?php if ($val->serviceStatus == 'SCHEDULED') {
                            $status = '<a href="javascript:void(0)" onclick="show_booking_status(`' . camelCase($val->ServiceSetup) . '` ,`' . $val->serviceStatus . '`, `' . date('jS M Y', strtotime($val->serviceDate)) . '`)"><img src="' . asset('admin_assets/img/icons/booking-confirmed-icon.png') . '" height="35" width="35" style="vertical-align: middle!important;"></a>';
                        } else {
                            $status = '<span class="badge">' . $val->serviceStatus . '</span>';
                        } ?>
                        <?= $status ?>
                    </td>
                    <!-- <td><?= camelCase($val->serviceCategoryTypes) ?></td> -->
                    <td><?= $val->priestName ?></td>
                    <td><?= camelCase($val->serviceAddress) ?></td>

                    <!-- <td><?= $val->languagePreferenceName ?></td> -->
                </tr>
                <?php } ?>
            </tbody>
            <?php } else if (isset($err_msg)) {
				echo $err_msg;
			} ?>
        </table>
    </div>
</div>
<!-- End Main content-->
@include('admin.includes.footer')

<script>
    $(document).ready(function() {
        $("#heading").text('My Service Requests');

        new DataTable('#myServiceRequest', {
            order: [
                [0, 'desc']
            ],
            "lengthChange": false,
            "scrollX": true,
            "ordering": false,
            "searching": true,
            language: {
                emptyTable: "No Service Request Available to show..",
                search: ''
            }
        });
    });


    function show_booking_status(service, status, shceduled_on) {

        var status = status;
        var service = service;
        var shceduled_on = shceduled_on;

        Swal.fire({
            title: 'Booking Status',
            text: 'Your service "' + service + '" has been "' + status + '" on ' + shceduled_on + '.',
            type: "success",
            confirmButtonText: 'OK',
            confirmButtonColor: '#008080',
        }).then((result) => {
            window.location.reload();
        });
    }
</script>
</body>

</html>
