@include('admin.includes.head')
@include('admin.includes.sidebar')
@include('admin.includes.topbar')
<style>
    .input-group> :not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback) {
        padding-bottom: 8px;
    }

    .customeWidth {
        width: 18%;
    }
</style>
<?php
$parts = explode(' ', @$userDetails->refDataName);
$lastname = array_pop($parts);
$firstname = implode(' ', $parts);
?>
<!-- ======= Service Request ======= -->
<div class="container">
    <div class="row px-4 pb-4 pt-0">
        <div class="col-md-12 mx-auto d-block card shadow-lg my-2">
            @if (session()->has('success'))
                {!! session('success') !!}
            @endif

            <form action="{{ route('admin.service-request') }}" method="post" id="serviceRequestForm">
                @csrf
                <fieldset class="border-2">
                    <legend class="legend-outer  float-none w-auto"> Request a Service </legend>


                    <fieldset class="border-2">
                        <div class="row justify-content-between m-0 p-0">
                            <div class="col-md-2 customeWidth m-0 p-0">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">First Name<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-user fa2"></i>
                                        <input type="text" class="form-control border-dark"
                                            style="color:black!important;" name="fname" id="fname"
                                            placeholder="First Name*"
                                            value="{{ old('fname', isset($firstname) ? $firstname : '') }}" required
                                            readonly>

                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-2 customeWidth m-0 p-0">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Last Name<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-user fa2"></i>
                                        @php
                                            $lastNameValue = old('lname', isset($lastname) ? $lastname : '');
                                            $readonlyAttribute = empty($lastNameValue) ? '' : 'readonly';
                                        @endphp

                                        <input type="text" class="form-control border-dark" name="lname"
                                            id="lname" placeholder="Last Name"
                                            value="{{ old('lname', isset($lastname) ? $lastname : '') }}"
                                            {{ $readonlyAttribute }} required>

                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-md-2 customeWidth m-0 p-0">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Gotra</legend>
                                    <div class="input-group">
                                        <i class="fa fa-user fa2"></i>
                                        <input type="text" class="form-control border-dark"
                                            style="color:black!important;" id="gotra" name="gotra"
                                            placeholder="Gotra"
                                            value="{{ old('gotra', isset($userDetails->gotraName) ? $userDetails->gotraName : '') }}">

                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-2 customeWidth m-0 p-0">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Nakshatra</legend>
                                    <div class="input-group">
                                        <i class="fa fa-user fa2"></i>
                                        <input type="text" class="form-control border-dark" name="stars"
                                            placeholder="Nakshatra"
                                            value="{{ old('stars', isset($userDetails->Nakshtra) ? $userDetails->Nakshtra : '') }}"
                                            style="color:black!important;">

                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-2 customeWidth m-0 p-0">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Rashi</legend>
                                    <div class="input-group">
                                        <i class="fa fa-user fa2"></i>
                                        <input type="text" class="form-control border-dark" name="rashi"
                                            placeholder="Rashi"
                                            value="{{ old('rashi', isset($userDetails->rashi) ? $userDetails->rashi : '') }}"
                                            style="color:black!important;">

                                    </div>
                                </fieldset>
                            </div>
                        </div>




                        <div class="row">
                            <div class="col-md-6">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Street Address<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <input type="text" class="form-control border-dark" name="streetAddress"
                                            id="streetAddress" placeholder="Street Address*"
                                            style="color:black!important;" required
                                            value="{{ old('streetAddress', isset($userDetails->county) ? $userDetails->county : '') }}">

                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-3">
                                @php
                                    $fieldset_bg =
                                        isset($userDetails->email) && !empty($userDetails->email)
                                            ? 'readonly style="background-color: #e7e6e6;"'
                                            : '';
                                @endphp

                                <fieldset class="border" {!! $fieldset_bg !!}>
                                    <legend class="legend-inner float-none w-auto required">Email<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-envelope fa2"></i>
                                        <input type="email" class="form-control border-dark" id="email"
                                            name="email" placeholder="Email ID*"
                                            value="{{ old('email', isset($userDetails->email) ? base64_decode($userDetails->email) : '') }}"
                                            {!! $fieldset_bg !!} required>
                                    </div>
                                </fieldset>

                            </div>
                            <div class="col-md-3">
                                @php
                                    $fieldset_bg2 =
                                        isset($userDetails->phone) && !empty($userDetails->phone)
                                            ? 'readonly style="background-color: #e7e6e6;color:black!important;"'
                                            : 'style="color:black!important;"';
                                @endphp

                                <fieldset class="border" {!! $fieldset_bg2 !!}>
                                    <legend class="legend-inner float-none w-auto required">Phone<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-phone fa2"></i>
                                        <input type="text" class="form-control border-dark" name="phoneNumber"
                                            placeholder="Phone Number*"
                                            value="{{ old('phoneNumber', isset($userDetails->phone) ? formatPhoneNumber(base64_decode($userDetails->phone)) : '') }}"
                                            {!! $fieldset_bg2 !!} required>
                                    </div>
                                </fieldset>

                            </div>
                        </div>
                    </fieldset>

                    <div class="col-md-4 d-none">
                        <fieldset class="border">
                            <legend class="legend-inner float-none w-auto required">State<span
                                    class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                            <div class="input-group">
                                <input type="text" name="state" id="state" class="form-control"
                                    placeholder="State"
                                    value="{{ old('state', isset($userDetails->stateTypes) ? $userDetails->stateTypes : '') }}">

                            </div>
                        </fieldset>
                    </div>
                    <div class="col-md-4 d-none">
                        <fieldset class="border">
                            <legend class="legend-inner float-none w-auto required">City<span
                                    class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                            <div class="input-group">
                                <input type="text" name="city" id="city" class="form-control"
                                    placeholder="City"
                                    value="{{ old('city', isset($userDetails->cityTypes) ? $userDetails->cityTypes : '') }}">

                            </div>
                        </fieldset>
                    </div>

                    <div class="col-md-4 d-none">
                        <fieldset class="border">
                            <legend class="legend-inner float-none w-auto required">Zip Code<span
                                    class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                            <div class="input-group">
                                <input type="text" class="form-control border-dark" style="color:black!important;"
                                    name="zipcode" id="zipcode" placeholder="Zip Code*"
                                    value="{{ old('zipcode', isset($userDetails->zip) ? $userDetails->zip : '') }}"
                                    required>

                            </div>
                        </fieldset>
                    </div>

                    <fieldset class="border-2">
                        <div class="row">
                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Preferred Location<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <select name="preferredLocation" id="preferredLocation"
                                            style="color:black!important;" class="form-control rounded form-select"
                                            required>
                                            <option value="" selected style="color:black!important;">Preferred
                                                Location</option>
                                            @php
                                                $preferredLocations = array_reverse($preferredLocations);
                                            @endphp
                                            @foreach ($preferredLocations as $item)
                                                @php
                                                    $catName = '';
                                                    switch ($item->refDataName) {
                                                        case 'IN-TEMPLE':
                                                            $catName = 'IN TEMPLE';
                                                            break;
                                                        case 'SHRAADHAM':
                                                            $catName = 'APARAKARYA';
                                                            break;
                                                        case 'AWAY-TEMPLE':
                                                            $catName = 'OUTSIDE TEMPLE';
                                                            break;
                                                        default:
                                                            $catName = $item->refDataName;
                                                            break;
                                                    }
                                                @endphp
                                                <option value="{{ $item->refDataName }}">{{ $catName }}</option>
                                            @endforeach
                                        </select>

                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Service<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <select name="serviceName" id="serviceName" style="color:black!important;"
                                            class="form-control rounded  form-select" required>
                                            <option value=" " selected disabled>Select Service</option>
                                        </select>
                                        <input type="hidden" id="serviceType" name="serviceType">
                                        <input type="hidden" id="serviceAmount" name="serviceAmount">
                                        <input type="hidden" name="serviceId" id="serviceId">
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Service Amount<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-location fa2"></i>
                                        <input type="text" class="form-control rounded" id="serviceAmountBox"
                                            placeholder="Service Amount*" value="" readonly required>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-12" style="display: none;" id="serviceDetailsBox">


                            </div>




                            <div class="col-md-4 d-none">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Preferred Language<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <select name="preferredLanguage" id="preferredLanguage"
                                            style="color:black!important;" class="form-control rounded  form-select">
                                            <option value=" " selected disabled>Select Preferred Language</option>
                                            <?php foreach ($preferredLanguage as $item) { ?>
                                            <option value="<?= @$item->refDataName ?>"
                                                <?= @$item->refDataName == @$userDetails->languagePreferenceName ? 'selected' : '' ?>>
                                                <?= @$item->refDataName ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-md-6">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Priests<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <select name="priestName" id="priestName" style="color:black!important;"
                                            class="form-control rounded form-select" required>
                                            @if ($PriestData != '')
                                                <option value="" selected disabled>Select Preferred Priest
                                                </option>
                                                @foreach ($PriestData as $item)
                                                    <option value="{{ @$item->refDataName }}"
                                                        email="{{ base64_decode(@$item->email) }}"
                                                        phone="{{ base64_decode(@$item->phone) }}"
                                                        priestID="{{ @$item->_id }}"
                                                        {{ @$userDetails->requestForPriestName ? 'selected' : '' }}>
                                                        {{ @$item->refDataName }}
                                                    </option>
                                                @endforeach
                                            @else
                                                <option value="" selected disabled>Priest Not Available.</option>
                                            @endif
                                            <option value="Any Priest" email="" phone="" priestId="0">
                                                Any Priest</option>
                                        </select>

                                        <input type="hidden" name="priestPhone" id="priestPhone"
                                            value="{{ json_decode(@$userDetails->priestPhone) }}">
                                        <input type="hidden" name="priestEmail" id="priestEmail"
                                            value="{{ json_decode(@$userDetails->priestEmail) }}">
                                        <input type="hidden" name="priestId" id="priestId"
                                            value="{{ @$userDetails->requestedPriestId }}">

                                    </div>

                                </fieldset>
                            </div>
                            <div class="col-md-6"
                                style="display: flex; align-items: center; flex-direction: row-reverse;">
                                <div class="form-check form-check-inline mx-4">
                                    <input class="form-check-input" type="checkbox" id="inlineCheckbox"
                                        name="confirmByPriest">
                                    <label class="form-check-label"
                                        style="padding-top: 10px !important;  padding-left: 20px;"
                                        for="inlineCheckbox">Already Confirmed By Priest</label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Service Date<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-calendar fa2"></i>
                                        <input placeholder="MM/DD/YYYY" class="form-control rounded "
                                            id="serviceDate" name="serviceDate" type="text" readonly required>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Service Time</legend>
                                    <div class="input-group">
                                        <i class="fa fa-clock-o fa2"></i>

                                        <input type='text' class='form-control' name="serviceTime"
                                            id="serviceTime" placeholder='00:00'>

                                    </div>
                                </fieldset>

                            </div>

                            <div class="col-md-4">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto required">Select Venue<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <select name="selectVenue" id="selectVenue" style="color:black!important;"
                                            class="form-control rounded  form-select" required>
                                            <option value=" " selected disabled>Select Venue</option>
                                            <option value="Same as Home Address">Same as Home Address</option>
                                            <option value="Same as Temple Address">Same as Temple Address</option>
                                            <option value="Other">Other</option>
                                        </select>

                                    </div>
                                </fieldset>

                            </div>

                            <div class="col-md-12">
                                <fieldset class="border" id="serviceAddressBox">
                                    <legend class="legend-inner float-none w-auto required">Full Address<span
                                            class="text-danger fw-bold" style="font-size: 20px;">*</span></legend>
                                    <div class="input-group">
                                        <i class="fa fa-location fa2"></i>
                                        <input type="text" class="form-control rounded " name="serviceAddress"
                                            id="serviceAddress" placeholder="Please enter your address*"
                                            value="" required>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-md-12">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto">Additional Info</legend>
                                    <div class="input-group">
                                        <textarea type="textarea" name="addtionalInfo" class="form-control border-dark rounded form-text-area"
                                            placeholder="Please provide any additional details here."></textarea>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </fieldset>
            </form>

        </div>

    </div>
</div>
</div>
<?php $TempleAddress = getclientInfoById()['data'][0];

$TempleAddress = $TempleAddress['addressLineOne'] . ' ' . $TempleAddress['addressLinetwo'] . ' ' . $TempleAddress['state'] . ' ' . $TempleAddress['city'] . ' ' . $TempleAddress['zipCode'];
?>
<!-- End Service Request -->

@include('admin.includes.footer')

<script type="text/javascript" src="{{ asset('assets/js/time-picker.js') }}"></script>
<script src="{{ asset('assets/js/jquery-ui.min.js') }}"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script type="text/javascript">
    $('#serviceRequestForm').keypress(function(e) {
        if (e.which == 13) {
            $('#serviceRequestBtn').click();
            return false;
        }
    });

    $(function() {

        $("#serviceAddressBox").hide();
        $otherField = $("#serviceAddressBox");
        $otherFieldval = $("#serviceAddress");
        $('#preferredLocation').on('change', function() {
            // alert();
            // if(this.value === 'AWAY-TEMPLE') {
            // 	$otherFieldval.val("");
            // 	$otherField.show();
            // } else {
            // 	$otherField.hide();
            // 	$otherFieldval.val('<?= $TempleAddress ?>');
            // }

            if (this.value === 'AWAY-TEMPLE') {
                //alert("away-temple");
                $otherFieldval.val("");
                $otherField.show();
            } else if (this.value === 'IN-TEMPLE') {
                // alert(Intemple);
                var templeAddress = "{{ $TempleAddress }}";

                $otherField.hide();
                $otherFieldval.val(templeAddress);

            } else {
                // alert('else');
                $otherFieldval.val("");
                $otherField.show();
            }

        });
        $('#serviceTime').mdtimepicker();
        $("#heading").text('Request a Service');
    });

    function checkValue(str, max) {
        if (str.charAt(0) !== '0' || str == '00') {
            var num = parseInt(str);
            if (isNaN(num) || num <= 0 || num > max) num = 1;
            str = num > parseInt(max.toString().charAt(0)) && num.toString().length == 1 ? '0' + num : num.toString();
        };
        return str;
    };

    $('#priestName').change(function() {

        var priestEmail = $(this).children(":selected").attr("email");
        var priestPhone = $(this).children(":selected").attr("phone");
        var priestId = $(this).children(":selected").attr("priestID");

        $("#priestEmail").val(priestEmail);
        $("#priestPhone").val(priestPhone);
        $("#priestId").val(priestId);

    });

    $('#preferredLocation').change(function() {

        var param = $(this).val();
        //alert(param);
        if (param == 'AWAY TEMPLE') {
            param = 'AWAY-TEMPLE';
        }

        if (param == 'IN-TEMPLE') {
            $("#selectVenue").val('Same as Temple Address');
            $('#selectVenue').prop('disabled', true);
        } else {
            $("#selectVenue").val(' ');
            $('#selectVenue').prop('disabled', false);
        }

        $.ajax({
            url: "{{ route('admin.GetServicesByCategory') }}",
            type: "POST",
            data: {
                'param': param
            },
            success: function(data) {
                if (data == '') {
                    $('#serviceName').html(
                        '<option value=" " disabled selected>No Service Available On This Location.</option>'
                    );
                } else {
                    $('#serviceName').html(data);
                }
                $('#serviceName').select2();
            }
        });

    });

    $('#serviceName').change(function() {

        var serviceType = $('option:selected', this).attr('serviceType');
        $("#serviceType").val(serviceType);

        var startDate = $('option:selected', this).attr('startDate');
        if (startDate != '') {

            $("#serviceDate").val(startDate);
            $("#serviceDate").attr('disabled', 'true');

        }


        var startTime = $('option:selected', this).attr('startTime');
        if (startTime != '') {
            $("#serviceTime").val(startTime);
            $("#serviceTime").attr('disabled', 'true');
        }

        var serviceId = $('option:selected', this).attr('serviceId');
        if (serviceId != '') {
            $("#serviceId").val(serviceId);
        }


        if (serviceId == 0) {

            $("#serviceDetailsBox").css('display', 'block');
            $("#serviceDetailsBox").html(
                '<fieldset class="border"><legend  class="legend-inner float-none w-auto required">Service Details<span class="text-danger fw-bold" style="font-size: 20px;">*</span></legend><div class="input-group"><input type="text"  class="form-control" name="serviceDetails" id="serviceDetails" placeholder="Specify Service Details" required></div></fieldset>'
            );

            var serviceAmount = $('option:selected', this).attr('serviceAmount');
            $("#serviceAmountBox").val('TBD By Priest');

        } else {
            $("#serviceDetailsBox").css('display', 'none');
            $("#serviceDetailsBox").html('');
            var serviceAmount = $('option:selected', this).attr('serviceAmount');
            $("#serviceAmountBox").val('$ ' + serviceAmount + '.00');
        }


    });

    $('#serviceName').change(function() {

        var serviceAmount = $('option:selected', this).attr('serviceAmount');


        var finalPrice = (serviceAmount / 1).toFixed(2);
        // alert(serviceAmount);

        $("#serviceAmount").val(finalPrice);

    });


    $(document).ready(function() {
        $("#serviceRequestForm").validate({

            submitHandler: function(form) {
                form.submit();
            }

        });
    });

    $("#serviceDate").datepicker({
        dateFormat: "mm/dd/yy",
        minDate: 0
    });




    function submitForm() {

        Swal.fire({
            title: 'Do you want to save the changes?',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: 'Save',
            denyButtonText: `Don't save`,
        }).then((result) => {

            if (result.isConfirmed) {

                $("#serviceRequestForm").submit();
            } else if (result.isDenied) {
                Swal.fire('Changes are not saved', '', 'info')
            }
        });
    }



    function closeForm() {

        Swal.fire({
            title: 'Do you want to cancel the changes?',
            showDenyButton: true,
            showCancelButton: true,
            showConfirmButton: false,
            cancelButtonText: 'No',
            denyButtonText: `Yes`,
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {
                Swal.fire('Saved!', '', 'success')
            } else if (result.isDenied) {

                window.location.href = "{{ route('admin.my-service-request') }}";
            }
        })
    }

    $(document).ready(function() {
        $('#inlineCheckbox').change(function() {
            var isChecked = $(this).prop('checked');
            var select = $('#priestName');
            var anyPriestOption = select.find('option[value="Any Priest"]');

            if (isChecked) {
                anyPriestOption.remove();
                $("#serviceTime").attr('required', true);
                $("#serviceDate").attr('required', true);
            } else {
                select.append('<option value="Any Priest" email="" phone="">Any Priest</option>');
                $("#serviceTime").attr('required', false);
                $("#serviceDate").attr('required', false);
            }
        });

        $('#selectVenue').change(function() {
            var selectedOption = $(this).val();
            var addressInput = $('#serviceAddress');

            if (selectedOption === 'Same as Home Address') {
                var homeAddress =
                    "<?= @$userDetails->addressLine1 . ' ' . @$userDetails->addressLine2 ?>"; // Replace 'Your Home Address' with the actual home address value
                addressInput.val(homeAddress);
                addressInput.prop('readonly', true);
            } else if (selectedOption === 'Same as Temple Address') {
                var templeAddress =
                    "<?= $TempleAddress ?>"; // Replace 'Temple Address' with the actual temple address value
                addressInput.val(templeAddress);
                addressInput.prop('readonly', true);
            } else if (selectedOption === 'Other') {
                addressInput.val('');
                addressInput.prop('readonly', false);
            }
        });
    });
</script>



</body>

</html>
