@extends('includes.master')
@section('title', 'Gharbhalaya Land Donations')


@section('style-section')
    <style>
        .matrix-container {
            flex-wrap: wrap;
            width: 112px;
            display: inline-flex;
            justify-content: center;
            align-items: center;
            text-align: center;

        }

        .matrix-row {
            flex: 0 0 25%;
            padding: 10px;
            box-sizing: border-box;
            width: 0 !important;
        }

        .matrix-cell {
            border: 1px solid #ccc;
            padding: 10px;
            margin-bottom: -10px;
            background-color: #C6B4A3;
            width: 0px;
        }

        .lbyDiv1 {
            margin: 0;
            width: 98%;
            border: 0px solid;
            float: left;
            padding: 0px;
            display: inline;
            background: #fff !important;
        }

        .lby1 {
            border: 1px solid #dd9303;
            margin-bottom: 50px;
            margin-top: 50px;
            width: 80%;
            text-align: justify;
            border-radius: 16px;
            box-shadow: 2px 2px 10px #444444;
            margin-left: 170px;
        }

        .btn_css {
            font-size: 16px;
            font-weight: bold;
            padding: 0px 20px 0 20px;
            font-family: Trebuchet MS;
            border: 1px solid #660606;
            border-radius: 4px;
            height: 30px;
            margin-right: 112px;
            margin-top: 26px;
        }

        .input_css {
            margin: 5px !important;
            padding: 2px !important;
            height: 20px !important;
            /* width: auto !important; */
            /* display: inline !important; */
            font-size: 12px !important;
            border-radius: 4px;
            background: #F9F9F9;
            border: 1px solid #AAA;
        }
    </style>
@endsection

@section('content')
    <div style="border: 0px solid #DD9303; border-radius: 16px;">
        <div
            style="padding:50px;background-image:url({{ asset('assets/img/gharbhalaya/bg2.gif') }});  background-repeat: no-repeat;background-size:cover;">
            <div class="cliHeader" style="padding-top:10px; font-size: 22px;">
                <spna>Garbhalaya Land Donation</spna>
                <br />
                <hr style="color:#e6a421" />
            </div>
            <div style="text-align: justify;font-size:17px;">

                Elders say that due to our Purva Janma Punyam or Purva Janma Sukrutham we have been bestowed with an
                opportunity to participate in good deeds or good service in this birth. It is believed that among many
                forms
                of Daanam and Dharmam, Bhomi Daanam is considered as one of the dearest acts that pleases the Lord and
                your
                progeny will be blessed for many many generations. This can be dedicated to any family member/kids or to
                Lord Srinivasa on the auspicious occasion of the <b>Carolina Murgan Temple</b> guided by TTD.

            </div>
            <div style="margin-top:8px;text-align: justify;font-size:17px;">PuraaNas speak highly of this deed and that the
                Lord would protect such donors and
                their family for generations! Here is a great opportunity to get involved in the noble deed. Bhoomi Daanam
                is a great way by which everyone can play a part of the future Temple's development. Your SVLT has opened up
                Bhoomi Daanam, a seva just for you in a highly affordable way. It will be offered on a first come, first
                served basis, so please hurry.
            </div>
            <div style="margin-top:8px;text-align: justify;font-size:17px;">Building a temple is once in a life time
                opportunity and this mighty endeavor needs
                your financial support. Your generosity will help bring this noble cause to completion. With your continued
                support, we will not only have a place of worship, but also a venue to promote our culture and heritage for
                generations to come.
            </div>
            <div class="row mt-5">
                <div class="col-md-4">
                </div>
                <div class="col-md-4">
                    <div id="matrix-container"></div>
                    <div class="grid-container ">
                        @php
                            // Sample data for the matrix (replace with your data source)
                            $matrixData = [
                                [
                                    '_id' => '01',
                                    'refdatanam' => 'Plot A',
                                    'landprice' => 100000,
                                    'isBooked' => true,
                                    'date' => '2024-07-08',
                                    'time' => '10:00 AM',
                                    'bookedby' => 'John Doe',
                                ],
                                [
                                    '_id' => '02',
                                    'refdatanam' => 'Plot B',
                                    'landprice' => 150000,
                                    'isBooked' => false,
                                    'date' => '2024-07-09',
                                    'time' => '11:00 AM',
                                    'bookedby' => 'Jane Smith',
                                ],
                                [
                                    '_id' => '03',
                                    'refdatanam' => 'Plot C',
                                    'landprice' => 120000,
                                    'isBooked' => true,
                                    'date' => '2024-07-10',
                                    'time' => '09:00 AM',
                                    'bookedby' => 'Michael Brown',
                                ],
                                [
                                    '_id' => '04',
                                    'refdatanam' => 'Plot D',
                                    'landprice' => 180000,
                                    'isBooked' => false,
                                    'date' => '2024-07-11',
                                    'time' => '02:00 PM',
                                    'bookedby' => 'Emily Davis',
                                ],
                                [
                                    '_id' => '05',
                                    'refdatanam' => 'Plot E',
                                    'landprice' => 200000,
                                    'isBooked' => true,
                                    'date' => '2024-07-12',
                                    'time' => '03:00 PM',
                                    'bookedby' => 'David Johnson',
                                ],
                                [
                                    '_id' => '06',
                                    'refdatanam' => 'Plot F',
                                    'landprice' => 130000,
                                    'isBooked' => false,
                                    'date' => '2024-07-13',
                                    'time' => '01:00 PM',
                                    'bookedby' => 'Sarah Wilson',
                                ],
                                [
                                    '_id' => '07',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '08',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                                [
                                    '_id' => '09',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '10',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                                [
                                    '_id' => '11',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '12',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                                [
                                    '_id' => '13',
                                    'refdatanam' => 'Plot A',
                                    'landprice' => 100000,
                                    'isBooked' => true,
                                    'date' => '2024-07-08',
                                    'time' => '10:00 AM',
                                    'bookedby' => 'John Doe',
                                ],
                                [
                                    '_id' => '14',
                                    'refdatanam' => 'Plot B',
                                    'landprice' => 150000,
                                    'isBooked' => false,
                                    'date' => '2024-07-09',
                                    'time' => '11:00 AM',
                                    'bookedby' => 'Jane Smith',
                                ],
                                [
                                    '_id' => '15',
                                    'refdatanam' => 'Plot C',
                                    'landprice' => 120000,
                                    'isBooked' => true,
                                    'date' => '2024-07-10',
                                    'time' => '09:00 AM',
                                    'bookedby' => 'Michael Brown',
                                ],
                                [
                                    '_id' => '16',
                                    'refdatanam' => 'Plot D',
                                    'landprice' => 180000,
                                    'isBooked' => false,
                                    'date' => '2024-07-11',
                                    'time' => '02:00 PM',
                                    'bookedby' => 'Emily Davis',
                                ],
                                [
                                    '_id' => '17',
                                    'refdatanam' => 'Plot E',
                                    'landprice' => 200000,
                                    'isBooked' => true,
                                    'date' => '2024-07-12',
                                    'time' => '03:00 PM',
                                    'bookedby' => 'David Johnson',
                                ],
                                [
                                    '_id' => '18',
                                    'refdatanam' => 'Plot F',
                                    'landprice' => 130000,
                                    'isBooked' => false,
                                    'date' => '2024-07-13',
                                    'time' => '01:00 PM',
                                    'bookedby' => 'Sarah Wilson',
                                ],
                                [
                                    '_id' => '19',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '20',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                                [
                                    '_id' => '21',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '22',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                                [
                                    '_id' => '23',
                                    'refdatanam' => 'Plot G',
                                    'landprice' => 110000,
                                    'isBooked' => true,
                                    'date' => '2024-07-14',
                                    'time' => '10:30 AM',
                                    'bookedby' => 'Robert Lee',
                                ],
                                [
                                    '_id' => '24',
                                    'refdatanam' => 'Plot H',
                                    'landprice' => 160000,
                                    'isBooked' => false,
                                    'date' => '2024-07-15',
                                    'time' => '11:30 AM',
                                    'bookedby' => 'Emma Martinez',
                                ],
                            ];
                        @endphp
                        <div style="text-align: center;vertical-align: middle;margin-top: 15%;">
                            <div class="matrix-container">

                                @foreach ($matrixData as $data)
                                    @php

                                        $landCart = Session::get('ghabhalaya_service_cart');
                                        $status = 0;
                                        if ($landCart) {
                                            foreach ($landCart as $key => $servicedata) {
                                                if ($servicedata['_id'] == $data['_id']) {
                                                    $status = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        $is_disabled = '';
                                        $disabled_color = '';
                                        if ($data['isBooked'] == 1) {
                                            $is_disabled = 'disabled';
                                            $disabled_color = 'background-color:gray;';
                                        } else {
                                            $disabled_color = 'background-color:#C6B4A3;';
                                            if ($status == 1) {
                                                $disabled_color = 'background-color:green;';
                                            }
                                        }
                                    @endphp

                                    <div class="matrix-row" {{ $is_disabled }} style="cursor: pointer">
                                        <div class="matrix-cell" id="matrix" title="{{ $data['refdatanam'] }}"
                                            data-price="{{ $data['landprice'] }}" data-id="{{ $data['_id'] }}"
                                            data-date="{{ $data['date'] }}" data-time="{{ $data['time'] }}"
                                            data-name="{{ $data['refdatanam'] }}" data-bookedby="{{ $data['bookedby'] }}"
                                            data-isbooked="{{ $data['isBooked'] }}"
                                            {{ $data['isBooked'] == 1 ? '' : 'onclick=addTocart(this)' }}
                                            style="{{ $disabled_color }}" {{ $is_disabled }}>
                                            {{-- Output data for each cell --}}
                                            {{-- <strong>Reference:</strong> {{ $data['refdatanam'] }}<br>
                                        <strong>Price:</strong> ${{ number_format($data['landprice'], 2) }}<br>
                                        <strong>Status:</strong> {{ $data['isBooked'] ? 'Booked' : 'Available' }}<br> --}}
                                            {{-- If booked, show additional details --}}
                                            @if ($data['isBooked'])
                                                {{-- <strong>Booked By:</strong> {{ $data['bookedby'] }}<br>
                                            <strong>Date:</strong> {{ $data['date'] }}<br>
                                            <strong>Time:</strong> {{ $data['time'] }}<br> --}}
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                </div>
            </div>
        </div>
        <div class="">
            <div class="hs-toast-wrapper" id="#login-success-flashmsg'">
            </div>
            <div class="hs-toast-wrapper mb-3" id="login-error-flashmsg">
            </div>
            <span id="login-success-flashmsg" class="text-center" style="color: green;"></span>
            <span id="login-error-flashmsg" class="text-center" style="color: red;"></span>
            <div class="card lby1">
                <div style="font-size: 20px; color: #003863;margin-left: 20px;">Selection</div>
                <div>
                    <div
                        style="font-size: 16px; color:green; margin-top: 10px; margin-left: 40px; width:25%; display:inline-block;">
                        Number of Yards: <span id="landCount">0</span>
                    </div>
                    <div
                        style="font-size: 16px; color:green; margin-top: 10px; margin-left: 0px;  width:35%; display: inline-block;">
                        Amount: $<span id="amtLabel">0</span>
                    </div>
                    <div id="errorDiv" style="padding-left: 40px;color:red; width: 25% !important; display: inline; ">
                    </div>
                </div>


                <div style="margin:0px 0px 44px 0; float:right; display:inline;">

                    <div style="float:right; display: inline;"><input type="button" value="Proceed To Checkout"
                            onclick="CartCheckLogin('garbhalaya_land')" class="btn_css"
                            style="background-image: url({{ 'assets/img/btn_bg.jpg' }});color: #911A0D;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection


@section('script_area')
    <script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>

    <script>
        function addTocart(id) {
            var totalAmt = parseInt($(id).attr('data-price'));
            var serviceAmount = parseInt($(id).attr('data-price'));
            var isBooked = $(id).attr('data-isbooked');
            var landName = $(id).attr('data-name');
            var serviceDate = $(id).attr('data-date');
            var serviceTime = $(id).attr('data-time');
            var bookedBy = $(id).attr('data-bookedby');
            var _id = $(id).attr('data-id');
            var Url = "{{ url('addserviceCart') }}";

            $.ajax({
                url: Url,
                method: 'POST', // Assuming you want to send data using POST method
                data: {
                    _id: _id,
                    totalAmt: totalAmt,
                    serviceAmount: serviceAmount,
                    isBooked: isBooked,
                    landName: landName,
                    serviceDate: serviceDate,
                    serviceTime: serviceTime,
                    bookedBy: bookedBy
                },
                success: function(response) {
                    console.log(response.statusCode);
                    $('#amtLabel').text(response.totalSum);
                    $('#landCount').text(response.count);
                    // alert(response.message);
                    if (response.status == 1) {
                        if (response.statusCode == 1) {

                            $(id).css('background-color', 'green');
                            Swal.fire({
                                icon: 'success',
                                title: 'Item Added to Cart',
                                text: response.message,
                                confirmButtonText: 'OK',
                                timer: 3000 // Auto-close after 3 seconds
                            });
                        } else if (response.statusCode == 0) {
                            $(id).css('background-color', '#C6B4A3');
                            Swal.fire({
                                icon: 'success',
                                title: 'Item Remove to Cart',
                                text: response.message,
                                confirmButtonText: 'OK',
                                timer: 3000 // Auto-close after 3 seconds
                            });

                        }


                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', error);
                    // Handle error scenario here
                }
            });







        }

        function CartCheckLogin(page) {
            // alert(page);
            // $('#landCount').text()
            if ($("#landCount").text() > 0) {
                // loader.on();
                var page_name = page;
                event.preventDefault();
                $.ajax({
                    url: "{{ url('check-login-status') }}",
                    type: "POST",
                    dataType: "json",
                    success: function(data) {

                        loader.off();
                        console.log(data);
                        if (data == 0) {
                            openLoginModal(page_name);
                        } else {
                            if (page_name == 'garbhalaya_land') {
                                window.location.href = "{{ url('garbhalayalandcheckout') }}";
                            }

                        }

                    }
                });
            } else {
                swal({
                    title: "Your cart is empty!",
                    text: "Please add some items to your cart.",
                    icon: "warning",
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#005D4B',
                });
            }
        }
    </script>
@endsection
