@extends('includes.master')
@section('title', 'Gharbhalaya Land Checkout')


@section('style-section')
    <link href="{{ asset('assets/css/services_checkout.css') }}" />
@endsection

@section('content')
    <section style="background-image: linear-gradient(var(--page-wrapper-bg-color), white);">
        <center>
            <h2 class="bottomborder mt-4" style="font-weight:bold!important;font-size: 35px!important;">CHECKOUT</h2>
        </center><br>
        @php
            $session_data = Session::get('ghabhalaya_service_cart');
            // dd($session_data);
        @endphp
        {{-- @dd($session_data) --}}
        <div class="h-100 responsive-container">
            <div class="row d-flex justify-content-center align-items-center h-100">
                <div class="col-12">
                    <div class="card card-registration card-registration-2 mb-4" style="border-radius: 15px;">
                        <div class="card-body p-3">
                            <div class="card-header text-end px-3"
                                style="font-size: 18px!important;background-color:#315c61;">
                                <a href="javascript:void(0)" class="btn" onclick="window.history.back()"
                                    style=";background-color:#df4a19;color: white!important;border-radius: 1px!important;">←
                                    Back</a>
                                <a href="{{ isset($session_data) ? url('gharbhalaya_land_donations') : '#' }}"
                                    class="btn"
                                    style="background-color:#009688; color: white !important; border-radius: 1px !important;">Close
                                    X</a>

                            </div>
                            @php
                                $currencySymbol = getCurrencySymbol();
                            @endphp
                            @if (isset($session_data))
                                {{-- <h1> Enter svj</h1> --}}
                                <div class="row g-0">
                                    <div class="col-lg-7" style="background-color:#f5f5f5">
                                        <div class="p-2">
                                            @php
                                                $cart_items = $session_data;
                                            @endphp

                                            <div class="d-flex justify-content-between align-items-center mb-5">
                                                <h3 class="fw-bold mb-0 text-black">Sale Summary</h3>
                                                <h6 class="mb-0 text-muted">{{ 2 }} items</h6>
                                            </div>
                                            <hr class="my-4">
                                            <!-- =================Table Responsive============================ -->
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-start" style="width:50%">Service Name</th>
                                                            <!-- <th style="width:25%" class="text-start">Category</th> -->
                                                            <th class="text-center">Date</th>
                                                            <th style="width:5%" class="text-center">Qty</th>
                                                            <th style="width:15%" class="text-end">Amount</th>
                                                            <th style="width:15%" class="text-center">Pay Now</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                        @php $payNowTotalAmount = 0; @endphp

                                                        @foreach ($cart_items as $key => $value)
                                                            <tr>
                                                                @if ($cart_items[$key]['serviceAmount'] > 0)
                                                                    @php
                                                                        $payNowTotalAmount +=
                                                                            $cart_items[$key]['serviceAmount'];
                                                                    @endphp
                                                                @endif
                                                                <td>{{ $value['landName'] }}</td>
                                                                <td>{{ $value['serviceDate'] }}</td>
                                                                <td>1</td>
                                                                <td class="text-end">{{ $currencySymbol }}
                                                                    {{ price_format($value['serviceAmount'], 2) }}
                                                                </td>
                                                                <td class="text-center">yes</td>
                                                            </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>
                                            <!-- ============================================= -->

                                            <hr class="my-4">
                                            <div class="row mt-3">
                                                {{-- @dd($cart_items) --}}
                                                @php
                                                    $totalServiceAmount = 0;
                                                @endphp

                                                @foreach ($cart_items as $amtdata)
                                                    @php
                                                        // Assuming `service_amount` is the field you need to sum
                                                        $totalServiceAmount += $amtdata['serviceAmount'];
                                                    @endphp
                                                @endforeach
                                                <div class="col-md-6">
                                                    <h5 class="mb-0" style="font-weight:bold!important;">Subtotal</h5>
                                                </div>
                                                <div class="col-md-6 text-end"><span style="font-weight:bold!important;"
                                                        id="subtle">{{ $currencySymbol }}&nbsp;{{ price_format($totalServiceAmount, 2) }}</span>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <div class="p-5">
                                            <div class="row">
                                                <div class="col-md-7 fw-bold text-start">
                                                    <h5 class="mb-2" style="color:#009688!important">
                                                        {{ @session('refDataName') }}</h5>
                                                    <span>{{ @base64_decode(session('email')) }}</span>
                                                </div>
                                                <div class="col-md-5 fw-bold text-end"
                                                    style="word-wrap:none ;color:#009688!important">

                                                    {{ formatPhoneNumber(@base64_decode(session('phone'))) }}

                                                </div>
                                            </div>
                                            <hr class="my-4">
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="text-center  my-5">
                                    <h3 class="text-danger text-center fw-bold mb-5">Your Cart is empty!</h3>
                                    <a href="{{ url('services') }}" class='btn text-center btn-primary btn-sm checkoutbtn'
                                        style='background: #910301; border: 1px solid yellow;'>Go to services</a>
                                </div>
                            @endif


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script_area')
@endsection
