@extends('includes.master')
@section('title', 'Event')

@section('style-section')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.1/css/lightbox.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.1/js/lightbox-plus-jquery.min.js"></script>
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/services-cart.css') }}">

    <style type="text/css">
        .table-inputs {
            border-spacing: 0;
            border-collapse: collapse;
        }

        .table-inputs th {
            padding: 0 0.75rem;
            line-height: 1.75rem;
            font-weight: normal;
            font-size: 12px;
            border: 1px solid #d2d2d2;
        }

        .table-inputs td {
            background-color: #fff;
            border-right: 1px solid #d2d2d2;
            padding: 0;
        }

        .table-inputs input {
            border: 0;
            background-color: transparent;
        }

        .ui-timepicker-container {
            position: absolute;
            overflow: hidden;
            box-sizing: border-box
        }

        .ui-timepicker,
        .ui-timepicker-viewport {
            box-sizing: content-box;
            height: 205px;
            display: block;
            margin: 0
        }

        .ui-timepicker {
            list-style: none;
            padding: 0 1px;
            text-align: center
        }

        .ui-timepicker-viewport {
            padding: 0;
            overflow: auto;
            overflow-x: hidden
        }

        .ui-timepicker-standard {
            font-size: 12px;
            font-family: sans-serif;
            list-style: none;
            background-color: #fff;
            background-clip: padding-box;
            border-radius: 0 0 3px 3px;
            box-shadow: 0 0 0 .75px #bbb, 2px 1.5px 3px rgba(0, 0, 0, .16);
            margin: 0;
            padding: 0;
        }

        .ui-timepicker-standard a {
            display: block;
            background: transparent;
            filter: none;
            border: none;
            width: 100%;
            text-align: left;
            border-radius: 0;
            font-size: 11.5px;
            padding: 5px 10px;
            line-height: 18px;
            white-space: nowrap;
            text-decoration: none;
            color: inherit;
        }

        .ui-timepicker-standard .ui-state-hover {
            box-shadow: none;
            border: none;
            text-decoration: none;
            background-color: #555;
            color: #fff;
        }

        .ui-timepicker-standard .ui-menu-item {
            margin: 0;
            padding: 0
        }

        .ui-timepicker-hidden {
            display: none
        }

        .ui-timepicker-no-scrollbar .ui-timepicker {
            border: none
        }
    </style>
@section('content')

    @php
        $cartList = session('facilities_cart');
        $cart_count = isset($cartList['ids']) && $cartList['ids'] ? count($cartList['ids']) : 0;
        $cart_count = $cart_count != '' ? $cart_count : 0;
        if (empty($cartList['ids'])) {
            $cartList = ['totalPrice' => 0.0, 'ids' => []];
        }
        $currencySymbol = isset($currency['currencySymbol'])
            ? (CheckEmptyNullVar($currency['currencySymbol']) != ''
                ? $currency['currencySymbol']
                : '$')
            : '$';
        $GeneralSettings = GeneralSettings();
    @endphp

    <!-- ======= Coming Soon ======= -->
    <section class="temple-services"
        style="background-image: url({{ asset('assets/img/elegant-background-with-mandala.png') }});background-size: auto;">
        <div class="container-fluid bg-image shadow-1-strong">
            <div class="row">
                <div class="col-md-12 mx-auto">
                    <div class="row m-0 p-0">

                        <div class="col-md-12">
                            <div class="row" id="searchField">
                                <div class="col-md-12 m-0 p-0">

                                    <div class="px-5 p-4">
                                        <input type="search" name="q" id="search" class="search-text searchKey"
                                            placeholder="Search..." autocomplete="off"
                                            style="margin-left: 10px;height: 70px;">

                                    </div>
                                    <!-- <p class="mt-3 px-5 text-center">Please see <a href="{{ asset('assets/uploads/SSVT_Facility_Rental_Agreement.pdf') }}" class="text-danger" target="_blank">Temple Facilities Rental Agreement <i class="fa fa-download"></i></a> for details about each facility and availability contact the temple manager.</p> -->
                                </div>
                            </div>

                            <div class="row mt-5"
                                style="display: flex; flex-direction: row; align-content: flex-end; align-items: flex-end;">



                                <div class="col-md-6 col-lg-4 col-xl-4 px-4" style="display: flex;align-items: flex-end;">
                                    <div class="row m-0 p-0">
                                        <div class="col-md-12 m-0 p-0">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-3 col-xl-3">
                                    <h2 class="bottomborder text-center pb-1 mb-2"
                                        style="font-weight:bold!important;font-size: 25px!important;">BOOK FACILITIES
                                    </h2>
                                </div>

                                <div class="col-md-6 col-lg-5 col-xl-5">
                                    <div class="d-flex justify-content-end align-items-end" style="border-bottom: 20px;">
                                        <div class="text-white">

                                            <div class="row">
                                                <div class="col-md-12 text-center text-dark">
                                                    <span class="fw-bold" style="padding-left: 34px;">Total
                                                        Amount</span>
                                                </div>

                                                <div class="col-md-12 text-end text-dark">
                                                    <span style="padding-right:6px!important">
                                                        <a href="javascript:void(0)" onclick="ViewCart()"> <i
                                                                class="fa fa-shopping-cart fa-2x"
                                                                style="color:#000030;"></i>
                                                            <span class="cart-count text-dark"
                                                                style="font-size: 14px!important;"><?= $cart_count ?></span></a>
                                                    </span>

                                                    <label class="label label-primary"
                                                        style="background: #000030;padding: 5px 14px;color: white;margin: 0px 8px;border-radius: 6px;font-size: 14px;font-weight: 1000;"><?= $currencySymbol != '' ? $currencySymbol : '$ ' ?>
                                                        <span
                                                            class="allPrice"><?= sprintf('%.2f', $cartList['totalPrice']) ?></span></label>

                                                    <a href="javascript:void(0)" class="btn btn-success"
                                                        style="background-color: #ffc107;padding: 5px 14px;color: #15102e;border-radius: 6px!important;font-size: 14px;font-weight: 1000;border: 0px!important;margin: 0px 8px;"
                                                        onclick="CartCheckLogin('facilities')">SEND REQUEST</a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="justify-content-center align-items-center filter-tab mt-4" style="overflow:hidden">

                            <!-- ============================== -->

                            <div>
                                <?php
                                $rental_types = GetRentalTypes()['data'];
                                ?>
                                <!-- @@@@@@@@@@@@@@@@@@@@@@ Service Types @@@@@@@@@@@@@@@@@@@@@@@@@ -->

                                <ul class="nav nav-tabs" id="myTab" role="tablist">

                                    <style type="text/css">
                                        .nav-link2.active {
                                            color: #fff !important;
                                            background: #005d4b !important;
                                            border: 1px solid #fff !Important;
                                            font-weight: 500;
                                            margin-bottom: 0px !important;
                                        }

                                        .nav-link2 {
                                            padding: 8px 10px !important;
                                            font-size: 20px !important;
                                            color: #000 !important;
                                            border-radius: 5px !important;
                                            font-weight: 500;
                                            background: #E3E3E3 !important;
                                            margin-right: 3px !important;
                                            font-family: system-ui !important;
                                        }

                                        .nav-tabs {
                                            --bs-nav-tabs-border-width: 0;
                                            --bs-nav-tabs-border-radius: 0;
                                        }
                                    </style>
                                    <?php  if(!empty($rental_types)){ foreach ($rental_types as $key => $val) { ?>

                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link nav-link2 <?= $key == 0 ? 'serviceTypes1 active' : '' ?>"
                                            id="home-tab<?= $val['_id'] ?>" data-bs-toggle="tab"
                                            data-bs-target="#home-tab-pane<?= $val['_id'] ?>" type="button" role="tab"
                                            aria-controls="home-tab-pane<?= $val['_id'] ?>" aria-selected="true"
                                            style="padding: 9px 6px!important;font-size: 14px!important;"><?= @$val['displayName'] ? @$val['displayName'] : $val['refDataName'] ?></button>
                                    </li>

                                    <?php } } ?>
                                </ul>
                                <div class="tab-content" id="myTabContent">

                                    <?php if(!empty($rental_types)){ foreach ($rental_types as $key => $val) { ?>

                                    <div class="tab-pane table-responsive fade shadow panettttttttt<?= $val['_id'] ?> show <?= $key == 0 ? 'active' : '' ?>"
                                        id="home-tab-pane<?= $val['_id'] ?>" role="tabpanel"
                                        aria-labelledby="home-tab<?= $val['_id'] ?>" tabindex="0">

                                        <?= getRentalServicesByRentalTypes($val['refDataCode'], $val['refDataName'], $cartList) ?>
                                    </div>
                                    <?php }} ?>
                                </div>
                                <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>



    </section>
    <!-- End Coming Soon -->




    <!-- End #main -->

@endsection

<script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>


<script type="text/javascript" src="{{ asset('assets/js/paging.js') }}"></script>

<script
    src="https://cdn.jsdelivr.net/gh/dubrox/Multiple-Dates-Picker-for-jQuery-UI@master/jquery-ui.multidatespicker.js">
</script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js">
</script>



<script type="text/javascript">
    $(document).ready(function() {

        // Custom Pagination
        $('.servicesDataTable').paging({
            limit: 20
        });
        $("[data-page='0']").click();
    });


    function showSection(selectElement, id) {
        var selectedValue = selectElement.value;


        // Reset values when hiding sections
        $("#start_time" + id).val('');
        $("#end_time" + id).val('');

        // Show both sections if "Hourly" is selected
        if (selectedValue.trim().toLowerCase() === 'hourly') {
            $("#time_section_" + id).removeClass('d-none');
            $("#date_section_" + id).removeClass('d-none');
        } else {
            // Show only date section for other options
            $("#date_section_" + id).removeClass('d-none');
            $("#time_section_" + id).addClass('d-none');
        }
    }




    // Custom Search Bar Start
    $("#search").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#table tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
    });
    // Custom Search Bar End

    function addTocart() {

        var totalPrice = 0;
        var cart_type = 'FACILITIES';
        var ids = [];
        var qty = [];
        var ctg = [];
        var serviceTypes = [];
        var serviceName = [];
        var startDate = [];
        var startTime = [];
        var serviceAmount = [];
        var description = [];
        var image = [];
        var bookingTypes = [];
        var start_time = [];
        var end_time = [];

        $('input[name="services_id[]"]:checked').each(function() {
            id = $(this).attr('data-id');

            loader.on();
            var init_qty = parseInt($("#quantity-input" + id).val());
            init_qty = init_qty ? parseInt(init_qty) : 1;
            totalPrice = parseFloat(totalPrice) + (parseFloat($(this).attr('data-price')) * init_qty);
            ctg.push($(this).attr('data-category'));
            serviceTypes.push($(this).attr('data-service-type'));
            serviceName.push($(this).attr('data-service-name'));
            image.push($(this).attr('data-image'));

            description.push($(this).attr('data-description'));

            bookingTypes.push($("#booking_type" + id).val());
            start_time.push($("#start_time" + id).val());
            end_time.push($("#end_time" + id).val());

            startDate.push($("#datepicker_" + id).val());
            startTime.push($("#timepicker_" + id).val());
            serviceAmount.push($(this).attr('data-price'));
            ids.push($(this).attr('data-id'));
            qty.push(init_qty);
        });

        $(".cart-count").text(ids.length);
        $(".allPrice").text((totalPrice / 1).toFixed(2));
        $.ajax({
            type: "POST",
            url: "{{ url('facilitiesContollers/Facilities/addCart') }}",
            data: {
                ids: ids,
                totalPrice: totalPrice,
                qty: qty,
                ctg: ctg,
                serviceTypes: serviceTypes,
                serviceName: serviceName,
                startDate: startDate,
                startTime: startTime,
                serviceAmount: serviceAmount,
                cart_type: cart_type,
                image: image,
                description: description,
                bookingTypes: bookingTypes,
                start_time: start_time,
                end_time: end_time
            },
            success: function(result) {
                console.log(result);
                loader.off();
            }
        });
    }

    function clearCart() {
        $('input[name="services_id[]"]:checked').each(function() {
            $("input[name='services_id[]']").prop('checked', false);
        });

        if ($("input[name='allCheck']").is(":checked")) {
            $("input[name='allCheck']").prop('checked', false);
        }
        addTocart();
    }

    function quantityMinusFunction(id) {

        var totalPrice = 0;
        var init_qty = parseInt($('#quantity-input' + id).val());
        if (init_qty > 1) {
            init_qty = init_qty ? parseInt(init_qty) - 1 : 0;
            $('#quantity-input' + id).val(init_qty);



            var initialPrice = $("#price_" + id).text();
            var initialResultAmt = initialPrice.replace(/\$/g, "");

            var subTotal = init_qty * initialResultAmt;

            $("#Totalprice_" + id).text("$ " + subTotal.toFixed(2));


        }

        addTocart();
    }

    function quantityPlusFunction(id) {
        var totalPrice = 0;
        var init_qty = parseInt($('#quantity-input' + id).val());
        init_qty = init_qty ? parseInt(init_qty) + 1 : 0;
        $('#quantity-input' + id).val(init_qty);


        var initialPrice = $("#price_" + id).text();
        var initialResultAmt = initialPrice.replace(/\$/g, "");
        var subTotal = init_qty * initialResultAmt;


        $("#Totalprice_" + id).text("$ " + subTotal.toFixed(2));
        addTocart();
    }


    function ViewCart() {
        if ($(".cart-count").text() > 0) {
            window.location.href = "{{ url('facilitiesContollers/Facilities/ViewCart') }}";

        } else {
            swal({
                title: "Your cart is empty!",
                text: "Please add some items to your cart.",
                icon: "warning",
                confirmButtonText: 'OK',
                confirmButtonColor: '#005D4B',
            });


        }

    }

    function CartCheckLogin(page) {

        if ($(".cart-count").text() > 0) {
            loader.on();

            var page_name = page;
            event.preventDefault();
            $.ajax({
                url: "{{ url('check-login-status') }}",
                type: "POST",
                dataType: "json",
                success: function(data) {
                    loader.off();

                    if (data == 0) {
                        openLoginModal(page_name);
                    } else {
                        if (page_name == 'facilities') {
                            window.location.href = "{{ url('facilities/checkout') }}";
                        }

                    }

                }
            });



        } else {
            swal({
                title: "Your cart is empty!",
                text: "Please add some items to your cart.",
                icon: "warning",
                confirmButtonText: 'OK',
                confirmButtonColor: '#005D4B',
            });


        }
    }

    function changebtnStyles(id) {
        $(".styles").removeClass('active-services');
        $(".styles").addClass('services');
        $("#" + id).addClass('active-services');
        $("#" + id).removeClass('services');
    }




    var tithiDates = [];

    function getDatesOfTithi(tithiVal) {
        $.ajax({
            type: "POST",
            url: "{{ url('Services/getThithiNext90Days') }}",
            data: {
                tithi: tithiVal
            },
            dataType: 'json',
            success: function(result) {
                tithiDates = result;

                $("#datesArray").val(tithiDates);
            }
        });
    }

    $(document).on('click', '.datepicker-services', function() {
        var dayVal = $(this).attr('daytype');
        var nclickF = $(this);

        $.ajax({
            type: "POST",
            url: "{{ url('Services/getThithiNext90Days') }}",
            data: {
                tithi: dayVal
            },
            dataType: 'json',
            success: function(result) {
                $("#datesArray").val(result);



                if (dayVal !== '') {
                    nclickF.notify(
                        "You can select only " + dayVal + " dates!", {
                            position: "right",
                            className: "success",
                        }
                    );
                } else {
                    nclickF.notify(
                        "You can select any date!", {
                            position: "right",
                            className: "success",
                        }
                    );
                }


                if (!$(nclickF).hasClass('hasDatepicker')) {
                    if (dayVal == '') {
                        $(nclickF).multiDatesPicker({
                            dateFormat: "mm/dd/yy",
                            minDate: 0,
                            changeMonth: true,
                            changeYear: false,
                            onSelect: function(dateText, inst) {
                                $(this).datepicker('show');
                                addTocart();
                            }
                        });
                    } else {

                        $(nclickF).multiDatesPicker({
                            dateFormat: "mm/dd/yy",
                            minDate: 0,
                            changeMonth: true,
                            changeYear: false,
                            onSelect: function(dateText, inst) {
                                $(this).datepicker('show');
                                addTocart();
                            },


                            beforeShowDay: function(date) {
                                var dayOfWeek = $.datepicker.formatDate('DD', date);
                                var dateInMMDDYYFormat = $.datepicker.formatDate(
                                    'yy-mm-dd', date);

                                var tithis = ["PRATIPADA", "DWITIYA", "TRITIYA",
                                    "CHATURTHI", "PANCHAMI", "SHASHDI", "SAPTAMI",
                                    "ASHTAMI", "NAVAMI", "DASHAMI", "EKADASHI",
                                    "DWADASHI", "TRAYODASHI", "CHATURDASHI",
                                    "PURNIMA", "AMAVASYA"
                                ];

                                if (dayOfWeek.toUpperCase() === dayVal.toUpperCase()) {
                                    return [true];
                                } else if (tithis.includes(dayVal.toUpperCase())) {

                                    var tithiDates = $("#datesArray").val();




                                    var startDatearray = tithiDates.split(" ").pop()
                                        .split(",");
                                    return [startDatearray.includes(
                                        dateInMMDDYYFormat)];



                                } else {
                                    return [false];
                                }
                            }
                        });
                    }
                }

                $(nclickF).datepicker('show');

            }
        });

    });




    // Time Picker Code start
    var $begin = $('.hasTimepicker.start');
    var $end = $('.hasTimepicker.end');
    var $input = $('.timeSum');

    var timeOptions = {
        interval: 15,
        dropdown: true,
        change: function(time) {
            sumHours();
        }
    }

    $begin.timepicker(timeOptions);
    $end.timepicker(timeOptions);

    $(document).on('focus', $end, function() {
        $(this).select();
    });
    $begin.on("click, focus", function() {
        $(this).select();
    });

    function sumHours() {
        var time1 = $begin.timepicker().getTime();
        var time2 = $end.timepicker().getTime();

        if (time1 && time2) {

            if (time1 > time2) {
                v = new Date(time2);
                v.setDate(v.getDate() + 1);
            } else {
                v = time2;
            }
            var diff = (Math.abs(v - time1) / 36e5).toFixed(2);
            $input.val(diff);

        } else {

            $input.val('');

        }
    }
    // Time Picker Code end
</script>
