@extends('includes.master')
@section('title', 'Services')

@section('style-section')
    <style type="text/css">
        @media (min-width: 1025px) {
            .h-custom {
                height: 100vh !important;
            }
        }

        .card-registration .select-input.form-control[readonly]:not([disabled]) {
            font-size: 1rem;
            line-height: 2.15;
            padding-left: .75em;
            padding-right: .75em;
        }

        .card-registration .select-arrow {
            top: 13px;
        }

        .bg-grey {
            background-color: #eae8e8;
        }

        @media (min-width: 992px) {
            .card-registration-2 .bg-grey {
                border-top-right-radius: 16px;
                border-bottom-right-radius: 16px;
            }
        }

        @media (max-width: 991px) {
            .card-registration-2 .bg-grey {
                border-bottom-left-radius: 16px;
                border-bottom-right-radius: 16px;
            }
        }

        .booknow-btn {
            background-color: #ffc107;
            padding: 5px 14px;
            color: #15102e;
            border-radius: 6px !important;
            font-size: 17px;
            font-weight: 1000;
            border: 0px !important;
            margin: 0px 8px;
        }

        .form-select:focus {
            box-shadow: none !important;
        }

        .form-control:focus {
            box-shadow: none !important;
        }


        #inlineCheckbox2[readonly] {
            opacity: 1;
            /* Keep the original appearance */
            pointer-events: none;
            /* Prevent user interaction */
        }

        .form-check-inline {
            display: inline-block;
            margin-right: 8rem;
        }
    </style>
@section('content')
    <section
        style="background-image: url({{ url('assets/img/elegant-background-with-mandala.png') }});background-size: auto;">
        <center>
            <h2 class="bottomborder p-3" style="font-weight:bold!important;font-size: 35px!important;">Checkout</h2>
        </center>
        <br>
        {{-- @dd(session($session_data)) --}}
        <div class="h-100 responsive-container">
            <div class="row d-flex justify-content-center align-items-center h-100">
                <div class="col-12">
                    <div class="card card-registration card-registration-2 mb-4" style="border-radius: 15px;">
                        <div class="card-body p-3">
                            <div class="card-header text-end px-3"
                                style="font-size: 18px!important;background-color:#315c61;">
                                <a href="javascript:void(0)" class="btn" onclick="window.history.back()"
                                    style=";background-color:#df4a19;color: white!important;border-radius: 1px!important;">←
                                    Back</a>
                                <a href="{{ url('donations') }}" class="btn"
                                    style=";background-color:#009688;color: white!important;border-radius: 1px!important;">Close
                                    X</a>
                            </div>
                            <?php
							$currencySymbol = getCurrencySymbol();
							if (isset(session($session_data)['ids'])) { ?>
                            <div class="row g-0">
                                <div class="col-lg-7" style="background-color:#f5f5f5">
                                    <div class="p-5">
                                        <?php $cart_items = session($session_data); ?>
                                        <div class="d-flex justify-content-between align-items-center mb-5">
                                            <h3 class="fw-bold mb-0 text-black">Sale Summary</h3>
                                            <?php foreach ($cart_items['ids'] as $key => $value) {
                                            } ?>
                                            <h6 class="mb-0 text-muted"><?= $key + 1 ?> items</h6>
                                        </div>
                                        <hr class="my-4">
                                        <!-- ============================================= -->
                                        <div class="table-responsive">
                                            <table style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th style="width:40%" class="text-start">Donation Name</th>
                                                        <th style="width:40%" class="text-center">Category</th>
                                                        <th style="width:5%" class="text-center">Qty</th>
                                                        <th style="width:15%" class="text-end">Amount</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
														foreach ($cart_items['ids'] as $key => $value) { ?>
                                                    <tr>
                                                        <td class="text-start">{{ $cart_items['serviceName'][$key] }}</td>
                                                        <td class="text-center">{{ $cart_items['ctg'][$key] }}</td>
                                                        <td class="text-center">{{ $cart_items['qty'][$key] }}</td>
                                                        <td class="text-end">
                                                            {{ $currencySymbol . ' ' . price_format($cart_items['serviceAmount'][$key], 2) }}
                                                        </td>
                                                    </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <!-- ============================================= -->

                                        <hr class="my-4">
                                        <?php if (@CheckEmptyNullVar($GeneralSettings['TaxPercent']) != '' && @$GeneralSettings['TaxPercent'] > 0) { ?>

                                        <div class="row mt-3">
                                            <div class="col-md-10">
                                                <h5 class="mb-0" style="font-weight:bold!important;">Tax
                                                    (<?= @$GeneralSettings['TaxPercent'] != '' || @$GeneralSettings['TaxPercent'] != 0 ? @$GeneralSettings['TaxPercent'] : 0 ?>%)
                                                </h5>
                                            </div>
                                            <div class="col-md-2 text-end"><span
                                                    style="font-weight:bold!important;"><?= $currencySymbol ?>
                                                    <?= (price_format($cart_items['totalPrice'], 2) * price_format(@$GeneralSettings['TaxPercent'], 2)) / 100 ?></span>
                                            </div>

                                            <?php $taxAmt = (price_format($cart_items['totalPrice'], 2) * price_format(@$GeneralSettings['TaxPercent'], 2)) / 100; ?>
                                        </div>

                                        <hr class="my-4">
                                        <?php }else{
												$taxAmt = 0;
											} ?>

                                        <div class="row mt-3">
                                            <div class="col-md-10">
                                                <h5 class="mb-0" style="font-weight:bold!important;">Subtotal</h5>
                                            </div>
                                            <div class="col-md-2 text-end"><span
                                                    style="font-weight:bold!important;"><?= $currencySymbol ?>
                                                    <?= price_format($cart_items['totalPrice'], 2) ?></span></div>

                                        </div>


                                        <hr class="my-4">

                                        <div class="row p-3" style="background-color:#dbdbdb">
                                            <div class="col-md-8">
                                                <h4 class="text-dark"
                                                    style="margin-top:auto;margin-bottom:auto;font-weight: bold!important;">
                                                    Sale Total</h4>
                                            </div>
                                            <div class="col-md-4">

                                                <h4 class="text-dark text-end"
                                                    style="margin-top:auto;margin-bottom:auto;font-weight: bold!important;">
                                                    <?= $currencySymbol ?>&nbsp;<?= price_format($cart_items['totalPrice'] + @$taxAmt, 2) ?>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="p-5">
                                        <div class="row">
                                            <div class="col-md-7 fw-bold text-start">
                                                <h5 class="mb-2" style="color:#009688!important">
                                                    <?= @$this->session->userdata('refDataName') ?></h5>
                                                <span><?= @base64_decode($this->session->userdata('email')) ?></span>
                                            </div>
                                            <div class="col-md-5 fw-bold text-end"
                                                style="word-wrap:none ;color:#009688!important">

                                                <?= formatPhoneNumber(@base64_decode($this->session->userdata('phone'))) ?>

                                            </div>
                                        </div>
                                        <hr class="my-4">

                                        <?php $subTotal = price_format(($cart_items['totalPrice'] * @$GeneralSettings['TaxPercent'] ? $GeneralSettings['TaxPercent'] : 0) / 100 + $cart_items['totalPrice'], 2);
                                        $this->session->set_userdata('totalPrice', $subTotal);
                                        $newSubTotal = $this->session->userdata('totalPrice');
                                        ?>
                                        <?php if (@CheckEmptyNullVar($GeneralSettings['TaxPercent']) != '' && @$GeneralSettings['TaxPercent'] > 0) {
                                            $cart_items['totalPrice'] = (price_format($cart_items['totalPrice'], 2) * price_format(@$GeneralSettings['TaxPercent'], 2)) / 100;
                                        } ?>
                                        <div class="text-center my-3">
                                            <div class="d-flex justify-content-between my-4">
                                                <h3 class="fw-bold" style="font-size: 25px;">Amount to Pay:</h3>
                                                <h3 class="fw-bold text-end"
                                                    style="font-size: 25px;border: 2px solid #dbdbdb;border-radius: 9px;padding: 3px;"
                                                    id="total-price">
                                                    <?= $currencySymbol ?>&nbsp;<?= price_format($cart_items['totalPrice'], 2) ?>
                                                </h3>
                                            </div>

                                            <!-- <h3>Recurring Module Coming Soon...</h3> -->
                                            <!-- Recurring Form Start-->

                                            <form id="recurring-form">
                                                <fieldset class="border-2 shadow bg-white p-0">

                                                    <div class="row">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Select Debit
                                                                    Frequency</legend>
                                                                <div class="input-group">

                                                                    <select id="debitFequency" name="debitFequency"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded  form-select border-0">
                                                                        <option value=" " selected disabled>Select
                                                                            Debit Frequency</option>
                                                                        <option value="Daily">Daily</option>
                                                                        <option value="Weekly">Weekly</option>
                                                                        <option value="Monthly">Monthly</option>
                                                                        <option value="Annually">Annually</option>

                                                                    </select>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                    </div>



                                                    <!-- Daily Section start -->

                                                    <div class="row payment-section" style="display: none;"
                                                        id="DailySection">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Daily
                                                                    Payment Schedule<span class="text-danger fw-bold"
                                                                        style="font-size: 20px;">*</span></legend>
                                                                <div class="input-group">

                                                                    <input type="text" name="startDailyDate"
                                                                        id="startDailyDate" class="form-control"
                                                                        placeholder="Start Date" required readonly>

                                                                </div>
                                                                <div class="input-group my-2">

                                                                    <input type="text" name="endDailyDate"
                                                                        id="endDailyDate" class="form-control"
                                                                        placeholder="End Date" required readonly>

                                                                </div>


                                                            </fieldset>
                                                        </div>
                                                    </div>

                                                    <!-- Daily Section end -->

                                                    <!-- Weekly Section start -->

                                                    <div class="row payment-section" style="display: none;"
                                                        id="WeeklySection">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Weekly
                                                                    Payment Schedule<span class="text-danger fw-bold"
                                                                        style="font-size: 20px;">*</span></legend>
                                                                <div class="input-group">

                                                                    <input type="text" name="startWeeklyDate"
                                                                        id="startWeeklyDate" class="form-control"
                                                                        placeholder="Start Date" required readonly>

                                                                </div>
                                                                <div class="input-group my-2">

                                                                    <input type="text" name="endWeeklyDate"
                                                                        id="endWeeklyDate" class="form-control"
                                                                        placeholder="End Date" required readonly>

                                                                </div>

                                                                <div class="input-group my-2">
                                                                    <select id="selectWeeklyDay" name="selectWeeklyDay"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded  form-select "
                                                                        required>
                                                                        <option value=" " selected disabled>Select Day
                                                                        </option>
                                                                        <option value="Monday">Monday</option>
                                                                        <option value="Tuesday">Tuesday</option>
                                                                        <option value="Wednesday">Wednesday</option>
                                                                        <option value="Thursday">Thursday</option>
                                                                        <option value="Friday">Friday</option>
                                                                        <option value="Saturday">Saturday</option>
                                                                        <option value="Sunday">Sunday</option>
                                                                    </select>
                                                                </div>

                                                            </fieldset>
                                                        </div>
                                                    </div>

                                                    <!-- Weekly Section end -->


                                                    <!-- Monthly Section start -->

                                                    <div class="row payment-section" style="display: none;"
                                                        id="MonthlySection">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Monthly
                                                                    Payment Schedule<span class="text-danger fw-bold"
                                                                        style="font-size: 20px;">*</span></legend>
                                                                <div class="input-group">

                                                                    <input type="text" name="startMonthlyDate"
                                                                        id="startMonthlyDate" class="form-control"
                                                                        placeholder="Start Date" required readonly>

                                                                </div>
                                                                <div class="input-group my-2">

                                                                    <input type="text" name="endMonthlyDate"
                                                                        id="endMonthlyDate" class="form-control"
                                                                        placeholder="End Date" required readonly>

                                                                </div>

                                                                <div class="input-group my-2">
                                                                    <select id="selectmonthDate" name="selectmonthDate"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded  form-select "
                                                                        required>
                                                                        <option value=" " selected disabled>Select Day
                                                                            of Month</option>
                                                                        <?php for($i=1; $i<=30; $i++){ ?>
                                                                        <option value="<?= $i ?>"><?= $i ?></option>

                                                                        <?php } ?>
                                                                    </select>
                                                                </div>


                                                            </fieldset>
                                                        </div>
                                                    </div>

                                                    <!-- Monthly Section end -->

                                                    <!-- Annually Section start -->

                                                    <div class="row payment-section" style="display: none;"
                                                        id="AnnuallySection">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Annually
                                                                    Payment Schedule<span class="text-danger fw-bold"
                                                                        style="font-size: 20px;">*</span></legend>

                                                                <div class="input-group my-2">
                                                                    <select id="selectAnualyMonthValue"
                                                                        name="selectAnualyMonthValue"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded form-select" required>
                                                                        <option value="" selected disabled>Select
                                                                            Month</option>
                                                                        <?php
																		$months = array(
																			"January", "February", "March", "April", "May", "June",
																			"July", "August", "September", "October", "November", "December"
																		);

																		foreach ($months as $index => $month) {
																			?>
                                                                        <option value="<?= $index + 1 ?>"><?= $month ?>
                                                                        </option>
                                                                        <?php
																		}
																		?>
                                                                    </select>
                                                                </div>

                                                                <div class="input-group my-2">
                                                                    <select id="selectAnualyDateValue"
                                                                        name="selectAnualyDateValue"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded form-select" required>
                                                                        <option value="" selected disabled>Select
                                                                            Date</option>
                                                                    </select>
                                                                </div>


                                                                <div class="input-group">
                                                                    <select name="startAnualyDate" id="startAnualyDate"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded  form-select "
                                                                        required>
                                                                        <option class=" " disabled selected>Start Year
                                                                        </option>
                                                                        <!-- Generate options for start year -->
                                                                        <?php
                                                                        $currentYear = date('Y');
                                                                        for ($year = $currentYear; $year <= $currentYear + 100; $year++) {
                                                                            echo "<option value='$year'>$year</option>";
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="input-group my-2">
                                                                    <select name="endAnualyDate" id="endAnualyDate"
                                                                        style="color:black!important;"
                                                                        class="form-control rounded  form-select "
                                                                        required>
                                                                        <option class=" " disabled selected>End Year
                                                                        </option>
                                                                        <!-- Options for end year are set using JavaScript based on the selected start year -->
                                                                    </select>
                                                                </div>
                                                            </fieldset>
                                                        </div>
                                                    </div>

                                                    <!-- Annually Section end -->

                                                    <div class="row">

                                                        <div class="col-md-12">
                                                            <fieldset class="border">
                                                                <legend class="legend-inner float-none w-auto">Mode of
                                                                    Payment<span class="text-danger fw-bold"
                                                                        style="font-size: 20px;">*</span></legend>
                                                                <div class="form-check form-check-inline"
                                                                    style="padding-bottom: 5px;">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        id="inlineCheckbox2" name="creditcard" checked
                                                                        readonly>
                                                                    <label class="form-check-label m-auto pt-2"
                                                                        for="inlineCheckbox2">Credit Card</label>
                                                                </div>

                                                                <!-- <div class="form-check form-check-inline" style="padding-bottom: 5px;">
                                                                     <input class="form-check-input" type="checkbox" id="inlineCheckbox1" name="ach">
                                                                     <label class="form-check-label m-auto pt-2" for="inlineCheckbox1">ACH</label>
                                                                    </div> -->

                                                                <script src="https://use.fontawesome.com/67ed5102d2.js"></script>
                                                                <script type="text/javascript" src="https://nosir.github.io/cleave.js/dist/cleave.min.js"></script>
                                                                <script type="text/javascript" src="https://nosir.github.io/cleave.js/lib/cleave-phone.i18n.js"></script>

                                                                <div class="row">
                                                                    <div class="col-md-12 mt-2">
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon">
                                                                                <span class="type"></span>
                                                                            </span>

                                                                            <input name="card-number" id="card-number"
                                                                                class="cardNumber type form-control"
                                                                                placeholder="Card Number" required>
                                                                        </div>

                                                                    </div>
                                                                    <div class="col-md-6 mt-2">
                                                                        <input type="text" name="exp-date"
                                                                            id="exp-date" class="expiry form-control"
                                                                            placeholder="Expired Date" required>

                                                                    </div>
                                                                    <div class="col-md-6 mt-2">
                                                                        <input maxlength="4" name="cvv"
                                                                            id="cvv" class="cvv form-control"
                                                                            placeholder="CVV" maxlength="3" required>

                                                                    </div>
                                                                    <div class="col-md-12 my-2">
                                                                        <input type="text" name="card-holder"
                                                                            id="card-holder" class="form-control"
                                                                            placeholder="Card Holder" required>

                                                                    </div>
                                                                </div>
                                                                <script type="text/javascript">
                                                                    new Cleave('.cardNumber', {
                                                                        creditCard: true,
                                                                        onCreditCardTypeChanged: function(type) {
                                                                            document.querySelector('.type').innerHTML = '<i class="fa fa-cc-' + type +
                                                                                ' fa-fw fa-2x active" aria-hidden="true"></i>';
                                                                        }
                                                                    });


                                                                    new Cleave('.expiry', {
                                                                        date: true,
                                                                        datePattern: ['m', 'y']
                                                                    });
                                                                </script>

                                                                <!-- ACH -->


                                                            </fieldset>
                                                        </div>

                                                    </div>

                                                    <a href="javascript:void(0)" id="submitRecurring"
                                                        class=" my-3 btn btn-success">
                                                        SUBMIT
                                                    </a>
                                                </fieldset>
                                            </form>


                                            <!-- Recurring Form End -->


                                        </div>
                                    </div>
                                </div>
                            </div>
                            <input type="hidden" id="totalDonation"
                                value="<?= price_format($cart_items['totalPrice'], 2) ?>">
                            <?php }else{ ?>

                            <div class="text-center  my-5">
                                <h3 class="text-danger text-center fw-bold mb-5">Your Cart is empty!</h3>
                                <a href="{{ url('recurring-sponsor-now/RECURRING DONATIONS') }}"
                                    class='btn text-center btn-primary btn-sm checkoutbtn'
                                    style='background: #910301; border: 1px solid yellow;'>Go to Recurring Donations</a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
