@extends('includes.master')
@section('title', 'recurring-donations')


@section('style-section')
    <link rel="stylesheet" href="{{ asset('assets/css/services-cart.css') }}">
    <style>
        .form-check-input {
            opacity: 100% !important;
            background-color: #005d4b !important;
            border: 3px solid rgb(255 193 7) !important;

        }

        label {
            color: white !important;
        }

        @media (min-width: 1024px) {

            /* CSS rules for screens with a minimum width typical of laptops */
            .responsive-container {
                padding: 50px;
            }
        }
    </style>
@section('content')
    <?php
    $cartList = session('recurring_donations_cart');
    $cart_count = isset($cartList['ids']) && $cartList['ids'] ? count($cartList['ids']) : 0;
    $cart_count = $cart_count != '' ? $cart_count : 0;
    if (empty($cartList['ids'])) {
        $cartList = ['totalPrice' => 0.0, 'ids' => []];
    }
    $currencySymbol = isset($currency['currencySymbol']) ? (checkEmptyNullVar($currency['currencySymbol']) != '' ? $currency['currencySymbol'] : '$') : '$';
    $generalSettings = generalSettings();
    ?>
    <!-- ======= Coming Soon ======= -->
    <section id="temple-services" class="temple-services"
        style="background-image: url({{ url('assets/img/elegant-background-with-mandala.png') }});background-size: auto;">
        <div class="bg-image shadow-1-strong">
            <div class="row">
                <div class="col-md-12 mx-auto">
                    <div class="row m-0 p-0">
                        <div class="col-md-12">
                            <div class="row mt-3" id="searchField">
                                <div class="col-md-12 m-0 p-0">

                                    <div class="px-5">
                                        <input type="search" name="q" id="search" class="search-text searchKey"
                                            placeholder="Search..." autocomplete="off"
                                            style="margin-left: 10px;height: 70px;">
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-5"
                                style="display: flex; flex-direction: row; align-content: flex-end; align-items: flex-end;">
                                <div class="col-md-4  px-4" style="display: flex;align-items: flex-end;">
                                    <div class="row m-0 p-0">
                                        <div class="col-md-12 m-0 p-0">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <h2 class="bottomborder text-center pb-1 mb-2"
                                        style="font-weight:bold!important;font-size: 25px!important;">
                                        {{ camelCase($serviceType) }}</h2>
                                </div>
                                <div class="col-md-5">
                                    <div class="d-flex justify-content-end align-items-end" style="border-bottom: 20px;">
                                        <div class="text-white px-4">
                                            <div class="row">
                                                <div class="col-md-9 text-start text-dark">
                                                    <span style="padding-left: 34px;">Total Amount</span>
                                                </div>
                                            </div>
                                            <span style="padding-right:6px!important">
                                                <a href="javascript:void(0)" onclick="ViewCart()"> <i
                                                        class="fa fa-shopping-cart fa-2x" style="color:#000030;"></i>
                                                    <span class="cart-count text-dark"
                                                        style="font-size: 14px!important;">{{ $cart_count }}</span></a>
                                            </span>
                                            <label
                                                class="label label-primary price-span">{{ $currencySymbol != '' ? $currencySymbol : '$ ' }}
                                                <span
                                                    class="allPrice">{{ sprintf('%.2f', $cartList['totalPrice']) }}</span></label>
                                            <a href="javascript:void(0)" class="btn btn-success paymentBtn"
                                                onclick="CartCheckLogin('recurring-sponsorships')">
                                                Proceed To Checkout
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="justify-content-center responsive-container align-items-center filter-tab mt-3"
                            style="overflow:hidden">
                            <!-- ============================== -->
                            <div class="tab-content shadow" id="myTabContent">


                                <style type="text/css">
                                    .amount-input-donations::placeholder {
                                        color: #d6fff7 !important;
                                        /* Replace 'your_color_here' with your desired color */
                                        font-size: 15px !important;
                                        /* Replace with your desired font-size */
                                        font-weight: bold !important;
                                        /* Replace with your desired font-weight */
                                    }
                                </style>

                                <?php
                                echo getRecurringSponsorTypesServicesByServiceType($serviceType, $cartList);
                                ?>

                                <div id="emptyServices" style="padding: 4px 66px; font-size: 21px; font-weight: 700;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Coming Soon -->
@endsection
<script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/js/paging.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        //  alert("This is wworking");
        // Custom Pagination


        var Page_limit = $("#pageLength").val();
        if (Page_limit > 20) {
            $('.servicesDataTable').paging({
                limit: Page_limit
            });
        }

        $("[data-page='0']").click();

        // TimePicker
        $('.timepicker-services').mdtimepicker();
    });

    $(document).ready(function() {
        $("#search").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var $tableRows = $(".serviceSearch");
            var noResults = true;

            $tableRows.filter(function() {
                var rowText = $(this).text().toLowerCase();
                var isMatch = rowText.indexOf(value) > -1;
                $(this).toggle(isMatch);
                if (isMatch) {
                    noResults = false;
                }
            });

            if (noResults && value !== "") {
                $("#emptyServices").text("No donations found!").show();
            } else {
                $("#emptyServices").hide();
            }
        }).on("search", function() {
            if ($(this).val() === "") {
                $("#table tr").show();
                $("#emptyServices").hide();
            }
        });
    });

    // Custom Search Bar End

    function addTocart() {

        var totalPrice = 0;
        var cart_type = 'SPONSORSHIP';
        var ids = [];
        var qty = [];
        var ctg = [];
        var serviceTypes = [];
        var serviceName = [];
        var serviceAmount = [];
        var description = [];
        var image = [];
        var cart_ctg = [];

        $('input[name="services_id[]"]:checked').each(function() {
            id = $(this).attr('data-id');

            // alert($(this).attr('data-price'));

            // loader.on();


            if ($(this).attr('data-price') != 0) {
                var init_qty = parseFloat($("#quantity-input" + id).val());
                init_qty = init_qty ? parseFloat(init_qty) : 1;
                totalPrice = parseFloat(totalPrice) + (parseFloat($(this).attr('data-price')) * init_qty);
            } else {
                totalPrice += parseFloat($(this).attr('data-price'));
            }

            var anyAmountCheck = parseFloat($("#anyAmtDonation" + id).val());
            if (anyAmountCheck < 0 || anyAmountCheck == 0) {
                $(this).prop('checked', false);
                $("#anyAmtDonation" + id).focus();
                $("#anyAmtDonation" + id).notify(
                    "Entered Amount Must Be Greater Than 0!", {
                        position: "right"
                    }
                );
                addtoCartStatus = false;
                // return false;
            }


            if ($("#anyAmtDonation" + id).val() == '') {
                $(this).prop('checked', false);
                $("#anyAmtDonation" + id).focus();
                $("#anyAmtDonation" + id).notify(
                    "Please Enter Any Amount!", {
                        position: "right"
                    }
                );
                addtoCartStatus = false;
                // return false;
            }

            if ($(this).attr('data-price') != 0) {

                ctg.push($(this).attr('data-category'));
                serviceTypes.push($(this).attr('data-service-type'));
                serviceName.push($(this).attr('data-service-name'));
                image.push($(this).attr('data-image'));
                description.push($(this).attr('data-description'));
                cart_ctg.push($(this).attr('cart_category'));
                serviceAmount.push($(this).attr('data-price'));
                ids.push($(this).attr('data-id'));
                qty.push(init_qty);
            }
        });

        $(".cart-count").text(ids.length);
        $(".allPrice").text((totalPrice / 1).toFixed(2));
        $.ajax({
            type: "POST",
            url: "{{ url('RecurringSponsorNow/addCart') }}",
            data: {
                ids: ids,
                totalPrice: totalPrice,
                qty: qty,
                ctg: ctg,
                serviceTypes: serviceTypes,
                serviceName: serviceName,
                serviceAmount: serviceAmount,
                cart_type: cart_type,
                image: image,
                description: description,
                cart_ctg: cart_ctg
            },
            success: function(result) {
                var responseObject = JSON.parse(result);
                var totalPrice = responseObject.totalPrice;

                console.log(totalPrice);
                // loader.off();
            }
        });

    }

    function quantityMinusFunction(id) {

        var totalPrice = 0;
        var init_qty = parseInt($('#quantity-input' + id).val());
        if (init_qty > 1) {
            init_qty = init_qty ? parseInt(init_qty) - 1 : 0;
            $('#quantity-input' + id).val(init_qty);
        }
        var initialPrice = $("#price_" + id).text();
        var initialResultAmt = initialPrice.replace(/\$/g, "");
        var substractiveAmt = init_qty * initialResultAmt;
        $("#Totalprice_" + id).text(substractiveAmt.toFixed(2));
        addTocart();
    }

    function quantityPlusFunction(id) {
        var totalPrice = 0;
        var init_qty = parseInt($('#quantity-input' + id).val());
        init_qty = init_qty ? parseInt(init_qty) + 1 : 0;
        $('#quantity-input' + id).val(init_qty);
        var initialPrice = $("#price_" + id).text();
        var initialResultAmt = initialPrice.replace(/\$/g, "");
        var substractiveAmt = init_qty * initialResultAmt;
        $("#Totalprice_" + id).text(substractiveAmt.toFixed(2));
        addTocart();
    }

    function ViewCart() {
        if ($(".cart-count").text() > 0) {
            window.location.href = "{{ url('RecurringSponsorNow/ViewCart') }}";

        } else {
            swal({
                title: "Your cart is empty!",
                text: "Please add some items to your cart.",
                icon: "warning",
                confirmButtonText: 'OK',
                confirmButtonColor: '#005D4B',
            });


        }

    }

    function CartCheckLogin(page) {
        //alert("djkfvjgm");
        if ($(".cart-count").text() > 0) {
            loader.on();
            var page_name = page;
            event.preventDefault();
            $.ajax({
                url: "{{ url('check-login-status') }}",
                type: "POST",
                dataType: "json",
                success: function(data) {
                    loader.off();
                    if (data == 0) {
                        openLoginModal(page_name);
                    } else {
                        if (page_name == 'recurring-sponsorships') {
                            window.location.href = "{{ url('recurring-sponsor-checkout') }}";
                        }
                    }
                }
            });
        } else {
            swal({
                title: "Your cart is empty!",
                text: "Please add some items to your cart.",
                icon: "warning",
                confirmButtonText: 'OK',
                confirmButtonColor: '#005D4B',
            });
        }
    }

    function changebtnStyles(id) {
        $(".styles").removeClass('active-services');
        $(".styles").addClass('services');
        $("#" + id).addClass('active-services');
        $("#" + id).removeClass('services');
    }
</script>
