@extends('includes.master')
@section('title', 'sponsor-now-services')
@section('style-section')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/services-cart.css') }}">
@endsection

@section('content')
    <section class="temple-services"
        style="background-image: url({{ asset('assets/img/elegant-background-with-mandala.png') }});background-size: auto;">

        <!-- ======================= -->

        <div class="row mb-0 pb-0" style="padding: 0px 50px;">

            <center class="mb-3">
                <h2 class="text-center mb-0"
                    style="font-weight:bold!important;font-size: 30px!important;text-shadow: 1px 1px 5px #FA9D1E;padding:20px">
                    {{ camelCase($sponsorType_details[0]['displayName']) }}
                    </br />
                    <img src="{{ asset('assets/img/border.png') }}" width="20%"
                        alt="{{ $sponsorType_details[0]['displayName'] }}">
                </h2>

            </center>
            <div class="col-md-6 mb-0 pb-0 aos-init aos-animate" data-aos="fade-right">
                <div style="height:422px;width: 100%;display: flex; justify-content: center; align-items: center;">
                    <img src="{{ ApiBaseUrl()['url'] . $sponsorType_details[0]['image'] }}" class="img-fluid rounded shadow"
                        style="width: 100%; height:auto;max-width: 100%;max-height: 100%;">
                </div>
            </div>

            <div class="text-center mb-0 pb-0 col-md-6 aos-init aos-animate" data-aos="fade-left">

                <p class="text-start">
                    {{ $sponsorType_details[0]['description'] }}
                </p>

            </div>
        </div>

        <!-- ======================= -->


        @php
            $cartList = session('sponsorship_cart');

            // dd($cartList);

            $cart_count = isset($cartList['ids']) && $cartList['ids'] ? count($cartList['ids']) : 0;
            $cart_count = $cart_count != '' ? $cart_count : 0;
            if (empty($cartList['ids'])) {
                $cartList = ['totalPrice' => 0.0, 'ids' => []];
            } else {
                if ($cartList['is_date_required'] == 'YES') {
                    // code...
                    $cartDetelists = [];
                    $cartDetelistsCount = 0;

                    foreach ($cartList['startDate'] as $key => $value) {
                        $cartDetelistsCount =
                            $cartDetelistsCount + count(explode(',', $value)) * $cartList['qty'][$key];
                    }
                    $cart_count = $cartDetelistsCount;
                } else {
                    $cart_count = $cart_count != '' ? $cart_count : 0;
                }
            }

            $currencySymbol = getCurrencySymbol();
            $GeneralSettings = GeneralSettings();

        @endphp

        {{-- //////// --}}


        <div class="bg-image shadow-1-strong mt-5">
            <div class="row">
                <div class="col-md-12 mx-auto">
                    <div class="row m-0 p-0">
                        <div class="col-md-12">
                            <div class="row" id="searchField">
                                <div class="col-md-12 m-0 p-0">

                                    <div class="px-5">
                                        <input type="search" name="q" id="search" class="search-text searchKey"
                                            placeholder="Search..." autocomplete="off"
                                            style="margin-left: 10px;height: 70px;">
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-5"
                                style="display: flex; flex-direction: row; align-content: flex-end; align-items: flex-end;">



                                <div class="col-md-4  px-4" style="display: flex;align-items: flex-end;">
                                    <div class="row m-0 p-0">
                                        <div class="col-md-12 m-0 p-0">

                                            <!-- <div class="px-2">
                                                                                                             <input type="search" name="q" id="search" class="search-text searchKey" placeholder="Search..." autocomplete="off" style="margin-left: 10px;     width: 400px;height: 56px;">
                                                                                                            </div> -->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <h2 class="bottomborder text-center pb-1 mb-2"
                                        style="font-weight:bold!important;font-size: 25px!important;">SPONSOR NOW </h2>
                                </div>

                                <div class="col-md-5">
                                    <div class="d-flex justify-content-end align-items-end" style="border-bottom: 20px;"
                                        id="RightField">
                                        <div class="text-white px-4">
                                            <div class="row">
                                                <div class="col-md-9 text-start text-dark">
                                                    <span class="fw-bold" style="padding-left: 34px;">Total Amount</span>
                                                </div>
                                            </div>

                                            <div style="display: flex;align-items: flex-end;">
                                                <span style="padding-right:6px!important">
                                                    <a href="javascript:void(0)" onclick="ViewCart()"> <i
                                                            class="fa fa-shopping-cart fa-2x" style="color:#000030;"></i>
                                                        <span class="cart-count text-dark"
                                                            style="font-size: 14px!important;">{{ $cart_count }}</span></a>
                                                </span>
                                                <label
                                                    class="label label-primary price-span"><?= $currencySymbol != '' ? $currencySymbol : '$ ' ?>
                                                    <span
                                                        class="allPrice"><?= sprintf('%.2f', $cartList['totalPrice']) ?></span></label>



                                                <?php if ((isset($GeneralSettings['isMultipleSelect']) && $GeneralSettings['isMultipleSelect'] == 'YES')) { ?>

                                                <a href="javascript:void(0)" class="btn btn-success paymentBtn"
                                                    onclick="CartCheckLogin('sponsorships')">

                                                    <?php if (isset($GeneralSettings['payNowText']) && $GeneralSettings['payNowText'] != '' && $GeneralSettings['payNowText'] != 'null') {
                                                        echo $GeneralSettings['payNowText'];
                                                    } else {
                                                        echo 'Proceed to Checkout';
                                                    } ?>
                                                </a>
                                                <?php }else if(isset($GeneralSettings['isMultipleSelect']) && $GeneralSettings['isMultipleSelect'] == 'NO'){ ?>

                                                <a href="javascript:void(0)" class="btn btn-success paymentBtn"
                                                    onclick="CartCheckLogin('sponsorships')">

                                                    <?php if (isset($GeneralSettings['payLetterText']) && $GeneralSettings['payLetterText'] != '' && $GeneralSettings['payLetterText'] != 'null') {
                                                        echo $GeneralSettings['payLetterText'];
                                                    } else {
                                                        echo 'BOOK NOW';
                                                    } ?>
                                                </a>

                                                <?php }else{ ?>
                                                <a href="javascript:void(0)" class="btn btn-success paymentBtn"
                                                    onclick="CartCheckLogin('sponsorships')">
                                                    <?php if (isset($GeneralSettings['payNowText']) && $GeneralSettings['payNowText'] != '' && $GeneralSettings['payNowText'] != 'null') {
                                                        echo $GeneralSettings['payNowText'];
                                                    } else {
                                                        echo 'Proceed To Checkout';
                                                    } ?>
                                                </a>
                                                <?php } ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="justify-content-center align-items-center filter-tab px-2" style="overflow:hidden">

                            <div style="padding: 0px 50px;" id="Abc">

                                <div class="tab-content mt-4 table-responsive" id="myTabContent">
                                    <?php
                                    echo getSponsorTypesServicesByServiceType($serviceType, $cartList);
                                    ?>
                                    <div id="emptyServices" style="padding: 4px 66px; font-size: 21px; font-weight: 700;">

                                    </div>
                                </div>

                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>



    </section>
@endsection

@section('script_area')
    <script src="{{ asset('assets/js/jquery-3.6.0.min.js') }}"></script>
@endsection
