<?php

use App\Http\Controllers\AboutTempleContoller;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\PriestFormContoller;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\DonationsController;
use App\Http\Controllers\SponsorNowController;
use App\Http\Controllers\Facilities\FacilitiesContoller;
use App\Http\Controllers\RecurringSponsorNowController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\GharbhalayaLandController;
use App\Http\Controllers\FormsController;
use App\Http\Controllers\MembershipFormController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\ServiceRequestController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('/About', [HomeController::class, 'index']);

Route::post('/get-panchangam', [HomeController::class, 'getpanchangamData'])->name('get-panchangam');
Route::post('/signup', [HomeController::class, 'SignUp'])->name('signup');
Route::post('/send-email-otp', [HomeController::class, 'sendEmailOTP'])->name('send-email-otp');
Route::post('/verify-Email-Otp', [HomeController::class, 'verifyEmailOtp'])->name('verifyEmailOtp');
Route::post('/check-login-status', [HomeController::class, 'checkLoginStatus'])->name('check-login-status');
Route::post('signin', [HomeController::class, 'login'])->name('signin');
Route::get('calendar', [HomeController::class, 'calendar'])->name('calendar');
Route::post('getcity', [HomeController::class, 'GetCity'])->name('getcity');
Route::get('contact-us', [HomeController::class, 'Contact_us'])->name('contact-us');
Route::post('your-query', [HomeController::class, 'submitContactForm'])->name('your-query');
// Service section
Route::get('services', [ServiceController::class, 'index'])->name('services');
Route::post('getThithiNext90Days', [ServiceController::class, 'getThithiNext90Days'])->name('getThithiNext90Days');
Route::post('addCart', [ServiceController::class, 'addCart'])->name('addCart');
Route::get('checkout/{param1}', [CheckoutController::class, 'index'])->name('checkout');
Route::get('services-request/{param1}', [ServiceController::class, 'ServiceRequestForm'])->name('services-request');


// Event Section
Route::get('event/{refDataName}/{id}', [EventController::class, 'index'])->name('event');
Route::get('all-upcoming-events', [EventController::class, 'allUpcomingEvents'])->name('all-upcoming-events');
// Donations Section

Route::get('donations', [DonationsController::class, 'index'])->name('donations');
Route::post('donations', [DonationsController::class, 'addCart'])->name('donations-addCart');
Route::get('donations-checkout', [DonationsController::class, 'Checkout'])->name('donations-checkout');

////////// SponsorNow

Route::get('sponsor-now',[SponsorNowController::class,'index'])->name('SponsorNow');
Route::get('get-sponsor-now/{any}',[SponsorNowController::class,'getSponsorServices'])->name('get-sponsor-now');
Route::get('recurring-sponsor-now/{recurring-donations}',[SponsorNowController::class,'getRecurringSponsorServices']);



Route::get('gharbhalaya_land_donations',[GharbhalayaLandController::class,'index'])->name('gharbhalaya_land_donations');
Route::post('addserviceCart',[GharbhalayaLandController::class,'addCart'])->name('addserviceCart');
Route::get('garbhalayalandcheckout',[GharbhalayaLandController::class,'checkout'])->name('garbhalayalandcheckout');

Route::get('facilities', [FacilitiesContoller::class, 'index'])->name('facilities');

// recurring-sponsor-now
Route::get('recurring-sponsor-now/{param1}', [RecurringSponsorNowController::class, 'getRecurringSponsorServices'])->name('recurring-sponsor-now');
Route::get('recurring-sponsor-checkout', [RecurringSponsorNowController::class, 'Checkout'])->name('recurring-sponsor-checkout');

// About Tempel
Route::get('about-temple', [AboutTempleContoller::class, 'About_temple'])->name('about-temple');
Route::get('about-deities', [AboutTempleContoller::class, 'About_deity'])->name('about-deities');
Route::get('about-priest', [AboutTempleContoller::class, 'About_priest'])->name('about-priest');

//Priest Form
Route::get('priest-request-form', [PriestFormContoller::class, 'index'])->name('priest-request-form');
Route::post('PriestForm-submitPriestRequest', [PriestFormContoller::class, 'submitPriestRequest'])->name('PriestForm-submitPriestRequest');
// MemberShip Form
Route::get('membership-form', [MembershipFormController::class, 'index'])->name('membership-form');


// Forms

Route::get('volunteer', [FormsController::class, 'Volunteers'])->name('volunteer');
Route::post('add-volunteer', [FormsController::class, 'AddVolunteers'])->name('add-volunteer');



Route::prefix('Admin')->name('admin.')->group(function () {
    // Define routes within this group
    Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('my-profile', [AdminController::class, 'MyProfile'])->name('my-profile');
    Route::get('update-profile', [AdminController::class, 'EditProfile'])->name('update-profile');
    Route::post('save-profile', [AdminController::class, 'updateProfile'])->name('save-profile');
    Route::get('in-temple-bookings', [AdminController::class, 'In_Temple_Bookings'])->name('in-temple-bookings');
    Route::get('logout', [AdminController::class, 'logout'])->name('logout');
    Route::post('filterBookingData', [AdminController::class, 'FilterBookingData'])->name('filterBookingData');
    Route::post('CancelBooking', [AdminController::class, 'CancelBooking'])->name('CancelBooking');
    Route::get('my-donation', [AdminController::class, 'MyDonations'])->name('my-donation');
    Route::get('my-payments', [AdminController::class, 'MyPayments'])->name('my-payments');
    Route::get('refund-payment/{id}', [AdminController::class, 'RefundPayment'])->name('refund-payment');
    Route::post('request-refund-payment/{insertedId}/{memberId}', [AdminController::class, 'SubmitRefundForm'])->name('request-refund-payment');
    Route::get('yearly-Tax-Letter', [AdminController::class, 'YearlyTaxLetter'])->name('yearly-Tax-Letter');
    Route::post('download-yearly-Tax-Letter', [AdminController::class, 'DownlaodTaxLetter'])->name('download-yearly-Tax-Letter');

    // Service Controller

    Route::get('Service-Request', [ServiceRequestController::class, 'ServiceRequest'])->name('ServiceRequest');
    Route::post('Service-Request', [ServiceRequestController::class, 'addServiceRequest'])->name('service-request');
    Route::get('my-service-request', [ServiceRequestController::class, 'index'])->name('my-service-request');
    Route::post('GetServicesByCategory', [ServiceRequestController::class, 'GetServicesByCategory'])->name('GetServicesByCategory');
});