<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PledgeForm extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$currency = '';

		$this->$currency =  GeneralSettings();
	}

	public function index(){


		$data['page'] = 'PLEDGE FORM';
		$data['title'] = 'PLEDGE FORM';


		$ch = curl_init();

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].filterAPI()['url']);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$productID = ApiBaseUrl()['productID'];
		$clientID = ApiBaseUrl()['clientID'];

		$postjsondata = [
			"componentConfig" => [
				"query" => [
					"aspectType" => "ServiceSetup",
					"serviceCategoryTypes" => "IN-TEMPLE",
					"serviceTypes" => "PUJA",
					"bookingType" => "PLEDGE FORM",
					"sourceTypes" => "WEBSITE",
					"status" => "ACTIVE"
				],
				"moduleName" => "Temple Services",
				"aspectType" => "ServiceSetup",
				"collectionType" => "Business",
				"productID" => $productID,
				"clientID" => $clientID,
				"skip" => 0,
				"next" => 1024
			]
		];

		$postData = json_encode($postjsondata);

		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


		$token = $this->session->userdata('token');
		$headers = array();
		$headers[] = 'Authorization: Bearer '.$token.'';
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$response = json_decode($result, true);

		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}

		curl_close($ch);

// echo '<pre>';
// print_r();
// die();

		$data['recurring_donations'] = $response['data'];

		$this->load->view('pledge-form/pledge-form-new', $data);
	}




	public function addCart(){

		// print_r($this->input->post());
		if($this->input->post())
		{
			$this->session->set_userdata('pledge_cart', $this->input->post());

			$cartList = $this->session->userdata('pledge_cart');
		}


		$response = array(
			'status' => '1', 
			'message' => "Success"
		);
		echo json_encode($response);
	}
public function validateCard($card_number, $exp_date, $cvv, $card_holder){

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, 'https://aspgen.vaaptech.com:9000/api/payment/validatePaymentCard');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		$data = array(
			"paymentAccountNumber" => $card_number,
			"expirationDate" => $exp_date,
			"securityCode" => $cvv,
			"name" => $card_holder,
			"street" => "street",
			"city" => "city",
			"state" => "VA",
			"zip" => "12345",
			"countryCode" => "",
			"phone" => base64_decode($this->session->userdata('phone')),
			"email" => base64_decode($this->session->userdata('email')),
			"clientId" => ApiBaseUrl()['clientID'],
			"amount" => 700
		);

		$json_data = json_encode($data);

		curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);


		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$response = json_decode($result, true);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		return $response;
	}

	public function SubmitPledgeForm(){


		$debitFequency = $this->input->post('debitFequency') ? $this->input->post('debitFequency') : '';
		$startDailyDate = $this->input->post('startDailyDate') ? $this->input->post('startDailyDate') : '';
		$endDailyDate = $this->input->post('endDailyDate') ? $this->input->post('endDailyDate') : '';
		$startWeeklyDate = $this->input->post('startWeeklyDate') ? $this->input->post('startWeeklyDate') : '';
		$endWeeklyDate = $this->input->post('endWeeklyDate') ? $this->input->post('endWeeklyDate') : '';
		$startMonthlyDate = $this->input->post('startMonthlyDate') ? $this->input->post('startMonthlyDate') : '';
		$endMonthlyDate = $this->input->post('endMonthlyDate') ? $this->input->post('endMonthlyDate') : '';
		$selectAnualyMonthValue = $this->input->post('selectAnualyMonthValue') ? $this->input->post('selectAnualyMonthValue') : '';
		$selectAnualyDateValue = $this->input->post('selectAnualyDateValue') ?$this->input->post('selectAnualyDateValue') : '';
		$startAnualyDate = $this->input->post('startAnualyDate') ? $this->input->post('startAnualyDate') : '';
		$endAnualyDate = $this->input->post('endAnualyDate') ? $this->input->post('endAnualyDate') : '';
		
		$creditcard = $this->input->post('creditcard') ? $this->input->post('creditcard') : '';

		$card_number = $this->input->post('card-number') ? $this->input->post('card-number') : '';
		$exp_date = $this->input->post('exp-date') ? $this->input->post('exp-date') : '';
		$cvv = $this->input->post('cvv') ? $this->input->post('cvv') : '';
		$card_holder = $this->input->post('card-holder') ? $this->input->post('card-holder') : '';

		$serviceAmt = $this->input->post('serviceAmt');



		$validate_card_response = $this->validateCard($card_number, $exp_date, $cvv, $card_holder);
		

		// print_r($validate_card_response);

		
		$token = '';
		$OrganizationId = '';
		if ($validate_card_response['statusCode'] == 1) {
			$token = $validate_card_response['data']['token'];
			$OrganizationId = $validate_card_response['data']['authorizationCode'];
		}else{
			echo json_encode($validate_card_response);
			return;
		}



		$cart_data = $this->session->userdata('pledge_cart');


		for ($i = 0; $i < count($cart_data['ids']); $i++) {



			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].'api/bookingService/addPledgeForm');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			$data = array(
				"clientId" => ApiBaseUrl()['clientID'],
				"dataJson" => array(
					"memberId" => $this->session->userdata('id'),
					"firstName" => "",
					"lastName" => "",
					"memberName" => $this->session->userdata('refDataName'),
					"prsnEmail" => base64_decode($this->session->userdata('email')),
					"prsnPhone" => base64_decode($this->session->userdata('phone')),
					"noOfPaymentName" => "",
					"paymentReminderName" => "",
					"serviceName" => $cart_data['serviceName'][$i],
					"serviceId" => $cart_data['ids'][$i],
					"serviceAmount" => $cart_data['serviceAmount'][$i],
					"pledgeForName" => "",
					"modeOfPaymentName" => "",
					"achBankAddress" => "",
					"achBankCode" => "",
					"achRoutingNo" => "",
					"achBankName" => "",
					"accNo" => "",
					"accName" => "",
					"bankName" => "",
					"checkNo" => "",
					"checkDate" => "",
					"cardZipCode" => "",
					"cvvNo" => $cvv,
					"expiryDate" => $exp_date,
					"cardNo" => $card_number,
					"cardHolderName" => $card_holder,
					"debitFequency" => $debitFequency,
					"startDailyDate" => $startDailyDate,
					"endDailyDate" => $endDailyDate,
					"startWeeklyDate" => $startWeeklyDate,
					"endWeeklyDate" => $endWeeklyDate,
					"selectWeeklyDay" => "",
					"startMonthlyDate" => $startMonthlyDate,
					"endMonthlyDate" => $endMonthlyDate,
					"selectmonthDate" => "",
					"selectAnualyMonthValue" => $selectAnualyMonthValue,
					"selectAnualyDateValue" => $selectAnualyDateValue,
					"startAnualyDate" => $startAnualyDate,
					"endAnualyDate" => $endAnualyDate,
					"OrganizationId" => $OrganizationId,
					"token" => $token
				)
			);

			$jsonData = json_encode($data);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);


			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$payment_result = curl_exec($ch);
			$payment_response = json_decode($payment_result, true);;
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

		}


		// print_r($payment_response);

		if ($payment_response['statusCode'] == 1) {
			$this->session->unset_userdata('pledge_cart');
		}
		echo json_encode($payment_response);


	}
}