<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Checkout extends CI_Controller {

	public function __construct() {
		parent::__construct();



	}
	public function index($page = ''){



		$data['GeneralSettings'] = GeneralSettings();


		// print_r($data['GeneralSettings']); die();
		if (!empty($this->session->userdata('logged_in')) && $this->session->userdata('logged_in') == 1) {

			$response = getUserDetails();
			$data['userDetails'] = $response->data[0];
			$data['GetState'] = GetState();
			$data['preferredLanguage'] = getPreferredLanguage();
			$data['page'] = 'Facilities';
			$data['title'] = 'Checkout';
			$data['session_data'] = 'facilities_cart';
			

			$this->load->view('facilities/checkout.php',$data);

		}else{
			redirect(base_url());
		}
	}



	public function updateRequestDetailsWithoutReloadingPage() {

		$cart_items = $this->session->userdata('facilities_cart'); 
		$currencySymbol = getCurrencySymbol();
		$GeneralSettings = GeneralSettings();


		$html = ''; 

    // Start building HTML content

		$html .= '<div class="d-flex justify-content-between align-items-center mb-5">';

    // Count the number of items in the cart
		// $numItems = count($cart_items['ids']);
		// $html .= '<h6 class="mb-0 text-muted">' . $numItems . ' items</h6>';
		$html .= '</div>';

		$html .= '<div class="row mb-4 d-flex justify-content-between align-items-center">';
		$html .= '<div class="col-md-6 col-lg-6 col-xl-6">';
		$html .= '<h6 class="text-black fw-bold mb-0" style="color: rgb(240 18 18) !important;font-size:25px">Facilities</h6>';
		$html .= '</div>';
		$html .= '<div class="col-md-6 col-lg-6 col-xl-6" style="display:contents!important;">';
		$html .= '<h6 class="text-black fw-bold mb-0" style="color: rgb(240 18 18) !important;font-size:25px">Price</h6>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '<hr class="my-4">';

    // Loop through cart items and calculate total amount
		$payNowTotalAmount = 0;
		foreach ($cart_items['ids'] as $key => $value) {
			if ($cart_items['serviceAmount'][$key] > 0) {
				$payNowTotalAmount += $cart_items['serviceAmount'][$key];
			}

        // Add item details to HTML
			$html .= '<div class="row mb-4 d-flex justify-content-between align-items-center">';
			$html .= '<div class="col-md-6 col-lg-6 col-xl-6 text-start">';
			$html .= '<h6 class="text-black fw-bold mb-0">' . $cart_items['serviceName'][$key] . '</h6>';
			$html .= '</div>';
			$html .= '<div class="col-md-6 col-lg-6 col-xl-6 text-end px-0">';
			$html .= '<h6 class="mb-0 text-end"><span style="font-weight:bold!important;">' . $currencySymbol . '&nbsp;' . price_format($cart_items['serviceAmount'][$key], 2) . '</span></h6>';
			$html .= '</div>';
			$html .= '</div>';
		}

    // Calculate total amount with tax if applicable
		if (!empty($GeneralSettings['TaxPercent']) && $GeneralSettings['TaxPercent'] > 0) {
			$payNowTotalAmount = ($payNowTotalAmount * $GeneralSettings['TaxPercent']) / 100;
		}

		// $html .= '<hr class="my-4">';
		// $html .= '<div class="row mt-3">';
		// $html .= '<div class="col-md-6"><h5 class="mb-0" style="font-weight:bold!important;">Subtotal</h5></div>';
		// $html .= '<div class="col-md-6 text-end" style="padding:0!important"><span style="font-weight:bold!important;">' . $currencySymbol . '&nbsp;' . price_format($cart_items['totalPrice'], 2) . '</span></div>';
		// $html .= '</div>';

    // Add tax details if applicable
		if (!empty($GeneralSettings['TaxPercent']) && $GeneralSettings['TaxPercent'] > 0) {
			$html .= '<div class="row mt-3">';
			$html .= '<div class="col-md-10"><h5 class="mb-0" style="font-weight:bold!important;">Tax (' . $GeneralSettings['TaxPercent'] . '%)</h5></div>';
			$html .= '<div class="col-md-2 text-end"><span style="font-weight:bold!important;">' . $currencySymbol . ' ' . price_format(($cart_items['totalPrice'] * $GeneralSettings['TaxPercent']) / 100, 2) . '</span></div>';
			$html .= '</div>';
		}

    // Calculate and add sale total
		$saleTotal = (($cart_items['totalPrice'] * ($GeneralSettings['TaxPercent'] ? $GeneralSettings['TaxPercent'] : 0) ) / 100) + $cart_items['totalPrice'];
		$html .= '<hr class="my-4">';
		$html .= '<div class="row py-3 px-0" style="background-color:#dbdbdb">';
		$html .= '<div class="col-md-8"><h4 class="text-dark" style="margin-top:auto;margin-bottom:auto;font-weight: bold!important;">Sale Total Amount</h4></div>';
		$html .= '<div class="col-md-4 px-0">';
		$html .= '<h4 class="text-dark text-end px-2" style="margin-top:auto;margin-bottom:auto;font-weight: bold!important;">' . $currencySymbol . '&nbsp;' . price_format($saleTotal, 2) . '</h4>';
		$html .= '</div>';
		$html .= '</div>';
	

    // Return the generated HTML content
		echo $html;
	}


}